/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.data.schule;

import de.svws_nrw.core.transpiler.TranspilerDTO;
import de.svws_nrw.core.types.schule.Schulform;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.ArrayList;
import java.util.List;

@XmlRootElement
@Schema(description="ein Eintrag in dem Katalog der Organistationsformen.")
@TranspilerDTO
public class OrganisationsformKatalogEintrag {
    @Schema(description="die ID des Katalog-Eintrags", example="4711")
    public long id;
    @Schema(description="das K\u00fcrzel der Organisationsform", example="1")
    @NotNull
    public String kuerzel = "";
    @Schema(description="die Beschreibung der Organisationsform", example="Teilnahme am gebundenen Ganztag")
    @NotNull
    public String beschreibung = "";
    @Schema(description="die K\u00fcrzel der Schulformen, bei welchen die Organisationsform vorkommt")
    @NotNull
    public @NotNull List<@NotNull String> schulformen = new ArrayList<String>();
    @Schema(description="gibt an, in welchem Schuljahr die Organisationsform einf\u00fchrt wurde. Ist kein Schuljahr bekannt, so ist null gesetzt", example="null")
    public Integer gueltigVon = null;
    @Schema(description="gibt an, bis zu welchem Schuljahr die Organisationsform g\u00fcltig ist. Ist kein Schuljahr bekannt, so ist null gesetzt", example="2025")
    public Integer gueltigBis = null;

    public OrganisationsformKatalogEintrag() {
    }

    public OrganisationsformKatalogEintrag(long id, @NotNull String kuerzel, @NotNull String beschreibung, @NotNull @NotNull List<@NotNull Schulform> schulformen, Integer gueltigVon, Integer gueltigBis) {
        this.id = id;
        this.kuerzel = kuerzel;
        this.beschreibung = beschreibung;
        for (Schulform schulform : schulformen) {
            this.schulformen.add(schulform.daten.kuerzel);
        }
        this.gueltigVon = gueltigVon;
        this.gueltigBis = gueltigBis;
    }
}

