/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.data.schule;

import de.svws_nrw.core.transpiler.TranspilerDTO;
import de.svws_nrw.core.types.schule.Schulform;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.ArrayList;
import java.util.List;

@XmlRootElement
@Schema(description="ein Eintrag in dem Reformp\u00e4dagogik Katalog.")
@TranspilerDTO
public class ReformpaedagogikKatalogEintrag {
    @Schema(description="die ID des Katalog-Eintrags", example="4711")
    public long id;
    @Schema(description="das K\u00fcrzel", example="M")
    @NotNull
    public String kuerzel = "";
    @Schema(description="die Bezeichnung", example="Montessori")
    @NotNull
    public String bezeichnung = "";
    @Schema(description="die K\u00fcrzel der Schulformen, bei welchen der Eintrag vorkommen darf")
    @NotNull
    public @NotNull List<@NotNull String> schulformen = new ArrayList<String>();
    @Schema(description="gibt an, in welchem der Eintrag einf\u00fchrt wurde. Ist kein Schuljahr bekannt, so ist null gesetzt", example="null")
    public Integer gueltigVon = null;
    @Schema(description="gibt an, bis zu welchem der Eintrag g\u00fcltig ist. Ist kein Schuljahr bekannt, so ist null gesetzt", example="2025")
    public Integer gueltigBis = null;

    public ReformpaedagogikKatalogEintrag() {
    }

    public ReformpaedagogikKatalogEintrag(long id, @NotNull String kuerzel, @NotNull String bezeichnung, @NotNull @NotNull List<@NotNull Schulform> schulformen, Integer gueltigVon, Integer gueltigBis) {
        this.id = id;
        this.kuerzel = kuerzel;
        this.bezeichnung = bezeichnung;
        for (Schulform schulform : schulformen) {
            this.schulformen.add(schulform.daten.kuerzel);
        }
        this.gueltigVon = gueltigVon;
        this.gueltigBis = gueltigBis;
    }
}

