/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.data.schule;

import de.svws_nrw.core.data.CoreTypeData;
import de.svws_nrw.core.transpiler.TranspilerDTO;
import de.svws_nrw.core.types.schule.BerufskollegAnlage;
import de.svws_nrw.core.types.schule.SchulabschlussAllgemeinbildend;
import de.svws_nrw.core.types.schule.SchulabschlussBerufsbildend;
import de.svws_nrw.core.types.schule.Schulform;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.ArrayList;
import java.util.List;

@XmlRootElement
@Schema(description="ein Eintrag in dem Katalog der Schulformen.")
@TranspilerDTO
public class SchulgliederungKatalogEintrag
extends CoreTypeData {
    @Schema(description="das K\u00fcrzel der Schulgliederung, welches im Rahmen der amtlichen Schulstatistik verwendet wird", example="A01")
    @NotNull
    public String kuerzel = "";
    @Schema(description="gibt an, ob es sich um einen Bildungsgang am Berufskolleg handelt", example="true")
    public boolean istBK = false;
    @Schema(description="die K\u00fcrzel der Schulformen, bei welchen die Schulgliederung vorkommt")
    @NotNull
    public @NotNull List<@NotNull String> schulformen = new ArrayList<String>();
    @Schema(description="gibt an, ob es sich um eine auslaufende Schulgliederung oder einen auslaufenden Bildungsgang handelt", example="false")
    public boolean istAuslaufend = false;
    @Schema(description="gibt an, ob es sich um eine ausgelaufene Schulgliederung oder einen ausgelaufenen Bildungsgang handelt", example="false")
    public boolean istAusgelaufen = false;
    @Schema(description="die textuelle Beschreibung der Schulgliederung bzw. des Bildungsganges", example="Fachklassen (BS; TZ)")
    @NotNull
    public String beschreibung = "";
    @Schema(description="die Anlage, wenn es sich um einen Bildungsgang am Berufskolleg handelt", example="A")
    public String bkAnlage = null;
    @Schema(description="der Typ der Anlage, wenn es sich um einen Bildungsgang am Berufskolleg handelt", example="01")
    public String bkTyp = null;
    @Schema(description="der Index f\u00fcr den Zugriff auf die Fachklassen am Berufskolleg. Dieser kann bei unterschiedlichen Gliederungen identisch sein.", example="10")
    public Integer bkIndex = null;
    @Schema(description="gibt an, ob es sich um einen Bildungsgang in Vollzeit handelt oder nicht.", example="false")
    public boolean istVZ = false;
    @Schema(description="gibt den berufsbildenden Abschluss an, der in diesem Bildungsgang erreicht werden kann, wenn es sich um einen Bildungsgang am Berufskolleg handelt", example="BS")
    @NotNull
    public @NotNull List<@NotNull String> bkAbschlussBerufsbildend = new ArrayList<String>();
    @Schema(description="gibt eine Liste von allgemeinbildenden Abschl\u00fcssen an, die in diesem Bildungsgang erreicht werden k\u00f6nnen, wenn es sich um einen Bildungsgang am Berufskolleg handelt", example="HA9")
    @NotNull
    public @NotNull List<@NotNull String> bkAbschlussAllgemeinbildend = new ArrayList<String>();

    public SchulgliederungKatalogEintrag() {
    }

    public SchulgliederungKatalogEintrag(long id, @NotNull String kuerzel, boolean istBK, @NotNull @NotNull List<@NotNull Schulform> schulformen, boolean istAuslaufend, boolean istAusgelaufen, @NotNull String beschreibung, BerufskollegAnlage bkAnlage, String bkTyp, Integer bkIndex, boolean istVZ, List<@NotNull SchulabschlussBerufsbildend> bkAbschlussBerufsbildend, List<@NotNull SchulabschlussAllgemeinbildend> bkAbschlussAllgemeinbildend, Integer gueltigVon, Integer gueltigBis) {
        this.id = id;
        this.kuerzel = kuerzel;
        this.istBK = istBK;
        for (Schulform schulform : schulformen) {
            this.schulformen.add(schulform.daten.kuerzel);
        }
        this.istAuslaufend = istAuslaufend;
        this.istAusgelaufen = istAusgelaufen;
        this.beschreibung = beschreibung;
        this.bkAnlage = bkAnlage == null ? null : bkAnlage.daten.kuerzel;
        this.bkTyp = bkTyp;
        this.bkIndex = bkIndex;
        this.istVZ = istVZ;
        if (bkAbschlussBerufsbildend != null) {
            for (SchulabschlussBerufsbildend sbb : bkAbschlussBerufsbildend) {
                this.bkAbschlussBerufsbildend.add(sbb.daten.kuerzel);
            }
        }
        if (bkAbschlussAllgemeinbildend != null) {
            for (SchulabschlussAllgemeinbildend sab : bkAbschlussAllgemeinbildend) {
                this.bkAbschlussAllgemeinbildend.add(sab.daten.kuerzel);
            }
        }
        this.gueltigVon = gueltigVon;
        this.gueltigBis = gueltigBis;
    }
}

