/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.data.schule;

import de.svws_nrw.core.data.CoreTypeData;
import de.svws_nrw.core.transpiler.TranspilerDTO;
import de.svws_nrw.core.types.schule.Schulform;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.ArrayList;
import java.util.List;

@XmlRootElement
@Schema(description="ein Eintrag im Katalog der Schulstufen.")
@TranspilerDTO
public class SchulstufeKatalogEintrag
extends CoreTypeData {
    @Schema(description="das eindeutige K\u00fcrzel des Katalog-Eintrags", example="SI")
    @NotNull
    public String kuerzel = "";
    @Schema(description="die Bezeichnung des Katalog-Eintrags", example="Sekundarstufe I")
    @NotNull
    public String bezeichnung = "";
    @Schema(description="die K\u00fcrzel der Schulformen die bei der Schulstufe vorkommen")
    @NotNull
    public @NotNull List<@NotNull String> schulformen = new ArrayList<String>();

    public SchulstufeKatalogEintrag() {
    }

    public SchulstufeKatalogEintrag(long id, @NotNull String kuerzel, @NotNull String bezeichnung, @NotNull @NotNull List<@NotNull Schulform> schulformen, Integer gueltigVon, Integer gueltigBis) {
        this.id = id;
        this.kuerzel = kuerzel;
        this.bezeichnung = bezeichnung;
        for (Schulform schulform : schulformen) {
            this.schulformen.add(schulform.daten.kuerzel);
        }
        this.gueltigVon = gueltigVon;
        this.gueltigBis = gueltigBis;
    }
}

