/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.data.stundenplan;

import de.svws_nrw.core.data.stundenplan.StundenplanAufsichtsbereich;
import de.svws_nrw.core.data.stundenplan.StundenplanJahrgang;
import de.svws_nrw.core.data.stundenplan.StundenplanKalenderwochenzuordnung;
import de.svws_nrw.core.data.stundenplan.StundenplanPausenzeit;
import de.svws_nrw.core.data.stundenplan.StundenplanRaum;
import de.svws_nrw.core.data.stundenplan.StundenplanSchiene;
import de.svws_nrw.core.data.stundenplan.StundenplanZeitraster;
import de.svws_nrw.core.transpiler.TranspilerDTO;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.ArrayList;
import java.util.List;

@XmlRootElement
@Schema(description="Die Grunddaten des Stundenplans.")
@TranspilerDTO
public class Stundenplan {
    @Schema(description="die ID des Stundenplans", example="815")
    public long id = -1L;
    @Schema(description="die ID des Schuljahresabschnitts des Stundenplans", example="7")
    public long idSchuljahresabschnitt = -1L;
    @Schema(description="das Datum, ab dem der Stundenpland g\u00fcltig ist", example="1.1.1899")
    @NotNull
    public String gueltigAb = "";
    @Schema(description="das Datum, bis wann der Stundenplan g\u00fcltig ist", example="31.7.3218")
    @NotNull
    public String gueltigBis = "";
    @Schema(description="die textuelle Beschreibung des Stundenplans", example="Stundenplan zum Schuljahresanfang")
    @NotNull
    public String bezeichnungStundenplan = "";
    @Schema(description="das Modell f\u00fcr die Wochen an, d.h. ob es sich um einen Stundenplan f\u00fcr jede Woche handelt (0) oder ob es sich um einen unterschiedliche Stundenpl\u00e4ne in Abh\u00e4ngigkeit des Wochentyps handelt - z.B. A-/B-Wochen (2) handelt. Hier wird dann die maximale Anzahl der unterschiedlichen Wochentypen festgelegt.", example="1")
    public int wochenTypModell = 0;
    @Schema(description="das Zeitraster des Stundenplans")
    @NotNull
    public @NotNull List<@NotNull StundenplanZeitraster> zeitraster = new ArrayList<StundenplanZeitraster>();
    @Schema(description="die Liste der R\u00e4ume, die f\u00fcr den Stundenplan zur Verf\u00fcgung stehen")
    @NotNull
    public @NotNull List<@NotNull StundenplanRaum> raeume = new ArrayList<StundenplanRaum>();
    @Schema(description="die Liste der Schienen, die f\u00fcr den Stundenplan angelegt sind")
    @NotNull
    public @NotNull List<@NotNull StundenplanSchiene> schienen = new ArrayList<StundenplanSchiene>();
    @Schema(description="die Liste der Pausenzeiten, bei welchen Aufsichten eingeteilt werden m\u00fcssen")
    @NotNull
    public @NotNull List<@NotNull StundenplanPausenzeit> pausenzeiten = new ArrayList<StundenplanPausenzeit>();
    @Schema(description="die Liste der Aufsichtsbereiche in Pausen, f\u00fcr welche Aufsichten eingeteilt werden m\u00fcssen")
    @NotNull
    public @NotNull List<@NotNull StundenplanAufsichtsbereich> aufsichtsbereiche = new ArrayList<StundenplanAufsichtsbereich>();
    @Schema(description="die Liste der Kalenderwochen-Zuordnungen, sofern unterschiedliche Wochentypen in einer Woche genutzt werden")
    @NotNull
    public @NotNull List<@NotNull StundenplanKalenderwochenzuordnung> kalenderwochenZuordnung = new ArrayList<StundenplanKalenderwochenzuordnung>();
    @Schema(description="die Liste der Jahrg\u00e4nge, die f\u00fcr den Stundenplan zur Verf\u00fcgung stehen")
    @NotNull
    public @NotNull List<@NotNull StundenplanJahrgang> jahrgaenge = new ArrayList<StundenplanJahrgang>();
}

