/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.data.stundenplan;

import de.svws_nrw.core.transpiler.TranspilerDTO;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.ArrayList;
import java.util.List;

@XmlRootElement
@Schema(description="eine Pausenzeit eines Stundenplans.")
@TranspilerDTO
public class StundenplanPausenzeit {
    @Schema(description="die ID der Pausenzeit", example="4711")
    public long id = -1L;
    @Schema(description="der Wochentag f\u00fcr die Pausenzeit (1=Montag, 2=Dienstag, ..., 7=Sonntag)", example="1")
    public int wochentag = 1;
    @Schema(description="die Uhrzeit in Minuten seit 0 Uhr, wann die Pause beginnt", example="610")
    public Integer beginn = null;
    @Schema(description="die Uhrzeit in Minuten seit 0 Uhr, wann die Pause endet", example="630")
    public Integer ende = null;
    @Schema(description="die Bezeichnung der Pausenzeit, welche die Art der Pausenzeit genauer beschreibt", example="Mittagspause")
    @NotNull
    public String bezeichnung = "Pause";
    @ArraySchema(schema=@Schema(implementation=Long.class, description="Ein Array mit den IDs der Klassen, denen diese Pausenzeit zugeordnet sind. Ist die Liste leer, so gilt die Pausenzeit f\u00fcr alle Klassen!"))
    @NotNull
    public @NotNull List<@NotNull Long> klassen = new ArrayList<Long>();
}

