/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.exceptions;

import de.svws_nrw.core.adt.map.HashMap2D;
import de.svws_nrw.core.adt.map.HashMap3D;
import jakarta.validation.constraints.NotNull;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DeveloperNotificationException
extends RuntimeException {
    private static final long serialVersionUID = 9106453927748350030L;

    public DeveloperNotificationException(@NotNull String pFehlermeldung) {
        super(pFehlermeldung);
    }

    public static void ifTrue(@NotNull String pBeschreibung, boolean pErfuellt) {
        if (pErfuellt) {
            throw new DeveloperNotificationException(pBeschreibung);
        }
    }

    public static void ifInvalidID(@NotNull String pVariablenname, long pID) throws DeveloperNotificationException {
        if (pID < 0L) {
            throw new DeveloperNotificationException(pVariablenname + " hat eine ung\u00fcltige ID=" + pID + "!");
        }
    }

    @NotNull
    public static <T> T ifNull(@NotNull String pBeschreibung, T pWert) throws DeveloperNotificationException {
        if (pWert == null) {
            throw new DeveloperNotificationException(pBeschreibung + " sollte nicht NULL sein!");
        }
        return pWert;
    }

    public static void ifNotInRange(@NotNull String pVariablenname, long pWert, long pMinimum, long pMaximum) throws DeveloperNotificationException {
        if (pWert < pMinimum || pWert > pMaximum) {
            throw new DeveloperNotificationException(pVariablenname + "(" + pWert + ") muss in dem Bereich [ " + pMinimum + ", " + pMaximum + " ] liegen!");
        }
    }

    public static void ifSmaller(@NotNull String pVariablenname, long pWert, long pMinimum) throws DeveloperNotificationException {
        if (pWert < pMinimum) {
            throw new DeveloperNotificationException(pVariablenname + "(" + pWert + ") darf nicht kleiner sein als " + pMinimum + "!");
        }
    }

    public static void ifGreater(@NotNull String pVariablenname, long pWert, long pMaximum) throws DeveloperNotificationException {
        if (pWert > pMaximum) {
            throw new DeveloperNotificationException(pVariablenname + "(" + pWert + ") darf nicht gr\u00f6\u00dfer sein als " + pMaximum + "!");
        }
    }

    public static void ifEqual(@NotNull String pVariablenname, long pVariable, long pWert) throws DeveloperNotificationException {
        if (pVariable == pWert) {
            throw new DeveloperNotificationException(pVariablenname + "(" + pWert + ") darf nicht gleich " + pWert + " sein!");
        }
    }

    public static void ifStringIsBlank(@NotNull String nameDerVariablen, @NotNull String zeichenkette) {
        if (zeichenkette.isBlank()) {
            throw new DeveloperNotificationException(nameDerVariablen + " darf nicht 'blank' sein!");
        }
    }

    public static <K, V> void ifMapContains(@NotNull String pMapName, @NotNull @NotNull Map<@NotNull K, @NotNull V> pMap, @NotNull K pKey) throws DeveloperNotificationException {
        if (pMap.containsKey(pKey)) {
            throw new DeveloperNotificationException(pMapName + " hat bereits den KEY " + String.valueOf(pKey));
        }
    }

    public static <K, V> void ifMapNotContains(@NotNull String pMapName, @NotNull @NotNull Map<@NotNull K, @NotNull V> pMap, @NotNull K pKey) throws DeveloperNotificationException {
        if (!pMap.containsKey(pKey)) {
            throw new DeveloperNotificationException(pMapName + " hat nicht den KEY " + String.valueOf(pKey));
        }
    }

    public static <K, V> void ifMapPutOverwrites(@NotNull @NotNull Map<@NotNull K, @NotNull V> map, @NotNull K key, @NotNull V value) throws DeveloperNotificationException {
        if (map.containsKey(key)) {
            throw new DeveloperNotificationException("PUT von " + String.valueOf(key) + " --> " + String.valueOf(value) + " fehlgeschlagen, da bereits " + String.valueOf(map.get(key)) + " zugeordnet ist!");
        }
        map.put(key, value);
    }

    public static <K1, K2, V> void ifMap2DPutOverwrites(@NotNull @NotNull HashMap2D<@NotNull K1, @NotNull K2, @NotNull V> map, @NotNull K1 key1, @NotNull K2 key2, @NotNull V value) throws DeveloperNotificationException {
        if (map.contains(key1, key2)) {
            throw new DeveloperNotificationException("PUT von (" + String.valueOf(key1) + ", " + String.valueOf(key2) + ") --> " + String.valueOf(value) + " fehlgeschlagen, da bereits " + String.valueOf(map.getOrException(key1, key2)) + " zugeordnet ist!");
        }
        map.put(key1, key2, value);
    }

    @NotNull
    public static <K, V> V ifMapGetIsNull(@NotNull @NotNull Map<@NotNull K, @NotNull V> map, @NotNull K key) throws DeveloperNotificationException {
        if (!map.containsKey(key)) {
            throw new DeveloperNotificationException("GET von " + String.valueOf(key) + " fehlgeschlagen, da kein Mapping existiert!");
        }
        V value = map.get(key);
        if (value == null) {
            throw new DeveloperNotificationException("GET von " + String.valueOf(key) + " fehlgeschlagen, da es auf NULL mapped!");
        }
        return value;
    }

    @NotNull
    public static <K, V> V ifMapRemoveFailes(@NotNull @NotNull Map<@NotNull K, @NotNull V> map, @NotNull K key) throws DeveloperNotificationException {
        V value = map.remove(key);
        if (value == null) {
            throw new DeveloperNotificationException("REMOVE von " + String.valueOf(key) + " fehlgeschlagen, da kein Mapping existiert!");
        }
        return value;
    }

    @NotNull
    public static <K1, K2, V> V ifMap2DGetIsNull(@NotNull @NotNull HashMap2D<@NotNull K1, @NotNull K2, @NotNull V> map, @NotNull K1 key1, @NotNull K2 key2) throws DeveloperNotificationException {
        if (!map.contains(key1, key2)) {
            throw new DeveloperNotificationException("GET von (" + String.valueOf(key1) + ", " + String.valueOf(key2) + ") fehlgeschlagen, da kein Mapping existiert!");
        }
        return map.getNonNullOrException(key1, key2);
    }

    @NotNull
    public static <K1, K2, V> V ifMap2DRemoveFailes(@NotNull @NotNull HashMap2D<@NotNull K1, @NotNull K2, @NotNull V> map, @NotNull K1 key1, @NotNull K2 key2) throws DeveloperNotificationException {
        V value = map.removeOrException(key1, key2);
        if (value == null) {
            throw new DeveloperNotificationException("GET von (" + String.valueOf(key1) + ", " + String.valueOf(key2) + ") fehlgeschlagen, da kein Mapping existiert!");
        }
        return value;
    }

    @NotNull
    public static <K1, K2, K3, V> V ifMap3DGetIsNull(@NotNull @NotNull HashMap3D<@NotNull K1, @NotNull K2, @NotNull K3, @NotNull V> map, @NotNull K1 key1, @NotNull K2 key2, @NotNull K3 key3) throws DeveloperNotificationException {
        if (!map.contains(key1, key2, key3)) {
            throw new DeveloperNotificationException("GET von (" + String.valueOf(key1) + ", " + String.valueOf(key2) + ", " + String.valueOf(key3) + ") fehlgeschlagen, da kein Mapping existiert!");
        }
        return map.getNonNullOrException(key1, key2, key3);
    }

    public static <E> void ifListNotContains(@NotNull String listName, @NotNull @NotNull List<@NotNull E> list, @NotNull E value) throws DeveloperNotificationException {
        if (!list.contains(value)) {
            throw new DeveloperNotificationException(listName + " hat kein Element " + String.valueOf(value) + "!");
        }
    }

    public static <E> void ifListAddsDuplicate(@NotNull String listName, @NotNull @NotNull List<@NotNull E> list, @NotNull E value) throws DeveloperNotificationException {
        if (list.contains(value)) {
            throw new DeveloperNotificationException(listName + " hat bereits das Element " + String.valueOf(value) + "!");
        }
        list.add(value);
    }

    public static <E> void ifListRemoveFailes(@NotNull String listName, @NotNull @NotNull List<@NotNull E> list, @NotNull E value) throws DeveloperNotificationException {
        if (!list.remove(value)) {
            throw new DeveloperNotificationException(listName + " konnte Element " + String.valueOf(value) + " nicht entfernen!");
        }
    }

    @NotNull
    public static <E> E ifListGetFirstFailes(@NotNull String listName, @NotNull @NotNull List<@NotNull E> list) throws DeveloperNotificationException {
        if (list.isEmpty()) {
            throw new DeveloperNotificationException(listName + " hat kein erstes Element!");
        }
        E first = list.get(0);
        if (first == null) {
            throw new DeveloperNotificationException(listName + " hat zwar ein erstes Element, aber es ist NULL!");
        }
        return first;
    }

    @NotNull
    public static <E> E ifListGetLastFailes(@NotNull String listName, @NotNull @NotNull List<@NotNull E> list) throws DeveloperNotificationException {
        if (list.isEmpty()) {
            throw new DeveloperNotificationException(listName + " hat kein letztes Element!");
        }
        E last = list.get(list.size() - 1);
        if (last == null) {
            throw new DeveloperNotificationException(listName + " hat zwar ein letztes Element, aber es ist NULL!");
        }
        return last;
    }

    public static <E> void ifCollectionIsEmpty(@NotNull String listName, @NotNull @NotNull Collection<@NotNull E> collection) throws DeveloperNotificationException {
        if (collection.isEmpty()) {
            throw new DeveloperNotificationException("Die Liste '" + listName + "' darf nicht leer sein!");
        }
    }

    public static <E> void ifSetAddsDuplicate(@NotNull String setName, @NotNull @NotNull Set<@NotNull E> set, @NotNull E value) throws DeveloperNotificationException {
        if (!set.add(value)) {
            throw new DeveloperNotificationException(setName + " hat bereits das Element " + String.valueOf(value) + "!");
        }
    }

    public static <E> void ifSetRemoveFailes(@NotNull String setName, @NotNull @NotNull Set<@NotNull E> set, @NotNull E value) throws DeveloperNotificationException {
        if (!set.remove(value)) {
            throw new DeveloperNotificationException(setName + " konnte Element " + String.valueOf(value) + " nicht entfernen!");
        }
    }

    public static <E> void ifSetContains(@NotNull String setName, @NotNull @NotNull Set<@NotNull E> set, @NotNull E value) throws DeveloperNotificationException {
        if (set.contains(value)) {
            throw new DeveloperNotificationException(setName + " hat darf " + String.valueOf(value) + " nicht enthalten!");
        }
    }

    public static <E> void ifSetNotContains(@NotNull String setName, @NotNull @NotNull Set<@NotNull E> set, @NotNull E value) throws DeveloperNotificationException {
        if (!set.contains(value)) {
            throw new DeveloperNotificationException(setName + " muss " + String.valueOf(value) + " enthalten!");
        }
    }

    public static int ifNotInt(String s) {
        if (s == null) {
            throw new DeveloperNotificationException("NULL-String kann nicht in eine Zahl umgwandelt werden");
        }
        return Integer.parseInt(s);
    }

    public static <E> void ifArrayIsEmpty(@NotNull String arrayName, @NotNull E[] values) throws DeveloperNotificationException {
        if (values.length == 0) {
            throw new DeveloperNotificationException("Das Array '" + arrayName + "' darf nicht leer sein!");
        }
    }
}

