/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.kursblockung;

import de.svws_nrw.core.Service;
import de.svws_nrw.core.kursblockung.KursblockungAlgorithmusK;
import de.svws_nrw.core.kursblockung.KursblockungAlgorithmusKFachwahlmatrix;
import de.svws_nrw.core.kursblockung.KursblockungAlgorithmusKMatching;
import de.svws_nrw.core.kursblockung.KursblockungAlgorithmusKOptimiereBest;
import de.svws_nrw.core.kursblockung.KursblockungAlgorithmusKSchnellW;
import de.svws_nrw.core.kursblockung.KursblockungAlgorithmusKSchuelervorschlag;
import de.svws_nrw.core.kursblockung.KursblockungAlgorithmusS;
import de.svws_nrw.core.kursblockung.KursblockungAlgorithmusSMatching;
import de.svws_nrw.core.kursblockung.KursblockungAlgorithmusSMatchingW;
import de.svws_nrw.core.kursblockung.KursblockungAlgorithmusSSchnellW;
import de.svws_nrw.core.kursblockung.KursblockungAlgorithmusSZufaellig;
import de.svws_nrw.core.kursblockung.KursblockungDynDaten;
import de.svws_nrw.core.logger.LogLevel;
import de.svws_nrw.core.utils.gost.GostBlockungsdatenManager;
import de.svws_nrw.core.utils.gost.GostBlockungsergebnisManager;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.Random;

public final class KursblockungAlgorithmus
extends Service<GostBlockungsdatenManager, ArrayList<GostBlockungsergebnisManager>> {
    @NotNull
    private static final Random _random = new Random();

    @Override
    @NotNull
    public @NotNull ArrayList<@NotNull GostBlockungsergebnisManager> handle(@NotNull GostBlockungsdatenManager pInput) {
        this.logger.modifyIndent(4);
        long seed = _random.nextLong();
        @NotNull Random random = new Random(seed);
        this.logger.log(LogLevel.APP, "Erster nextInt() Aufruf liefert " + seed);
        @NotNull KursblockungDynDaten dynDaten = new KursblockungDynDaten(random, this.logger, pInput);
        long zeitBedarf = dynDaten.gibBlockungszeitMillis();
        long zeitEndeGesamt = System.currentTimeMillis() + zeitBedarf;
        @NotNull ArrayList<@NotNull GostBlockungsergebnisManager> kursblockungOutputs = new ArrayList<GostBlockungsergebnisManager>();
        KursblockungAlgorithmusK[] algorithmenK = new KursblockungAlgorithmusK[]{new KursblockungAlgorithmusKSchnellW(random, this.logger, dynDaten), new KursblockungAlgorithmusKFachwahlmatrix(random, this.logger, dynDaten), new KursblockungAlgorithmusKMatching(random, this.logger, dynDaten), new KursblockungAlgorithmusKSchuelervorschlag(random, this.logger, dynDaten), new KursblockungAlgorithmusKOptimiereBest(random, this.logger, dynDaten)};
        KursblockungAlgorithmusS[] algorithmenS = new KursblockungAlgorithmusS[]{new KursblockungAlgorithmusSSchnellW(random, this.logger, dynDaten), new KursblockungAlgorithmusSZufaellig(random, this.logger, dynDaten), new KursblockungAlgorithmusSMatching(random, this.logger, dynDaten), new KursblockungAlgorithmusSMatchingW(random, this.logger, dynDaten)};
        long zeitProK = 100L;
        do {
            for (int iK = 0; iK < algorithmenK.length; ++iK) {
                long zeitEndeK = System.currentTimeMillis() + zeitProK;
                do {
                    KursblockungAlgorithmus.verwendeAlgorithmusK(algorithmenK[iK], zeitEndeK, dynDaten, algorithmenS, kursblockungOutputs, pInput);
                } while (System.currentTimeMillis() < zeitEndeK);
                if (System.currentTimeMillis() + zeitProK > zeitEndeGesamt) break;
            }
            zeitProK *= 2L;
        } while (System.currentTimeMillis() < zeitEndeGesamt);
        this.logger.modifyIndent(-4);
        return kursblockungOutputs;
    }

    private static void verwendeAlgorithmusK(@NotNull KursblockungAlgorithmusK kursblockungAlgorithmusK, long zeitEndeK, @NotNull KursblockungDynDaten dynDaten, @NotNull @NotNull KursblockungAlgorithmusS @NotNull [] algorithmenS, @NotNull @NotNull ArrayList<@NotNull GostBlockungsergebnisManager> outputs, @NotNull GostBlockungsdatenManager pInput) {
        kursblockungAlgorithmusK.berechne(zeitEndeK);
        dynDaten.aktionZustandSpeichernK();
        for (int iS = 0; iS < algorithmenS.length; ++iS) {
            algorithmenS[iS].berechne();
            if (dynDaten.gibCompareZustandK_NW_KD_FW() <= 0) continue;
            dynDaten.aktionZustandSpeichernK();
        }
        dynDaten.aktionZustandLadenK();
        if (dynDaten.gibCompareZustandG_NW_KD_FW() > 0) {
            dynDaten.aktionZustandSpeichernG();
        }
        @NotNull GostBlockungsergebnisManager out = dynDaten.gibErzeugtesKursblockungOutput(pInput, (long)outputs.size() + 1L);
        outputs.add(out);
    }
}

