/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.kursblockung;

import de.svws_nrw.core.kursblockung.KursblockungAlgorithmusK;
import de.svws_nrw.core.kursblockung.KursblockungDynDaten;
import de.svws_nrw.core.logger.Logger;
import jakarta.validation.constraints.NotNull;
import java.util.Random;

public final class KursblockungAlgorithmusKFachwahlmatrix
extends KursblockungAlgorithmusK {
    private static final int MAX_RUNDEN_IN_FOLGE_OHNE_VERBESSERUNG = 5000;

    public KursblockungAlgorithmusKFachwahlmatrix(@NotNull Random pRandom, @NotNull Logger pLogger, @NotNull KursblockungDynDaten pDynDat) {
        super(pRandom, pLogger, pDynDat);
    }

    @NotNull
    public String toString() {
        return "Fachwahlmatrix";
    }

    @Override
    public void berechne(long pEndzeit) {
        if (this.dynDaten.gibKurseDieFreiSindAnzahl() == 0) {
            return;
        }
        this.dynDaten.aktionSchuelerAusAllenKursenEntfernen();
        this.dynDaten.aktionKurseFreieZufaelligVerteilen();
        this.dynDaten.aktionZustandSpeichernK();
        int countKeineVerbesserung = 0;
        do {
            int n = countKeineVerbesserung = this.verteileKurse() ? 0 : countKeineVerbesserung + 1;
        } while (countKeineVerbesserung < 5000 && System.currentTimeMillis() < pEndzeit);
    }

    private boolean verteileKurse() {
        do {
            this.dynDaten.aktionKursVerteilenEinenZufaelligenFreien();
            if (this.dynDaten.gibCompareZustandK_NW_KD_FW() <= 0) continue;
            this.dynDaten.aktionZustandSpeichernK();
            return true;
        } while (this._random.nextBoolean());
        this.dynDaten.aktionZustandLadenK();
        return false;
    }
}

