/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.kursblockung;

import de.svws_nrw.core.kursblockung.KursblockungAlgorithmusK;
import de.svws_nrw.core.kursblockung.KursblockungDynDaten;
import de.svws_nrw.core.logger.Logger;
import jakarta.validation.constraints.NotNull;
import java.util.Random;

public final class KursblockungAlgorithmusKMatching
extends KursblockungAlgorithmusK {
    private static final int MAX_RUNDEN_IN_FOLGE_OHNE_VERBESSERUNG = 2000;

    public KursblockungAlgorithmusKMatching(@NotNull Random pRandom, @NotNull Logger pLogger, @NotNull KursblockungDynDaten pDynDat) {
        super(pRandom, pLogger, pDynDat);
    }

    @NotNull
    public String toString() {
        return "Matching";
    }

    @Override
    public void berechne(long pEndzeit) {
        long current = System.currentTimeMillis();
        long halbzeit = current + (pEndzeit - current) / 2L;
        if (this.dynDaten.gibKurseDieFreiSindAnzahl() == 0) {
            return;
        }
        this.dynDaten.aktionSchuelerAusAllenKursenEntfernen();
        this.dynDaten.aktionKurseFreieZufaelligVerteilen();
        this.dynDaten.aktionZustandSpeichernK();
        int countKeineVerbesserung = 0;
        do {
            int n = countKeineVerbesserung = this.verteileKurseMitMatching() ? 0 : countKeineVerbesserung + 1;
        } while (countKeineVerbesserung < 2000 && System.currentTimeMillis() < halbzeit);
        countKeineVerbesserung = 0;
        do {
            int n = countKeineVerbesserung = this.verteileKurseMitMatchingW() ? 0 : countKeineVerbesserung + 1;
        } while (countKeineVerbesserung < 2000 && System.currentTimeMillis() < pEndzeit);
    }

    private boolean verteileKurseMitMatching() {
        do {
            this.dynDaten.aktionSchuelerAusAllenKursenEntfernen();
            this.dynDaten.aktionKursVerteilenEinenZufaelligenFreien();
            this.dynDaten.aktionSchuelerVerteilenMitBipartitemMatching();
            if (this.dynDaten.gibCompareZustandK_NW_KD_FW() <= 0) continue;
            this.dynDaten.aktionZustandSpeichernK();
            return true;
        } while (this._random.nextBoolean());
        this.dynDaten.aktionZustandLadenK();
        return false;
    }

    private boolean verteileKurseMitMatchingW() {
        do {
            this.dynDaten.aktionSchuelerAusAllenKursenEntfernen();
            this.dynDaten.aktionKursVerteilenEinenZufaelligenFreien();
            this.dynDaten.aktionSchuelerVerteilenMitGewichtetenBipartitemMatching();
            int cmp = this.dynDaten.gibCompareZustandK_NW_KD_FW();
            if (cmp <= 0) continue;
            this.dynDaten.aktionZustandSpeichernK();
            return true;
        } while (this._random.nextBoolean());
        this.dynDaten.aktionZustandLadenK();
        return false;
    }
}

