/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.kursblockung;

import de.svws_nrw.core.kursblockung.KursblockungAlgorithmusK;
import de.svws_nrw.core.kursblockung.KursblockungDynDaten;
import de.svws_nrw.core.kursblockung.KursblockungDynSchueler;
import de.svws_nrw.core.kursblockung.KursblockungStatic;
import de.svws_nrw.core.logger.Logger;
import jakarta.validation.constraints.NotNull;
import java.util.Random;

public final class KursblockungAlgorithmusKMatching2
extends KursblockungAlgorithmusK {
    private static final int MAX_RUNDEN_IN_FOLGE_OHNE_VERBESSERUNG = 2000;
    @NotNull
    private final @NotNull KursblockungDynSchueler @NotNull [] schuelerAlle;

    public KursblockungAlgorithmusKMatching2(@NotNull Random pRandom, @NotNull Logger pLogger, @NotNull KursblockungDynDaten pDynDat) {
        super(pRandom, pLogger, pDynDat);
        this.schuelerAlle = this.dynDaten.gibSchuelerArray(false);
    }

    @Override
    public void berechne(long pMaxTimeMillis) {
        if (this.dynDaten.gibKurseDieFreiSindAnzahl() == 0) {
            return;
        }
        long timeStart = System.currentTimeMillis();
        this.dynDaten.aktionSchuelerAusAllenKursenEntfernen();
        this.dynDaten.aktionKurseFreieZufaelligVerteilen();
        this.dynDaten.aktionZustandSpeichernK();
        int countKeineVerbesserung = 0;
        do {
            int n = countKeineVerbesserung = this.verteileKurse() ? 0 : countKeineVerbesserung + 1;
        } while (countKeineVerbesserung < 2000 && System.currentTimeMillis() - timeStart < pMaxTimeMillis);
    }

    private boolean verteileKurse() {
        do {
            boolean b2;
            this.dynDaten.aktionSchuelerAusAllenKursenEntfernen();
            this.dynDaten.aktionKursVerteilenEinenZufaelligenFreien();
            this.verteileSuS();
            boolean b1 = this.dynDaten.gibCompareZustandK_NW_KD_FW() > 0 && this.dynDaten.gibBewertungK_FW_NW_KD_JetztBesser() >= 0;
            boolean bl = b2 = this.dynDaten.gibCompareZustandK_NW_KD_FW() >= 0 && this.dynDaten.gibBewertungK_FW_NW_KD_JetztBesser() > 0;
            if (!b1 && !b2) continue;
            this.dynDaten.aktionZustandSpeichernK();
            return true;
        } while (this._random.nextBoolean());
        this.dynDaten.aktionZustandLadenK();
        return false;
    }

    private void verteileSuS() {
        @NotNull int[] perm = KursblockungStatic.gibPermutation(this._random, this.schuelerAlle.length);
        for (int p = 0; p < perm.length; ++p) {
            int i = perm[p];
            KursblockungDynSchueler schueler = this.schuelerAlle[i];
            schueler.aktionKurseVerteilenNurMultikurseZufaellig();
            schueler.aktionKurseVerteilenMitBipartiteMatching();
        }
    }
}

