/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.kursblockung;

import de.svws_nrw.core.kursblockung.KursblockungAlgorithmusK;
import de.svws_nrw.core.kursblockung.KursblockungAlgorithmusSSchnellW;
import de.svws_nrw.core.kursblockung.KursblockungDynDaten;
import de.svws_nrw.core.logger.Logger;
import jakarta.validation.constraints.NotNull;
import java.util.Random;

public final class KursblockungAlgorithmusKOptimiereBest
extends KursblockungAlgorithmusK {
    @NotNull
    private final KursblockungAlgorithmusSSchnellW algoS;

    public KursblockungAlgorithmusKOptimiereBest(@NotNull Random pRandom, @NotNull Logger pLogger, @NotNull KursblockungDynDaten pDynDat) {
        super(pRandom, pLogger, pDynDat);
        this.algoS = new KursblockungAlgorithmusSSchnellW(pRandom, pLogger, pDynDat);
    }

    @NotNull
    public String toString() {
        return "OptimiereBest";
    }

    @Override
    public void berechne(long pEndzeit) {
        if (this.dynDaten.gibKurseDieFreiSindAnzahl() == 0) {
            return;
        }
        this.dynDaten.aktionZustandLadenG();
        this.dynDaten.aktionZustandSpeichernK();
        do {
            this.veraendereDieKurslageZufaelligEinWenig();
        } while (System.currentTimeMillis() < pEndzeit);
    }

    private void veraendereDieKurslageZufaelligEinWenig() {
        do {
            this.dynDaten.aktionSchuelerAusAllenKursenEntfernen();
            this.dynDaten.aktionKursVerteilenEinenZufaelligenFreien();
            this.algoS.berechne();
            if (this.dynDaten.gibCompareZustandK_NW_KD_FW() <= 0) continue;
            this.dynDaten.aktionZustandSpeichernK();
            return;
        } while (this._random.nextBoolean());
        this.dynDaten.aktionZustandLadenK();
    }
}

