/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.kursblockung;

import de.svws_nrw.core.kursblockung.KursblockungAlgorithmusK;
import de.svws_nrw.core.kursblockung.KursblockungAlgorithmusS;
import de.svws_nrw.core.kursblockung.KursblockungDynDaten;
import de.svws_nrw.core.logger.Logger;
import jakarta.validation.constraints.NotNull;
import java.util.Random;

public final class KursblockungAlgorithmusKmitS
extends KursblockungAlgorithmusK {
    private static final int MAX_RUNDEN_IN_FOLGE_OHNE_VERBESSERUNG = 2000;
    @NotNull
    private final KursblockungAlgorithmusS algorithmusS;

    public KursblockungAlgorithmusKmitS(@NotNull Random pRandom, @NotNull Logger pLogger, @NotNull KursblockungDynDaten pDynDat, @NotNull KursblockungAlgorithmusS pAlgorithmusS) {
        super(pRandom, pLogger, pDynDat);
        this.algorithmusS = pAlgorithmusS;
    }

    @Override
    public void berechne(long pMaxTimeMillis) {
        if (this.dynDaten.gibKurseDieFreiSindAnzahl() == 0) {
            return;
        }
        long timeStart = System.currentTimeMillis();
        this.dynDaten.aktionSchuelerAusAllenKursenEntfernen();
        this.dynDaten.aktionKurseFreieZufaelligVerteilen();
        this.dynDaten.aktionZustandSpeichernK();
        int countKeineVerbesserung = 0;
        do {
            int n = countKeineVerbesserung = this.verteileKurse() ? 0 : countKeineVerbesserung + 1;
        } while (countKeineVerbesserung < 2000 && System.currentTimeMillis() - timeStart < pMaxTimeMillis);
    }

    private boolean verteileKurse() {
        do {
            this.dynDaten.aktionSchuelerAusAllenKursenEntfernen();
            this.dynDaten.aktionKursVerteilenEinenZufaelligenFreien();
            this.algorithmusS.berechne();
            int cmp = this.dynDaten.gibCompareZustandK_NW_KD_FW();
            if (cmp <= 0) continue;
            this.dynDaten.aktionZustandSpeichernK();
            return true;
        } while (this._random.nextBoolean());
        this.dynDaten.aktionZustandLadenK();
        return false;
    }
}

