/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.kursblockung;

import de.svws_nrw.core.kursblockung.KursblockungAlgorithmusS;
import de.svws_nrw.core.kursblockung.KursblockungDynDaten;
import de.svws_nrw.core.kursblockung.KursblockungDynSchueler;
import de.svws_nrw.core.kursblockung.KursblockungStatic;
import de.svws_nrw.core.logger.Logger;
import jakarta.validation.constraints.NotNull;
import java.util.Random;

public final class KursblockungAlgorithmusSSchnellW
extends KursblockungAlgorithmusS {
    @NotNull
    private final @NotNull KursblockungDynSchueler @NotNull [] schuelerArr;
    @NotNull
    private final int[] perm;

    public KursblockungAlgorithmusSSchnellW(@NotNull Random pRandom, @NotNull Logger pLogger, @NotNull KursblockungDynDaten pDynDat) {
        super(pRandom, pLogger, pDynDat);
        this.schuelerArr = pDynDat.gibSchuelerArrayAlle();
        this.perm = KursblockungStatic.gibPermutation(this._random, this.schuelerArr.length);
    }

    @Override
    public void berechne() {
        this.dynDaten.gibStatistik().aktionBewertungSpeichernS();
        for (int i = 0; i < 10; ++i) {
            this.verteileSchuelerAlle();
        }
    }

    private boolean verteileSchuelerAlle() {
        boolean verbesserung = false;
        KursblockungStatic.aktionPermutiere(this._random, this.perm);
        for (int p = 0; p < this.schuelerArr.length; ++p) {
            int i = this.perm[p];
            verbesserung |= this.verteileSchuelerEiner(this.schuelerArr[i]);
        }
        return verbesserung;
    }

    private boolean verteileSchuelerEiner(@NotNull KursblockungDynSchueler schueler) {
        this.dynDaten.gibStatistik().aktionBewertungSpeichernS();
        schueler.aktionZustandSpeichernS();
        schueler.aktionKurseAlleEntfernen();
        schueler.aktionKurseVerteilenNurMultikurseZufaellig();
        schueler.aktionKurseVerteilenNurFachartenMitEinemKurs();
        schueler.aktionKurseVerteilenMitBipartiteMatchingGewichtetem();
        int cmp = this.dynDaten.gibStatistik().gibBewertungZustandS_NW_KD();
        if (cmp < 0) {
            schueler.aktionZustandLadenS();
        }
        return cmp > 0;
    }
}

