/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.kursblockung;

import de.svws_nrw.core.adt.collection.LinkedCollection;
import de.svws_nrw.core.adt.map.ArrayMap;
import de.svws_nrw.core.adt.map.HashMap2D;
import de.svws_nrw.core.data.gost.GostBlockungKurs;
import de.svws_nrw.core.data.gost.GostBlockungKursLehrer;
import de.svws_nrw.core.data.gost.GostBlockungRegel;
import de.svws_nrw.core.data.gost.GostBlockungSchiene;
import de.svws_nrw.core.data.gost.GostFach;
import de.svws_nrw.core.data.gost.GostFachwahl;
import de.svws_nrw.core.data.schueler.Schueler;
import de.svws_nrw.core.exceptions.DeveloperNotificationException;
import de.svws_nrw.core.exceptions.UserNotificationException;
import de.svws_nrw.core.kursblockung.KursblockungDynFachart;
import de.svws_nrw.core.kursblockung.KursblockungDynKurs;
import de.svws_nrw.core.kursblockung.KursblockungDynSchiene;
import de.svws_nrw.core.kursblockung.KursblockungDynSchueler;
import de.svws_nrw.core.kursblockung.KursblockungDynStatistik;
import de.svws_nrw.core.kursblockung.KursblockungStatic;
import de.svws_nrw.core.logger.Logger;
import de.svws_nrw.core.types.gost.GostKursart;
import de.svws_nrw.core.types.kursblockung.GostKursblockungRegelTyp;
import de.svws_nrw.core.utils.ListUtils;
import de.svws_nrw.core.utils.MapUtils;
import de.svws_nrw.core.utils.gost.GostBlockungsdatenManager;
import de.svws_nrw.core.utils.gost.GostBlockungsergebnisManager;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class KursblockungDynDaten {
    @NotNull
    private final Random _random;
    @NotNull
    private final Logger _logger;
    @NotNull
    private final @NotNull Map<@NotNull GostKursblockungRegelTyp, @NotNull List<@NotNull GostBlockungRegel>> _regelMap;
    private final long _maxTimeMillis;
    @NotNull
    private @NotNull KursblockungDynSchiene @NotNull [] _schienenArr;
    @NotNull
    private @NotNull KursblockungDynKurs @NotNull [] _kursArr;
    @NotNull
    private @NotNull KursblockungDynKurs @NotNull [] _kursArrFrei;
    @NotNull
    private final @NotNull HashMap<@NotNull Long, @NotNull KursblockungDynKurs> _kursMap;
    @NotNull
    private @NotNull KursblockungDynFachart @NotNull [] _fachartArr;
    @NotNull
    private final @NotNull HashMap2D<@NotNull Long, @NotNull Integer, @NotNull KursblockungDynFachart> _fachartMap2D;
    @NotNull
    private @NotNull KursblockungDynSchueler @NotNull [] _schuelerArr;
    @NotNull
    private final @NotNull HashMap<@NotNull Long, @NotNull KursblockungDynSchueler> _schuelerMap;
    @NotNull
    private final KursblockungDynStatistik _statistik;

    public KursblockungDynDaten(@NotNull Random random, @NotNull Logger logger, @NotNull GostBlockungsdatenManager input) {
        this._random = random;
        this._logger = logger;
        this._regelMap = new ArrayMap<GostKursblockungRegelTyp, List<GostBlockungRegel>>(GostKursblockungRegelTyp.values());
        this._maxTimeMillis = input.getMaxTimeMillis();
        this._schienenArr = new KursblockungDynSchiene[0];
        this._kursArr = new KursblockungDynKurs[0];
        this._kursArrFrei = new KursblockungDynKurs[0];
        this._kursMap = new HashMap();
        this._fachartArr = new KursblockungDynFachart[0];
        this._fachartMap2D = new HashMap2D();
        this._schuelerArr = new KursblockungDynSchueler[0];
        this._schuelerMap = new HashMap();
        this._statistik = new KursblockungDynStatistik(this._logger);
        this.schritt01FehlerBeiReferenzen(input);
        this.schritt02FehlerBeiRegelGruppierung(input.daten().regeln);
        this.schritt03FehlerBeiFachartenErstellung(input);
        this.schritt04FehlerBeiSchuelerErstellung(input);
        this.schritt05FehlerBeiSchuelerFachwahlenErstellung(input, this._schuelerArr);
        this.schritt06FehlerBeiStatistikErstellung(this._fachartArr, this._schuelerArr, input);
        this.schritt07FehlerBeiSchienenErzeugung(input.schieneGetAnzahl());
        this.schritt08FehlerBeiKursErstellung(input);
        this.schritt09FehlerBeiKursFreiErstellung();
        this.schritt10FehlerBeiFachartKursArrayErstellung();
        this.schritt11FehlerBeiRegel_4_oder_5();
        this.schritt12FehlerBeiRegel_7_oder_8();
        this.schritt13FehlerBeiRegel_9();
        this.schritt14FehlerBeiRegel_10(input);
        this.aktionZustandSpeichernS();
        this.aktionZustandSpeichernK();
        this.aktionZustandSpeichernG();
    }

    private void schritt01FehlerBeiReferenzen(@NotNull GostBlockungsdatenManager input) {
        DeveloperNotificationException.ifNull("pInput", input);
        DeveloperNotificationException.ifNull("pInput.daten()", input.daten());
        DeveloperNotificationException.ifNull("pInput.daten().fachwahlen", input.daten().fachwahlen);
        DeveloperNotificationException.ifNull("pInput.faecherManager()", input.faecherManager());
        DeveloperNotificationException.ifNull("pInput.faecherManager().faecher()", input.faecherManager().faecher());
        DeveloperNotificationException.ifNull("GostKursart.values()", GostKursart.values());
        DeveloperNotificationException.ifNull("pInput.daten().kurse", input.daten().kurse);
        DeveloperNotificationException.ifNull("pInput.daten().regeln", input.daten().regeln);
        DeveloperNotificationException.ifInvalidID("pInput.getID()", input.getID());
        DeveloperNotificationException.ifNull("pInput", input);
        DeveloperNotificationException.ifNull("pInput", input);
        DeveloperNotificationException.ifNull("pInput", input);
        DeveloperNotificationException.ifNull("pInput", input);
        DeveloperNotificationException.ifNull("pInput", input);
        DeveloperNotificationException.ifArrayIsEmpty("GostKursart.values()", GostKursart.values());
        DeveloperNotificationException.ifCollectionIsEmpty("pInput.daten().fachwahlen", input.daten().fachwahlen);
        DeveloperNotificationException.ifCollectionIsEmpty("pInput.faecherManager().faecher()", input.faecherManager().faecher());
        DeveloperNotificationException.ifCollectionIsEmpty("pInput.daten().kurse", input.daten().kurse);
        int schienenAnzahl = input.schieneGetAnzahl();
        DeveloperNotificationException.ifSmaller("schienenAnzahl", schienenAnzahl, 1L);
        HashSet usedSchiene = new HashSet();
        for (GostBlockungSchiene gostBlockungSchiene : input.daten().schienen) {
            DeveloperNotificationException.ifInvalidID("gSchiene.id", gostBlockungSchiene.id);
            DeveloperNotificationException.ifSmaller("gSchiene.id", gostBlockungSchiene.nummer, 1L);
            DeveloperNotificationException.ifGreater("gSchiene.id", gostBlockungSchiene.nummer, schienenAnzahl);
            DeveloperNotificationException.ifSetAddsDuplicate("usedSchiene", usedSchiene, gostBlockungSchiene.nummer);
        }
        @NotNull HashSet<@NotNull Integer> setKursarten = new HashSet<Integer>();
        for (GostKursart iKursart : GostKursart.values()) {
            DeveloperNotificationException.ifNull("iKursart", iKursart);
            DeveloperNotificationException.ifInvalidID("iKursart.id", iKursart.id);
            DeveloperNotificationException.ifSetAddsDuplicate("setKursarten", setKursarten, iKursart.id);
        }
        @NotNull HashSet<@NotNull E> hashSet = new HashSet();
        for (GostFach iFach : input.faecherManager().faecher()) {
            DeveloperNotificationException.ifNull("iFach", iFach);
            DeveloperNotificationException.ifInvalidID("iFach.id", iFach.id);
            DeveloperNotificationException.ifSetAddsDuplicate("setFaecher", hashSet, iFach.id);
        }
        @NotNull HashSet<@NotNull Long> setKurse = new HashSet<Long>();
        for (GostBlockungKurs iKurs : input.daten().kurse) {
            DeveloperNotificationException.ifNull("iKurs", iKurs);
            DeveloperNotificationException.ifInvalidID("iKurs.id", iKurs.id);
            DeveloperNotificationException.ifSetNotContains("setFaecher", hashSet, iKurs.fach_id);
            DeveloperNotificationException.ifSetNotContains("setKursarten", setKursarten, iKurs.kursart);
            DeveloperNotificationException.ifSetAddsDuplicate("setKurse", setKurse, iKurs.id);
        }
        @NotNull HashSet<@NotNull Long> setSchueler = new HashSet<Long>();
        for (Schueler gSchueler : input.daten().schueler) {
            DeveloperNotificationException.ifSetAddsDuplicate("setSchueler", setSchueler, gSchueler.id);
        }
        for (GostFachwahl iFachwahl : input.daten().fachwahlen) {
            DeveloperNotificationException.ifNull("iFachwahl", iFachwahl);
            DeveloperNotificationException.ifInvalidID("iFachwahl.schuelerID", iFachwahl.schuelerID);
            DeveloperNotificationException.ifSetNotContains("setFaecher", hashSet, iFachwahl.fachID);
            DeveloperNotificationException.ifSetNotContains("setKursarten", setKursarten, iFachwahl.kursartID);
            DeveloperNotificationException.ifSetNotContains("setSchueler", setSchueler, iFachwahl.schuelerID);
        }
        block18: for (GostBlockungRegel iRegel : input.daten().regeln) {
            DeveloperNotificationException.ifNull("iRegel", iRegel);
            DeveloperNotificationException.ifNull("iRegel.parameter", iRegel.parameter);
            DeveloperNotificationException.ifInvalidID("iRegel.id", iRegel.id);
            @NotNull GostKursblockungRegelTyp gostRegel = GostKursblockungRegelTyp.fromTyp(iRegel.typ);
            @NotNull Long @NotNull [] daten = iRegel.parameter.toArray(new Long[0]);
            for (int i = 0; i < daten.length; ++i) {
                DeveloperNotificationException.ifNull("daten[" + i + "]", daten[i]);
            }
            switch (gostRegel) {
                case KURSART_SPERRE_SCHIENEN_VON_BIS: {
                    KursblockungDynDaten.schritt01FehlerBeiReferenzen_Regeltyp1(daten, setKursarten, schienenAnzahl);
                    continue block18;
                }
                case KURS_FIXIERE_IN_SCHIENE: {
                    KursblockungDynDaten.schritt01FehlerBeiReferenzen_Regeltyp2(daten, setKurse, schienenAnzahl);
                    continue block18;
                }
                case KURS_SPERRE_IN_SCHIENE: {
                    KursblockungDynDaten.schritt01FehlerBeiReferenzen_Regeltyp3(daten, setKurse, schienenAnzahl);
                    continue block18;
                }
                case SCHUELER_FIXIEREN_IN_KURS: {
                    KursblockungDynDaten.schritt01FehlerBeiReferenzen_Regeltyp4(daten, setSchueler, setKurse);
                    continue block18;
                }
                case SCHUELER_VERBIETEN_IN_KURS: {
                    KursblockungDynDaten.schritt01FehlerBeiReferenzen_Regeltyp5(daten, setSchueler, setKurse);
                    continue block18;
                }
                case KURSART_ALLEIN_IN_SCHIENEN_VON_BIS: {
                    KursblockungDynDaten.schritt01FehlerBeiReferenzen_Regeltyp6(daten, setKursarten, schienenAnzahl);
                    continue block18;
                }
                case KURS_VERBIETEN_MIT_KURS: {
                    KursblockungDynDaten.schritt01FehlerBeiReferenzen_Regeltyp7(daten, setKurse);
                    continue block18;
                }
                case KURS_ZUSAMMEN_MIT_KURS: {
                    KursblockungDynDaten.schritt01FehlerBeiReferenzen_Regeltyp8(daten, setKurse);
                    continue block18;
                }
                case KURS_MIT_DUMMY_SUS_AUFFUELLEN: {
                    KursblockungDynDaten.schritt01FehlerBeiReferenzen_Regeltyp9(daten, setKurse);
                    continue block18;
                }
                case LEHRKRAEFTE_BEACHTEN: {
                    KursblockungDynDaten.schritt01FehlerBeiReferenzen_Regeltyp10(daten);
                    continue block18;
                }
            }
            throw new DeveloperNotificationException("Unbekannter Regeltyp!");
        }
    }

    private static void schritt01FehlerBeiReferenzen_Regeltyp1(@NotNull @NotNull Long @NotNull [] daten, @NotNull @NotNull HashSet<@NotNull Integer> setKursarten, int schienenAnzahl) {
        int length = daten.length;
        DeveloperNotificationException.ifTrue("KURSART_SPERRE_SCHIENEN_VON_BIS daten.length=" + length + ", statt 3!", length != 3);
        int kursartID = daten[0].intValue();
        DeveloperNotificationException.ifSetNotContains("setKursarten", setKursarten, kursartID);
        int von = daten[1].intValue();
        int bis = daten[2].intValue();
        DeveloperNotificationException.ifTrue("KURSART_SPERRE_SCHIENEN_VON_BIS (" + kursartID + ", " + von + ", " + bis + ") ist unlogisch!", von < 1 || von > bis || bis > schienenAnzahl);
    }

    private static void schritt01FehlerBeiReferenzen_Regeltyp2(@NotNull @NotNull Long @NotNull [] daten, @NotNull @NotNull HashSet<@NotNull Long> setKurse, int schienenAnzahl) {
        int length = daten.length;
        DeveloperNotificationException.ifTrue("KURS_FIXIERE_IN_SCHIENE daten.length=" + length + ", statt 2!", length != 2);
        long kursID = daten[0];
        DeveloperNotificationException.ifSetNotContains("setKurse", setKurse, kursID);
        int schiene = daten[1].intValue();
        DeveloperNotificationException.ifTrue("KURS_FIXIERE_IN_SCHIENE (" + kursID + ", " + schiene + ") ist unlogisch!", schiene < 1 || schiene > schienenAnzahl);
    }

    private static void schritt01FehlerBeiReferenzen_Regeltyp3(@NotNull @NotNull Long @NotNull [] daten, @NotNull @NotNull HashSet<@NotNull Long> setKurse, int schienenAnzahl) {
        int length = daten.length;
        DeveloperNotificationException.ifTrue("KURS_SPERRE_IN_SCHIENE daten.length=" + length + ", statt 2!", length != 2);
        long kursID = daten[0];
        DeveloperNotificationException.ifSetNotContains("setKurse", setKurse, kursID);
        int schiene = daten[1].intValue();
        DeveloperNotificationException.ifTrue("KURS_SPERRE_IN_SCHIENE (" + kursID + ", " + schiene + ") ist unlogisch!", schiene < 1 || schiene > schienenAnzahl);
    }

    private static void schritt01FehlerBeiReferenzen_Regeltyp4(@NotNull @NotNull Long @NotNull [] daten, @NotNull @NotNull HashSet<@NotNull Long> setSchueler, @NotNull @NotNull HashSet<@NotNull Long> setKurse) {
        int length = daten.length;
        DeveloperNotificationException.ifTrue("SCHUELER_FIXIEREN_IN_KURS daten.length=" + length + ", statt 2!", length != 2);
        long schuelerID = daten[0];
        DeveloperNotificationException.ifSetNotContains("setSchueler", setSchueler, schuelerID);
        long kursID = daten[1];
        DeveloperNotificationException.ifSetNotContains("setKurse", setKurse, kursID);
    }

    private static void schritt01FehlerBeiReferenzen_Regeltyp5(@NotNull @NotNull Long @NotNull [] daten, @NotNull @NotNull HashSet<@NotNull Long> setSchueler, @NotNull @NotNull HashSet<@NotNull Long> setKurse) {
        int length = daten.length;
        DeveloperNotificationException.ifTrue("SCHUELER_VERBIETEN_IN_KURS daten.length=" + length + ", statt 2!", length != 2);
        long schuelerID = daten[0];
        DeveloperNotificationException.ifSetNotContains("setSchueler", setSchueler, schuelerID);
        long kursID = daten[1];
        DeveloperNotificationException.ifSetNotContains("setKurse", setKurse, kursID);
    }

    private static void schritt01FehlerBeiReferenzen_Regeltyp6(@NotNull @NotNull Long @NotNull [] daten, @NotNull @NotNull HashSet<@NotNull Integer> setKursarten, int schienenAnzahl) {
        int length = daten.length;
        DeveloperNotificationException.ifTrue("KURSART_ALLEIN_IN_SCHIENEN_VON_BIS daten.length=" + length + ", statt 3!", length != 3);
        int kursartID = daten[0].intValue();
        DeveloperNotificationException.ifSetNotContains("setKursarten", setKursarten, kursartID);
        int von = daten[1].intValue();
        int bis = daten[2].intValue();
        DeveloperNotificationException.ifTrue("KURSART_ALLEIN_IN_SCHIENEN_VON_BIS (" + kursartID + ", " + von + ", " + bis + ") ist unlogisch!", von < 1 || von > bis || bis > schienenAnzahl);
    }

    private static void schritt01FehlerBeiReferenzen_Regeltyp7(@NotNull @NotNull Long @NotNull [] daten, @NotNull @NotNull HashSet<@NotNull Long> setKurse) {
        int length = daten.length;
        DeveloperNotificationException.ifTrue("KURS_VERBIETEN_MIT_KURS daten.length=" + length + ", statt 2!", length != 2);
        long kursID1 = daten[0];
        DeveloperNotificationException.ifSetNotContains("setKurse", setKurse, kursID1);
        long kursID2 = daten[1];
        DeveloperNotificationException.ifSetNotContains("setKurse", setKurse, kursID2);
        DeveloperNotificationException.ifTrue("Die Regel 'KURS_VERBIETEN_MIT_KURS' wurde mit einem Kurs (" + kursID1 + ") und sich selbst kombiniert!", kursID1 == kursID2);
    }

    private static void schritt01FehlerBeiReferenzen_Regeltyp8(@NotNull @NotNull Long @NotNull [] daten, @NotNull @NotNull HashSet<@NotNull Long> setKurse) {
        int length = daten.length;
        DeveloperNotificationException.ifTrue("KURS_ZUSAMMEN_MIT_KURS daten.length=" + length + ", statt 2!", length != 2);
        long kursID1 = daten[0];
        DeveloperNotificationException.ifSetNotContains("setKurse", setKurse, kursID1);
        long kursID2 = daten[1];
        DeveloperNotificationException.ifSetNotContains("setKurse", setKurse, kursID2);
        DeveloperNotificationException.ifTrue("Die Regel 'KURS_ZUSAMMEN_MIT_KURS' wurde mit einem Kurs (" + kursID1 + ") und sich selbst kombiniert!", kursID1 == kursID2);
    }

    private static void schritt01FehlerBeiReferenzen_Regeltyp9(@NotNull @NotNull Long @NotNull [] daten, @NotNull @NotNull HashSet<@NotNull Long> setKurse) {
        int length = daten.length;
        DeveloperNotificationException.ifTrue("KURS_MIT_DUMMY_SUS_AUFFUELLEN daten.length=" + length + ", statt 2!", length != 2);
        long kursID = daten[0];
        DeveloperNotificationException.ifSetNotContains("setKurse", setKurse, kursID);
        int dummySuS = daten[1].intValue();
        DeveloperNotificationException.ifSmaller("dummySuS", dummySuS, 1L);
        DeveloperNotificationException.ifGreater("dummySuS", dummySuS, 99L);
    }

    private static void schritt01FehlerBeiReferenzen_Regeltyp10(@NotNull @NotNull Long @NotNull [] daten) {
        int length = daten.length;
        DeveloperNotificationException.ifTrue("LEHRKRAEFTE_BEACHTEN daten.length=" + length + ", statt 0!", length != 0);
    }

    private void schritt02FehlerBeiRegelGruppierung(@NotNull @NotNull List<@NotNull GostBlockungRegel> pRegeln) {
        HashSet regelDatabaseIDs = new HashSet();
        for (GostBlockungRegel iRegel : pRegeln) {
            DeveloperNotificationException.ifInvalidID("iRegel.id", iRegel.id);
            DeveloperNotificationException.ifSetAddsDuplicate("regelDatabaseIDs", regelDatabaseIDs, iRegel.id);
            @NotNull GostKursblockungRegelTyp regelTyp = GostKursblockungRegelTyp.fromTyp(iRegel.typ);
            MapUtils.getOrCreateArrayList(this._regelMap, regelTyp).add(iRegel);
        }
    }

    private void schritt03FehlerBeiFachartenErstellung(@NotNull GostBlockungsdatenManager input) {
        KursblockungDynFachart dynFachart;
        GostKursart kursart;
        GostFach fach;
        int nFacharten = 0;
        int nKurse = input.daten().kurse.size();
        for (GostBlockungKurs gKurs : input.daten().kurse) {
            fach = input.faecherManager().getOrException(gKurs.fach_id);
            kursart = GostKursart.fromID(gKurs.kursart);
            dynFachart = this._fachartMap2D.getOrNull(fach.id, kursart.id);
            if (dynFachart == null) {
                dynFachart = new KursblockungDynFachart(this._random, nFacharten, fach, kursart, this._statistik);
                this._fachartMap2D.put(fach.id, kursart.id, dynFachart);
                ++nFacharten;
            }
            dynFachart.aktionMaxKurseErhoehen();
        }
        for (GostFachwahl iFachwahl : input.daten().fachwahlen) {
            fach = input.faecherManager().getOrException(iFachwahl.fachID);
            kursart = GostKursart.fromID(iFachwahl.kursartID);
            dynFachart = this._fachartMap2D.getOrNull(fach.id, kursart.id);
            if (dynFachart != null) continue;
            dynFachart = new KursblockungDynFachart(this._random, nFacharten, fach, kursart, this._statistik);
            this._fachartMap2D.put(fach.id, kursart.id, dynFachart);
            ++nFacharten;
        }
        DeveloperNotificationException.ifSmaller("nFacharten", nFacharten, 1L);
        this._fachartArr = new KursblockungDynFachart[nFacharten];
        Iterator<Object> iterator = this._fachartMap2D.getNonNullValuesAsList().iterator();
        while (iterator.hasNext()) {
            KursblockungDynFachart fachart;
            this._fachartArr[fachart.gibNr()] = fachart = (KursblockungDynFachart)iterator.next();
        }
        int kursSumme = 0;
        for (int i = 0; i < this._fachartArr.length; ++i) {
            kursSumme += this._fachartArr[i].gibKurseMax();
        }
        DeveloperNotificationException.ifTrue("Die Summe aller auf die Facharten verteilten Kurse ist ungleich der Gesamtkursanzahl.", kursSumme != nKurse);
    }

    private void schritt04FehlerBeiSchuelerErstellung(@NotNull GostBlockungsdatenManager input) {
        @NotNull HashSet<@NotNull Long> setSchueler = new HashSet<Long>();
        for (Schueler gSchueler : input.daten().schueler) {
            setSchueler.add(gSchueler.id);
        }
        for (GostFachwahl fachwahl : input.daten().fachwahlen) {
            DeveloperNotificationException.ifSetNotContains("setSchueler", setSchueler, fachwahl.schuelerID);
        }
        int nSchueler = setSchueler.size();
        int nSchienen = input.schieneGetAnzahl();
        int nKurse = input.kursGetAnzahl();
        this._schuelerArr = new KursblockungDynSchueler[nSchueler];
        int i = 0;
        Iterator iterator = setSchueler.iterator();
        while (iterator.hasNext()) {
            KursblockungDynSchueler schueler;
            long sID = (Long)iterator.next();
            this._schuelerArr[i] = schueler = new KursblockungDynSchueler(this._logger, this._random, sID, this._statistik, nSchienen, nKurse);
            this._schuelerMap.put(sID, schueler);
            ++i;
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private void schritt05FehlerBeiSchuelerFachwahlenErstellung(@NotNull GostBlockungsdatenManager input, @NotNull @NotNull KursblockungDynSchueler @NotNull [] susArr) {
        @NotNull HashMap<@NotNull K, @NotNull @NotNull V> mapSchuelerFA = new HashMap();
        for (GostFachwahl iFachwahl : input.daten().fachwahlen) {
            @NotNull KursblockungDynFachart dynFachart = this.gibFachart(iFachwahl.fachID, iFachwahl.kursartID);
            MapUtils.getOrCreateArrayList(mapSchuelerFA, iFachwahl.schuelerID).add(dynFachart);
        }
        for (KursblockungDynSchueler schueler : susArr) {
            @NotNull List<@NotNull V> listFA = MapUtils.getOrCreateArrayList(mapSchuelerFA, schueler.gibDatenbankID());
            @NotNull KursblockungDynFachart @NotNull [] arrFA = listFA.toArray(new KursblockungDynFachart[0]);
            schueler.aktionSetzeFachartenUndIDs(arrFA);
        }
    }

    private void schritt06FehlerBeiStatistikErstellung(@NotNull @NotNull KursblockungDynFachart @NotNull [] fachartArr, @NotNull @NotNull KursblockungDynSchueler @NotNull [] susArr, @NotNull GostBlockungsdatenManager input) {
        int nr2;
        int nFacharten = fachartArr.length;
        @NotNull int @NotNull [][] bewertungMatrixFachart = new int[nFacharten][nFacharten];
        for (int i = 0; i < susArr.length; ++i) {
            @NotNull KursblockungDynFachart @NotNull [] fa = susArr[i].gibFacharten();
            for (int i1 = 0; i1 < fa.length; ++i1) {
                int nr1 = fa[i1].gibNr();
                for (int i2 = i1 + 1; i2 < fa.length; ++i2) {
                    nr2 = fa[i2].gibNr();
                    int[] nArray = bewertungMatrixFachart[nr1];
                    int n = nr2;
                    nArray[n] = nArray[n] + 1;
                    int[] nArray2 = bewertungMatrixFachart[nr2];
                    int n2 = nr1;
                    nArray2[n2] = nArray2[n2] + 1;
                }
            }
        }
        for (int i1 = 0; i1 < nFacharten; ++i1) {
            int kursAnz1 = fachartArr[i1].gibKurseMax();
            int nr1 = fachartArr[i1].gibNr();
            for (int i2 = 0; i2 < nFacharten; ++i2) {
                int kursAnz2 = fachartArr[i2].gibKurseMax();
                nr2 = fachartArr[i2].gibNr();
                if (kursAnz1 == 0 || kursAnz2 == 0) {
                    bewertungMatrixFachart[nr1][nr2] = 0;
                    continue;
                }
                int nenner = kursAnz1 + kursAnz2 - 2;
                int faktor = nenner == 0 ? 1000000 : 100 / nenner;
                int[] nArray = bewertungMatrixFachart[nr1];
                int n = nr2;
                nArray[n] = nArray[n] * faktor;
            }
            int[] nArray = bewertungMatrixFachart[nr1];
            int n = nr1;
            nArray[n] = nArray[n] + 10000000;
        }
        this._statistik.aktionInitialisiere(bewertungMatrixFachart, susArr.length, fachartArr.length, input.kursGetAnzahl());
    }

    private void schritt07FehlerBeiSchienenErzeugung(int schienen) {
        this._schienenArr = new KursblockungDynSchiene[schienen];
        for (int nr = 0; nr < schienen; ++nr) {
            this._schienenArr[nr] = new KursblockungDynSchiene(this._logger, nr, this._statistik);
        }
    }

    private void schritt08FehlerBeiKursErstellung(@NotNull GostBlockungsdatenManager input) {
        int nKurse = input.kursGetAnzahl();
        int nSchienen = input.schieneGetAnzahl();
        this._kursArr = new KursblockungDynKurs[nKurse];
        int i = 0;
        for (GostBlockungKurs kurs : input.daten().kurse) {
            KursblockungDynKurs dynKurs;
            this._kursArr[i] = dynKurs = this.schritt08FehlerBeiKursErstellungErzeuge(kurs, nSchienen, i);
            DeveloperNotificationException.ifMapPutOverwrites(this._kursMap, kurs.id, dynKurs);
            ++i;
        }
    }

    @NotNull
    private KursblockungDynKurs schritt08FehlerBeiKursErstellungErzeuge(@NotNull GostBlockungKurs kurs, int nSchienen, int kursNr) {
        int schiene;
        DeveloperNotificationException.ifSmaller("kurs.anzahlSchienen", kurs.anzahlSchienen, 1L);
        DeveloperNotificationException.ifGreater("kurs.anzahlSchienen", kurs.anzahlSchienen, this._schienenArr.length);
        @NotNull ArrayList<@NotNull KursblockungDynSchiene> schieneLage = new ArrayList<KursblockungDynSchiene>();
        @NotNull List<@NotNull KursblockungDynSchiene> schieneFrei = ListUtils.getCopyAsArrayListPermuted(this._schienenArr, this._random);
        for (GostBlockungRegel regel1 : MapUtils.getOrCreateArrayList(this._regelMap, GostKursblockungRegelTyp.KURSART_SPERRE_SCHIENEN_VON_BIS)) {
            if ((long)kurs.kursart != regel1.parameter.get(0)) continue;
            int von = regel1.parameter.get(1).intValue();
            int bis = regel1.parameter.get(2).intValue();
            for (int schiene2 = von; schiene2 <= bis; ++schiene2) {
                schieneFrei.remove(this._schienenArr[schiene2 - 1]);
            }
        }
        for (GostBlockungRegel regel6 : MapUtils.getOrCreateArrayList(this._regelMap, GostKursblockungRegelTyp.KURSART_ALLEIN_IN_SCHIENEN_VON_BIS)) {
            boolean kursartStimmt = (long)kurs.kursart == regel6.parameter.get(0);
            int von = regel6.parameter.get(1).intValue();
            int bis = regel6.parameter.get(2).intValue();
            for (int schiene3 = 1; schiene3 <= nSchienen; ++schiene3) {
                boolean innerhalb;
                boolean bl = innerhalb = von <= schiene3 && schiene3 <= bis;
                if (innerhalb == kursartStimmt) continue;
                schieneFrei.remove(this._schienenArr[schiene3 - 1]);
            }
        }
        for (GostBlockungRegel regel3 : MapUtils.getOrCreateArrayList(this._regelMap, GostKursblockungRegelTyp.KURS_SPERRE_IN_SCHIENE)) {
            if (kurs.id != regel3.parameter.get(0)) continue;
            schiene = regel3.parameter.get(1).intValue();
            schieneFrei.remove(this._schienenArr[schiene - 1]);
        }
        for (GostBlockungRegel regel2 : MapUtils.getOrCreateArrayList(this._regelMap, GostKursblockungRegelTyp.KURS_FIXIERE_IN_SCHIENE)) {
            KursblockungDynSchiene dynSchiene;
            if (kurs.id != regel2.parameter.get(0) || schieneLage.contains(dynSchiene = this._schienenArr[(schiene = regel2.parameter.get(1).intValue()) - 1])) continue;
            UserNotificationException.ifTrue("Die Regel 'KURS_FIXIERE_IN_SCHIENE' will Kurs (id=" + kurs.id + ") in Schiene (" + schiene + ") fixieren, aber die Schiene wurde bereits gesperrt!", !schieneFrei.contains(dynSchiene));
            schieneFrei.remove(dynSchiene);
            schieneLage.add(dynSchiene);
        }
        int anzahlFixierterSchienen = schieneLage.size();
        DeveloperNotificationException.ifGreater("kurs.anzahlSchienen", anzahlFixierterSchienen, kurs.anzahlSchienen);
        while (schieneLage.size() < kurs.anzahlSchienen) {
            UserNotificationException.ifTrue("Der Kurs (" + kurs.id + ") hat zu viele Schienen gesperrt, so dass seine Schienenanzahl nicht erf\u00fcllt werden kann!", schieneFrei.isEmpty());
            int indexLast = schieneFrei.size() - 1;
            schieneLage.add(schieneFrei.remove(indexLast));
        }
        @NotNull KursblockungDynSchiene @NotNull [] schienenLageArray = schieneLage.toArray(new KursblockungDynSchiene[0]);
        @NotNull KursblockungDynSchiene @NotNull [] schienenFreiArray = schieneFrei.toArray(new KursblockungDynSchiene[0]);
        @NotNull KursblockungDynFachart dynFachart = this.gibFachart(kurs.fach_id, kurs.kursart);
        return new KursblockungDynKurs(this._random, schienenLageArray, anzahlFixierterSchienen, schienenFreiArray, kurs.id, dynFachart, this._logger, kursNr);
    }

    private void schritt09FehlerBeiKursFreiErstellung() {
        int nKursFrei = 0;
        for (KursblockungDynKurs kurs : this._kursArr) {
            if (!kurs.gibHatFreiheitsgrade()) continue;
            ++nKursFrei;
        }
        this._kursArrFrei = new KursblockungDynKurs[nKursFrei];
        int j = 0;
        for (int i = 0; i < this._kursArr.length; ++i) {
            if (!this._kursArr[i].gibHatFreiheitsgrade()) continue;
            this._kursArrFrei[j] = this._kursArr[i];
            ++j;
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private void schritt10FehlerBeiFachartKursArrayErstellung() {
        int nFacharten = this._fachartArr.length;
        @NotNull HashMap<@NotNull Integer, @NotNull ArrayList<@NotNull E>> mapFachartList = new HashMap();
        for (int i = 0; i < nFacharten; ++i) {
            mapFachartList.put(i, new ArrayList());
        }
        for (KursblockungDynKurs kurs : this._kursArr) {
            int fachartNr = kurs.gibFachart().gibNr();
            ((List)DeveloperNotificationException.ifMapGetIsNull(mapFachartList, fachartNr)).add(kurs);
        }
        for (int fachartNr = 0; fachartNr < nFacharten; ++fachartNr) {
            @NotNull List list = (List)DeveloperNotificationException.ifMapGetIsNull(mapFachartList, fachartNr);
            @NotNull KursblockungDynKurs @NotNull [] tmpKursArr = list.toArray(new KursblockungDynKurs[0]);
            this._fachartArr[fachartNr].aktionSetKurse(tmpKursArr);
        }
    }

    private void schritt11FehlerBeiRegel_4_oder_5() {
        KursblockungDynSchueler schueler;
        long kursID;
        long schuelerID;
        for (GostBlockungRegel regel4 : MapUtils.getOrCreateArrayList(this._regelMap, GostKursblockungRegelTyp.SCHUELER_FIXIEREN_IN_KURS)) {
            schuelerID = regel4.parameter.get(0);
            kursID = regel4.parameter.get(1);
            schueler = this.gibSchueler(schuelerID);
            @NotNull KursblockungDynKurs fixierterKurs = this.gibKurs(kursID);
            for (KursblockungDynKurs kurs : fixierterKurs.gibFachart().gibKurse()) {
                if (kurs == fixierterKurs) continue;
                schueler.aktionSetzeKursSperrung(kurs.gibInternalID());
            }
        }
        for (GostBlockungRegel regel5 : MapUtils.getOrCreateArrayList(this._regelMap, GostKursblockungRegelTyp.SCHUELER_VERBIETEN_IN_KURS)) {
            schuelerID = regel5.parameter.get(0);
            kursID = regel5.parameter.get(1);
            schueler = this.gibSchueler(schuelerID);
            @NotNull KursblockungDynKurs verbotenerKurs = this.gibKurs(kursID);
            schueler.aktionSetzeKursSperrung(verbotenerKurs.gibInternalID());
        }
    }

    private void schritt12FehlerBeiRegel_7_oder_8() {
        KursblockungDynKurs kurs2;
        KursblockungDynKurs kurs1;
        long kursID2;
        long kursID1;
        for (GostBlockungRegel regel7 : MapUtils.getOrCreateArrayList(this._regelMap, GostKursblockungRegelTyp.KURS_VERBIETEN_MIT_KURS)) {
            kursID1 = regel7.parameter.get(0);
            kursID2 = regel7.parameter.get(1);
            kurs1 = this.gibKurs(kursID1);
            kurs2 = this.gibKurs(kursID2);
            this._statistik.regelHinzufuegenKursVerbieteMitKurs(kurs1, kurs2);
        }
        for (GostBlockungRegel regel8 : MapUtils.getOrCreateArrayList(this._regelMap, GostKursblockungRegelTyp.KURS_ZUSAMMEN_MIT_KURS)) {
            kursID1 = regel8.parameter.get(0);
            kursID2 = regel8.parameter.get(1);
            kurs1 = this.gibKurs(kursID1);
            kurs2 = this.gibKurs(kursID2);
            this._statistik.regelHinzufuegenKursZusammenMitKurs(kurs1, kurs2);
        }
    }

    private void schritt13FehlerBeiRegel_9() {
        for (GostBlockungRegel regel9 : MapUtils.getOrCreateArrayList(this._regelMap, GostKursblockungRegelTyp.KURS_MIT_DUMMY_SUS_AUFFUELLEN)) {
            long kursID = regel9.parameter.get(0);
            int susAnzahl = regel9.parameter.get(1).intValue();
            @NotNull KursblockungDynKurs kurs = this.gibKurs(kursID);
            for (int i = 0; i < susAnzahl; ++i) {
                kurs.aktionSchuelerDummyHinzufuegen();
            }
        }
    }

    private void schritt14FehlerBeiRegel_10(@NotNull GostBlockungsdatenManager pInput) {
        List<@NotNull GostBlockungRegel> regelnTyp10 = MapUtils.getOrCreateArrayList(this._regelMap, GostKursblockungRegelTyp.LEHRKRAEFTE_BEACHTEN);
        if (regelnTyp10.isEmpty()) {
            return;
        }
        DeveloperNotificationException.ifGreater("Liste of regelnTyp10", regelnTyp10.size(), 1L);
        @NotNull ArrayList<@NotNull GostBlockungKurs> vKurseMitLehrkraft = new ArrayList<GostBlockungKurs>();
        for (GostBlockungKurs gKurs : pInput.daten().kurse) {
            if (gKurs.lehrer.isEmpty()) continue;
            vKurseMitLehrkraft.add(gKurs);
        }
        for (GostBlockungKurs gKurs1 : vKurseMitLehrkraft) {
            for (GostBlockungKurs gKurs2 : vKurseMitLehrkraft) {
                if (gKurs1.id >= gKurs2.id) continue;
                for (GostBlockungKursLehrer gLehr1 : gKurs1.lehrer) {
                    for (GostBlockungKursLehrer gLehr2 : gKurs2.lehrer) {
                        if (gLehr1.id != gLehr2.id) continue;
                        @NotNull KursblockungDynKurs kurs1 = this.gibKurs(gKurs1.id);
                        @NotNull KursblockungDynKurs kurs2 = this.gibKurs(gKurs2.id);
                        this._statistik.regelHinzufuegenKursVerbieteMitKurs(kurs1, kurs2);
                    }
                }
            }
        }
    }

    @NotNull
    private KursblockungDynFachart gibFachart(long fachID, int kursart) {
        return this._fachartMap2D.getNonNullOrException(fachID, kursart);
    }

    @NotNull
    private KursblockungDynSchueler gibSchueler(long schuelerID) {
        return DeveloperNotificationException.ifMapGetIsNull(this._schuelerMap, schuelerID);
    }

    @NotNull
    private KursblockungDynKurs gibKurs(long kursID) {
        return DeveloperNotificationException.ifMapGetIsNull(this._kursMap, kursID);
    }

    @NotNull
    Logger gibLogger() {
        return this._logger;
    }

    @NotNull
    KursblockungDynStatistik gibStatistik() {
        return this._statistik;
    }

    long gibBlockungszeitMillis() {
        return this._maxTimeMillis;
    }

    int gibSchienenAnzahl() {
        return this._schienenArr.length;
    }

    @NotNull
    GostBlockungsergebnisManager gibErzeugtesKursblockungOutput(@NotNull GostBlockungsdatenManager pDataManager, long pErgebnisID) {
        @NotNull GostBlockungsergebnisManager out = new GostBlockungsergebnisManager(pDataManager, pErgebnisID);
        for (KursblockungDynKurs dynKurs : this._kursArr) {
            for (int schienenNr : dynKurs.gibSchienenLage()) {
                out.setKursSchienenNr(dynKurs.gibDatenbankID(), schienenNr + 1);
            }
        }
        for (KursblockungDynSchueler dynSchueler : this._schuelerArr) {
            for (KursblockungDynKurs kurs : dynSchueler.gibKurswahlen()) {
                if (kurs == null) continue;
                out.setSchuelerKurs(dynSchueler.gibDatenbankID(), kurs.gibDatenbankID(), true);
            }
        }
        for (GostBlockungRegel gRegel : pDataManager.regelGetListe()) {
            long l;
            long schuelerID;
            if (gRegel.typ != GostKursblockungRegelTyp.SCHUELER_FIXIEREN_IN_KURS.typ || out.getOfSchuelerOfKursIstZugeordnet(schuelerID = gRegel.parameter.get(0).longValue(), l = gRegel.parameter.get(1).longValue())) continue;
            out.setSchuelerKurs(schuelerID, l, true);
        }
        return out;
    }

    @NotNull
    @NotNull KursblockungDynKurs @NotNull [] gibKurseAlle() {
        return this._kursArr;
    }

    @NotNull
    @NotNull KursblockungDynKurs @NotNull [] gibKurseDieFreiSind() {
        return this._kursArrFrei;
    }

    int gibKurseDieFreiSindAnzahl() {
        return this._kursArrFrei.length;
    }

    long gibBewertungFachartPaar() {
        return this._statistik.gibBewertungFachartPaar();
    }

    @NotNull
    @NotNull KursblockungDynSchueler @NotNull [] gibSchuelerArray(boolean pNurMultiKurse) {
        if (pNurMultiKurse) {
            @NotNull LinkedCollection<@NotNull KursblockungDynSchueler> list = new LinkedCollection<KursblockungDynSchueler>();
            for (KursblockungDynSchueler schueler : this._schuelerArr) {
                if (!schueler.gibHatMultikurs()) continue;
                list.addLast(schueler);
            }
            @NotNull KursblockungDynSchueler @NotNull [] temp = new KursblockungDynSchueler[list.size()];
            for (int i = 0; i < temp.length; ++i) {
                temp[i] = (KursblockungDynSchueler)list.removeFirst();
            }
            return temp;
        }
        return this._schuelerArr;
    }

    @NotNull
    @NotNull KursblockungDynSchueler @NotNull [] gibSchuelerArrayAlle() {
        return this._schuelerArr;
    }

    int gibBewertungJetztBesserAlsS() {
        return this._statistik.gibBewertungZustandS_NW_KD();
    }

    int gibCompareZustandK_NW_KD_FW() {
        return this._statistik.gibCompareZustandK_NW_KD_FW();
    }

    int gibCompareZustandG_NW_KD_FW() {
        return this._statistik.gibCompareZustandG_NW_KD_FW();
    }

    int gibBewertungK_FW_NW_KD_JetztBesser() {
        return this._statistik.gibCompareZustandK_FW_NW_KD();
    }

    void aktionSchuelerAusAllenKursenEntfernen() {
        for (int i = 0; i < this._schuelerArr.length; ++i) {
            this._schuelerArr[i].aktionKurseAlleEntfernen();
        }
    }

    void debug() {
        int i;
        this._logger.modifyIndent(4);
        this._logger.logLn("########## Schienen ##########");
        for (i = 0; i < this._schienenArr.length; ++i) {
            this._logger.logLn("Schiene " + (i + 1));
            this._schienenArr[i].debug(false);
        }
        this._logger.logLn("########## Facharten ##########");
        for (i = 0; i < this._fachartArr.length; ++i) {
            this._logger.logLn("Fachart " + String.valueOf(this._fachartArr[i]) + " --> " + this._fachartArr[i].gibKursdifferenz());
            this._fachartArr[i].debug(this._schuelerArr);
        }
        this._logger.modifyIndent(-4);
        this._statistik.debug("");
    }

    void aktionZustandSpeichernS() {
        this._statistik.aktionBewertungSpeichernS();
        for (KursblockungDynKurs kurs : this._kursArr) {
            kurs.aktionZustandSpeichernS();
        }
        for (KursblockungDynSchueler schueler : this._schuelerArr) {
            schueler.aktionZustandSpeichernS();
        }
    }

    void aktionZustandSpeichernK() {
        this._statistik.aktionBewertungSpeichernK();
        for (KursblockungDynKurs kurs : this._kursArr) {
            kurs.aktionZustandSpeichernK();
        }
        for (KursblockungDynSchueler schueler : this._schuelerArr) {
            schueler.aktionZustandSpeichernK();
        }
    }

    void aktionZustandSpeichernG() {
        this._statistik.aktionBewertungSpeichernG();
        for (KursblockungDynKurs kurs : this._kursArr) {
            kurs.aktionZustandSpeichernG();
        }
        for (KursblockungDynSchueler schueler : this._schuelerArr) {
            schueler.aktionZustandSpeichernG();
        }
    }

    void aktionZustandLadenS() {
        for (KursblockungDynSchueler kursblockungDynSchueler : this._schuelerArr) {
            kursblockungDynSchueler.aktionKurseAlleEntfernen();
        }
        for (KursblockungDynKurs kursblockungDynKurs : this._kursArr) {
            kursblockungDynKurs.aktionZustandLadenS();
        }
        for (KursblockungDynSchueler kursblockungDynSchueler : this._schuelerArr) {
            kursblockungDynSchueler.aktionZustandLadenS();
        }
    }

    void aktionZustandLadenK() {
        for (KursblockungDynSchueler kursblockungDynSchueler : this._schuelerArr) {
            kursblockungDynSchueler.aktionKurseAlleEntfernen();
        }
        for (KursblockungDynKurs kursblockungDynKurs : this._kursArr) {
            kursblockungDynKurs.aktionZustandLadenK();
        }
        for (KursblockungDynSchueler kursblockungDynSchueler : this._schuelerArr) {
            kursblockungDynSchueler.aktionZustandLadenK();
        }
    }

    void aktionZustandLadenG() {
        for (KursblockungDynSchueler kursblockungDynSchueler : this._schuelerArr) {
            kursblockungDynSchueler.aktionKurseAlleEntfernen();
        }
        for (KursblockungDynKurs kursblockungDynKurs : this._kursArr) {
            kursblockungDynKurs.aktionZustandLadenG();
        }
        for (KursblockungDynSchueler kursblockungDynSchueler : this._schuelerArr) {
            kursblockungDynSchueler.aktionZustandLadenG();
        }
    }

    void aktionZustandLadenKohneSuS() {
        for (KursblockungDynSchueler schueler : this._schuelerArr) {
            schueler.aktionKurseAlleEntfernen();
        }
        for (KursblockungDynKurs kurs : this._kursArr) {
            kurs.aktionZustandLadenK();
        }
    }

    void aktionKurseFreieZufaelligVerteilen() {
        for (KursblockungDynKurs kurs : this._kursArrFrei) {
            kurs.aktionZufaelligVerteilen();
        }
    }

    void aktionKursVerteilenEinenZufaelligenFreien() {
        if (this._kursArrFrei.length == 0) {
            return;
        }
        int index = this._random.nextInt(this._kursArrFrei.length);
        @NotNull KursblockungDynKurs kurs = this._kursArrFrei[index];
        kurs.aktionZufaelligVerteilen();
    }

    void aktionKursFreienEinenZufaelligVerteilenAberNichtMultikurse() {
        int[] perm;
        if (this._kursArrFrei.length == 0) {
            return;
        }
        for (int index : perm = KursblockungStatic.gibPermutation(this._random, this._kursArrFrei.length)) {
            KursblockungDynKurs kurs = this._kursArrFrei[index];
            if (kurs.gibSchienenAnzahl() != 1) continue;
            kurs.aktionZufaelligVerteilen();
        }
    }

    int gibBewertung_NW_KD_JetztS() {
        return this._statistik.gibBewertungZustandS_NW_KD();
    }

    boolean aktionKurseVerteilenNachSchuelerwunsch() {
        boolean kurslagenVeraenderung = false;
        @NotNull int[] perm = KursblockungStatic.gibPermutation(this._random, this._schuelerArr.length);
        for (int pSchueler = 0; pSchueler < perm.length; ++pSchueler) {
            KursblockungDynSchueler schueler = this._schuelerArr[perm[pSchueler]];
            schueler.aktionKurseVerteilenNurMultikurseZufaellig();
            kurslagenVeraenderung |= schueler.aktionKurseVerteilenNachDeinemWunsch();
        }
        return kurslagenVeraenderung;
    }

    void aktionSchuelerVerteilenMitBipartitemMatching() {
        @NotNull int[] perm = KursblockungStatic.gibPermutation(this._random, this._schuelerArr.length);
        for (int p = 0; p < perm.length; ++p) {
            int i = perm[p];
            KursblockungDynSchueler schueler = this._schuelerArr[i];
            schueler.aktionKurseVerteilenNurMultikurseZufaellig();
            schueler.aktionKurseVerteilenNurFachartenMitEinemKurs();
            schueler.aktionKurseVerteilenMitBipartiteMatching();
        }
    }

    void aktionSchuelerVerteilenMitGewichtetenBipartitemMatching() {
        @NotNull int[] perm = KursblockungStatic.gibPermutation(this._random, this._schuelerArr.length);
        for (int p = 0; p < perm.length; ++p) {
            int i = perm[p];
            KursblockungDynSchueler schueler = this._schuelerArr[i];
            schueler.aktionKurseVerteilenNurMultikurseZufaellig();
            schueler.aktionKurseVerteilenNurFachartenMitEinemKurs();
            schueler.aktionKurseVerteilenMitBipartiteMatchingGewichtetem();
        }
    }
}

