/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.kursblockung;

import de.svws_nrw.core.data.gost.GostFach;
import de.svws_nrw.core.exceptions.DeveloperNotificationException;
import de.svws_nrw.core.kursblockung.KursblockungDynKurs;
import de.svws_nrw.core.kursblockung.KursblockungDynSchueler;
import de.svws_nrw.core.kursblockung.KursblockungDynStatistik;
import de.svws_nrw.core.kursblockung.KursblockungStatic;
import de.svws_nrw.core.types.gost.GostKursart;
import jakarta.validation.constraints.NotNull;
import java.util.Random;

public class KursblockungDynFachart {
    @NotNull
    private final Random _random;
    private final int nr;
    @NotNull
    private final GostFach gostFach;
    @NotNull
    private final GostKursart gostKursart;
    @NotNull
    private @NotNull KursblockungDynKurs @NotNull [] kursArr;
    private int schuelerMax;
    private int kurseMax;
    private int schuelerAnzNow;
    @NotNull
    private final KursblockungDynStatistik statistik;

    public KursblockungDynFachart(@NotNull Random pRandom, int pNr, @NotNull GostFach pGostFach, @NotNull GostKursart pGostKursart, @NotNull KursblockungDynStatistik pStatistik) {
        this._random = pRandom;
        this.nr = pNr;
        this.gostFach = pGostFach;
        this.gostKursart = pGostKursart;
        this.statistik = pStatistik;
        this.kursArr = new KursblockungDynKurs[0];
        this.kurseMax = 0;
        this.schuelerMax = 0;
        this.schuelerAnzNow = 0;
    }

    @NotNull
    public String toString() {
        return this.gostFach.kuerzel + ";" + this.gostKursart.kuerzel;
    }

    int gibNr() {
        return this.nr;
    }

    int gibSchuelerMax() {
        return this.schuelerMax;
    }

    int gibSchuelerZordnungen() {
        return this.schuelerAnzNow;
    }

    int gibKurseMax() {
        return this.kurseMax;
    }

    int gibKursdifferenz() {
        return this.kursArr[this.kursArr.length - 1].gibSchuelerAnzahl() - this.kursArr[0].gibSchuelerAnzahl();
    }

    @NotNull
    @NotNull KursblockungDynKurs @NotNull [] gibKurse() {
        return this.kursArr;
    }

    KursblockungDynKurs gibKleinstenKursInSchiene(int pSchiene, @NotNull boolean[] kursGesperrt) {
        for (int i = 0; i < this.kursArr.length; ++i) {
            KursblockungDynKurs kurs = this.kursArr[i];
            if (kursGesperrt[kurs.gibInternalID()]) continue;
            for (int c : kurs.gibSchienenLage()) {
                if (c != pSchiene) continue;
                return kurs;
            }
        }
        return null;
    }

    boolean gibHatMultikurs() {
        for (KursblockungDynKurs kurs : this.kursArr) {
            if (kurs.gibSchienenAnzahl() <= 1) continue;
            return true;
        }
        return false;
    }

    boolean gibHatKursInSchiene(int pSchiene, @NotNull boolean[] kursGesperrt) {
        for (KursblockungDynKurs kurs : this.kursArr) {
            if (kursGesperrt[kurs.gibInternalID()] || !kurs.gibIstInSchiene(pSchiene)) continue;
            return true;
        }
        return false;
    }

    public boolean gibHatKursMitFreierSchiene(int pSchiene, @NotNull boolean[] kursGesperrt) {
        for (KursblockungDynKurs kurs : this.kursArr) {
            if (kursGesperrt[kurs.gibInternalID()] || !kurs.gibIstSchieneFrei(pSchiene)) continue;
            return true;
        }
        return false;
    }

    public void aktionSetKurse(@NotNull @NotNull KursblockungDynKurs @NotNull [] pKursArr) {
        this.kursArr = pKursArr;
    }

    public void aktionMaxSchuelerErhoehen() {
        ++this.schuelerMax;
    }

    public void aktionMaxKurseErhoehen() {
        ++this.kurseMax;
    }

    public void aktionKursdifferenzEntfernen() {
        this.statistik.aktionKursdifferenzEntfernen(this.gibKursdifferenz());
    }

    public void aktionKursdifferenzHinzufuegen() {
        this.statistik.aktionKursdifferenzHinzufuegen(this.gibKursdifferenz());
    }

    public void aktionSchuelerWurdeHinzugefuegt() {
        ++this.schuelerAnzNow;
        for (int i = 1; i < this.kursArr.length; ++i) {
            boolean b2;
            @NotNull KursblockungDynKurs kursL = this.kursArr[i - 1];
            @NotNull KursblockungDynKurs kursR = this.kursArr[i];
            boolean b1 = kursL.gibSchuelerAnzahl() > kursR.gibSchuelerAnzahl();
            boolean bl = b2 = kursL.gibSchuelerAnzahl() == kursR.gibSchuelerAnzahl() && kursL.gibDatenbankID() > kursR.gibDatenbankID();
            if (!b1 && !b2) continue;
            this.kursArr[i - 1] = kursR;
            this.kursArr[i] = kursL;
        }
    }

    public void aktionSchuelerWurdeEntfernt() {
        --this.schuelerAnzNow;
        for (int i = this.kursArr.length - 1; i >= 1; --i) {
            boolean b2;
            @NotNull KursblockungDynKurs kursL = this.kursArr[i - 1];
            @NotNull KursblockungDynKurs kursR = this.kursArr[i];
            boolean b1 = kursL.gibSchuelerAnzahl() > kursR.gibSchuelerAnzahl();
            boolean bl = b2 = kursL.gibSchuelerAnzahl() == kursR.gibSchuelerAnzahl() && kursL.gibDatenbankID() > kursR.gibDatenbankID();
            if (!b1 && !b2) continue;
            this.kursArr[i - 1] = kursR;
            this.kursArr[i] = kursL;
        }
    }

    void aktionZufaelligerKursWandertNachSchiene(int pSchiene) {
        @NotNull int[] perm = KursblockungStatic.gibPermutation(this._random, this.kursArr.length);
        for (int p = 0; p < perm.length; ++p) {
            KursblockungDynKurs kurs = this.kursArr[perm[p]];
            if (!kurs.gibIstSchieneFrei(pSchiene)) continue;
            kurs.aktionSetzeInSchiene(pSchiene);
            return;
        }
        throw new DeveloperNotificationException("aktionZufaelligerKursWandertNachSchiene: THIS SHOULD NOT BE REACHED!!!");
    }

    void debug(@NotNull @NotNull KursblockungDynSchueler @NotNull [] schuelerArr) {
        for (int i = 0; i < this.kursArr.length; ++i) {
            this.kursArr[i].debug(schuelerArr);
        }
    }

    @NotNull
    GostFach gibFach() {
        return this.gostFach;
    }

    @NotNull
    GostKursart gibKursart() {
        return this.gostKursart;
    }
}

