/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.kursblockung;

import de.svws_nrw.core.adt.collection.LinkedCollection;
import de.svws_nrw.core.kursblockung.KursblockungDynFachart;
import de.svws_nrw.core.kursblockung.KursblockungDynSchiene;
import de.svws_nrw.core.kursblockung.KursblockungDynSchueler;
import de.svws_nrw.core.logger.LogLevel;
import de.svws_nrw.core.logger.Logger;
import jakarta.validation.constraints.NotNull;
import java.util.Random;

public class KursblockungDynKurs {
    @NotNull
    private final Random _random;
    private final long databaseID;
    private final int internalID;
    @NotNull
    private final KursblockungDynFachart fachart;
    @NotNull
    private final @NotNull KursblockungDynSchiene @NotNull [] schienenLage;
    @NotNull
    private final @NotNull KursblockungDynSchiene @NotNull [] schienenLageSaveS;
    @NotNull
    private final @NotNull KursblockungDynSchiene @NotNull [] schienenLageSaveK;
    @NotNull
    private final @NotNull KursblockungDynSchiene @NotNull [] schienenLageSaveG;
    private final int schienenLageFixiert;
    @NotNull
    private final @NotNull KursblockungDynSchiene @NotNull [] schienenFrei;
    @NotNull
    private final @NotNull KursblockungDynSchiene @NotNull [] schienenFreiSaveS;
    @NotNull
    private final @NotNull KursblockungDynSchiene @NotNull [] schienenFreiSaveK;
    @NotNull
    private final @NotNull KursblockungDynSchiene @NotNull [] schienenFreiSaveG;
    private int schuelerAnz;
    private int schuelerAnzDummy;
    @NotNull
    private final Logger logger;

    public KursblockungDynKurs(@NotNull Random pRandom, @NotNull @NotNull KursblockungDynSchiene @NotNull [] pSchienenLage, int pSchienenLageFixiert, @NotNull @NotNull KursblockungDynSchiene @NotNull [] pSchienenFrei, long pKursID, @NotNull KursblockungDynFachart pFachart, @NotNull Logger pLogger, int pInternalID) {
        int i;
        this._random = pRandom;
        this.schienenLage = pSchienenLage;
        this.schienenLageFixiert = pSchienenLageFixiert;
        this.schienenFrei = pSchienenFrei;
        this.databaseID = pKursID;
        this.fachart = pFachart;
        this.schuelerAnz = 0;
        this.schuelerAnzDummy = 0;
        this.logger = pLogger;
        this.internalID = pInternalID;
        this.schienenLageSaveS = new KursblockungDynSchiene[this.schienenLage.length];
        this.schienenLageSaveK = new KursblockungDynSchiene[this.schienenLage.length];
        this.schienenLageSaveG = new KursblockungDynSchiene[this.schienenLage.length];
        for (i = 0; i < this.schienenLage.length; ++i) {
            this.schienenLageSaveS[i] = this.schienenLage[i];
            this.schienenLageSaveK[i] = this.schienenLage[i];
            this.schienenLageSaveG[i] = this.schienenLage[i];
        }
        this.schienenFreiSaveS = new KursblockungDynSchiene[this.schienenFrei.length];
        this.schienenFreiSaveK = new KursblockungDynSchiene[this.schienenFrei.length];
        this.schienenFreiSaveG = new KursblockungDynSchiene[this.schienenFrei.length];
        for (i = 0; i < this.schienenFrei.length; ++i) {
            this.schienenFreiSaveS[i] = this.schienenFrei[i];
            this.schienenFreiSaveK[i] = this.schienenFrei[i];
            this.schienenFreiSaveG[i] = this.schienenFrei[i];
        }
        for (i = 0; i < this.schienenLage.length; ++i) {
            this.schienenLage[i].aktionKursHinzufuegen(this);
        }
    }

    @NotNull
    public String toString() {
        return "Kurs (dbID=" + this.databaseID + ", intiD=" + this.internalID + ")";
    }

    public long gibDatenbankID() {
        return this.databaseID;
    }

    @NotNull
    public KursblockungDynFachart gibFachart() {
        return this.fachart;
    }

    public int gibSchuelerAnzahl() {
        return this.schuelerAnz + this.schuelerAnzDummy;
    }

    public boolean gibHatFreiheitsgrade() {
        return this.schienenLageFixiert < this.schienenLage.length && this.schienenFrei.length > 0;
    }

    @NotNull
    public int[] gibSchienenLage() {
        int length = this.schienenLage.length;
        @NotNull int[] lage = new int[length];
        for (int i = 0; i < length; ++i) {
            lage[i] = this.schienenLage[i].gibNr();
        }
        return lage;
    }

    public int gibSchienenAnzahl() {
        return this.schienenLage.length;
    }

    public long gibGewichtetesMatchingBewertung() {
        long anzahl = this.gibSchuelerAnzahl();
        return anzahl * anzahl;
    }

    boolean gibIstSchieneGesperrt(int pSchiene) {
        for (KursblockungDynSchiene s : this.schienenLage) {
            if (s.gibNr() != pSchiene) continue;
            return false;
        }
        for (KursblockungDynSchiene s : this.schienenFrei) {
            if (s.gibNr() != pSchiene) continue;
            return false;
        }
        return true;
    }

    boolean gibIstSchieneFixiert(int pSchiene) {
        for (int iLage = 0; iLage < this.schienenLageFixiert; ++iLage) {
            if (this.schienenLage[iLage].gibNr() != pSchiene) continue;
            return true;
        }
        return false;
    }

    boolean gibIstInSchiene(int pSchiene) {
        for (int i = 0; i < this.schienenLage.length; ++i) {
            if (this.schienenLage[i].gibNr() != pSchiene) continue;
            return true;
        }
        return false;
    }

    boolean gibIstImSchienenIntervall(int schieneVon, int schieneBis) {
        for (int i = 0; i < this.schienenLage.length; ++i) {
            if (this.schienenLage[i].gibNr() < schieneVon || this.schienenLage[i].gibNr() > schieneBis) continue;
            return true;
        }
        return false;
    }

    public boolean gibIstSchieneFrei(int pSchiene) {
        for (int i = 0; i < this.schienenFrei.length; ++i) {
            if (this.schienenFrei[i].gibNr() != pSchiene) continue;
            return true;
        }
        return false;
    }

    int gibInternalID() {
        return this.internalID;
    }

    public void aktionZustandSpeichernS() {
        System.arraycopy(this.schienenLage, 0, this.schienenLageSaveS, 0, this.schienenLage.length);
        System.arraycopy(this.schienenFrei, 0, this.schienenFreiSaveS, 0, this.schienenFrei.length);
    }

    public void aktionZustandSpeichernK() {
        System.arraycopy(this.schienenLage, 0, this.schienenLageSaveK, 0, this.schienenLage.length);
        System.arraycopy(this.schienenFrei, 0, this.schienenFreiSaveK, 0, this.schienenFrei.length);
    }

    public void aktionZustandSpeichernG() {
        System.arraycopy(this.schienenLage, 0, this.schienenLageSaveG, 0, this.schienenLage.length);
        System.arraycopy(this.schienenFrei, 0, this.schienenFreiSaveG, 0, this.schienenFrei.length);
    }

    public void aktionZustandLadenS() {
        this.aktionSchienenLageEntfernen();
        System.arraycopy(this.schienenLageSaveS, 0, this.schienenLage, 0, this.schienenLage.length);
        System.arraycopy(this.schienenFreiSaveS, 0, this.schienenFrei, 0, this.schienenFrei.length);
        this.aktionSchienenLageHinzufuegen();
    }

    public void aktionZustandLadenK() {
        this.aktionSchienenLageEntfernen();
        System.arraycopy(this.schienenLageSaveK, 0, this.schienenLage, 0, this.schienenLage.length);
        System.arraycopy(this.schienenFreiSaveK, 0, this.schienenFrei, 0, this.schienenFrei.length);
        this.aktionSchienenLageHinzufuegen();
    }

    public void aktionZustandLadenG() {
        this.aktionSchienenLageEntfernen();
        System.arraycopy(this.schienenLageSaveG, 0, this.schienenLage, 0, this.schienenLage.length);
        System.arraycopy(this.schienenFreiSaveG, 0, this.schienenFrei, 0, this.schienenFrei.length);
        this.aktionSchienenLageHinzufuegen();
    }

    public void aktionZufaelligVerteilen() {
        if (!this.gibHatFreiheitsgrade()) {
            return;
        }
        if (this.schuelerAnz > 0) {
            this.logger.log(LogLevel.ERROR, "Kurs.aktionZufaelligVerteilen: schuelerAnz > 0 (Ein Kurs mit SuS darf nicht verteilt werden)");
            return;
        }
        for (int i1 = this.schienenLageFixiert; i1 < this.schienenLage.length; ++i1) {
            int i2 = this._random.nextInt(this.schienenFrei.length);
            @NotNull KursblockungDynSchiene schiene1 = this.schienenLage[i1];
            KursblockungDynSchiene schiene2 = this.schienenFrei[i2];
            schiene1.aktionKursEntfernen(this);
            schiene2.aktionKursHinzufuegen(this);
            this.schienenLage[i1] = schiene2;
            this.schienenFrei[i2] = schiene1;
        }
    }

    public void aktionVerteileAufSchienen(@NotNull @NotNull LinkedCollection<@NotNull Integer> pSchienenWahl) {
        block0: for (int iLage = this.schienenLageFixiert; iLage < this.schienenLage.length; ++iLage) {
            @NotNull KursblockungDynSchiene schieneL = this.schienenLage[iLage];
            if (pSchienenWahl.contains(schieneL.gibNr())) continue;
            for (int iFrei = 0; iFrei < this.schienenFrei.length; ++iFrei) {
                KursblockungDynSchiene schieneF = this.schienenFrei[iFrei];
                if (!pSchienenWahl.contains(schieneF.gibNr())) continue;
                schieneL.aktionKursEntfernen(this);
                schieneF.aktionKursHinzufuegen(this);
                this.schienenFrei[iFrei] = schieneL;
                this.schienenLage[iLage] = schieneF;
                continue block0;
            }
        }
    }

    void aktionSetzeInSchiene(int pSchiene) {
        for (int iLage = this.schienenLageFixiert; iLage < this.schienenLage.length; ++iLage) {
            @NotNull KursblockungDynSchiene schieneL = this.schienenLage[iLage];
            if (schieneL.gibNr() == pSchiene) {
                return;
            }
            for (int iFrei = 0; iFrei < this.schienenFrei.length; ++iFrei) {
                KursblockungDynSchiene schieneF = this.schienenFrei[iFrei];
                if (pSchiene != schieneF.gibNr()) continue;
                schieneL.aktionKursEntfernen(this);
                schieneF.aktionKursHinzufuegen(this);
                this.schienenFrei[iFrei] = schieneL;
                this.schienenLage[iLage] = schieneF;
                return;
            }
        }
    }

    public void aktionSchuelerEntfernen() {
        this.fachart.aktionKursdifferenzEntfernen();
        --this.schuelerAnz;
        this.fachart.aktionSchuelerWurdeEntfernt();
        this.fachart.aktionKursdifferenzHinzufuegen();
    }

    public void aktionSchuelerHinzufuegen() {
        this.fachart.aktionKursdifferenzEntfernen();
        ++this.schuelerAnz;
        this.fachart.aktionSchuelerWurdeHinzugefuegt();
        this.fachart.aktionKursdifferenzHinzufuegen();
    }

    public void aktionSchuelerDummyHinzufuegen() {
        this.fachart.aktionKursdifferenzEntfernen();
        ++this.schuelerAnzDummy;
        this.fachart.aktionSchuelerWurdeHinzugefuegt();
        this.fachart.aktionKursdifferenzHinzufuegen();
    }

    private void aktionSchienenLageHinzufuegen() {
        for (int i = 0; i < this.schienenLage.length; ++i) {
            this.schienenLage[i].aktionKursHinzufuegen(this);
        }
    }

    private void aktionSchienenLageEntfernen() {
        for (int i = 0; i < this.schienenLage.length; ++i) {
            this.schienenLage[i].aktionKursEntfernen(this);
        }
    }

    void debug(@NotNull @NotNull KursblockungDynSchueler @NotNull [] schuelerArr) {
        this.logger.modifyIndent(4);
        this.logger.logLn(this.toString() + " --> " + this.schuelerAnz + " SuS.");
        for (KursblockungDynSchueler s : schuelerArr) {
            KursblockungDynKurs[] kurse;
            for (KursblockungDynKurs kurs : kurse = s.gibKurswahlen()) {
                if (kurs != this) continue;
                this.logger.logLn("        " + s.gibDatenbankID());
            }
        }
        this.logger.modifyIndent(-4);
    }
}

