/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.kursblockung;

import de.svws_nrw.core.adt.set.AVLSet;
import de.svws_nrw.core.exceptions.UserNotificationException;
import de.svws_nrw.core.kursblockung.KursblockungDynKurs;
import de.svws_nrw.core.kursblockung.KursblockungDynStatistik;
import de.svws_nrw.core.logger.LogLevel;
import de.svws_nrw.core.logger.Logger;
import jakarta.validation.constraints.NotNull;
import java.util.HashMap;

public class KursblockungDynSchiene {
    private final int nr;
    @NotNull
    private final Logger logger;
    @NotNull
    private final @NotNull HashMap<@NotNull Long, @NotNull KursblockungDynKurs> kursMap;
    @NotNull
    private final KursblockungDynStatistik statistik;

    public KursblockungDynSchiene(@NotNull Logger pLogger, int pNr, @NotNull KursblockungDynStatistik pStatistik) {
        this.logger = pLogger;
        this.nr = pNr;
        this.kursMap = new HashMap();
        this.statistik = pStatistik;
    }

    @NotNull
    public String toString() {
        return "" + this.nr;
    }

    public void aktionKursHinzufuegen(@NotNull KursblockungDynKurs kurs1) {
        long kursID = kurs1.gibDatenbankID();
        if (this.kursMap.containsKey(kursID)) {
            String fehler = "Kurs '" + kurs1.toString() + "' soll in Schiene " + this.nr + ", ist aber bereits drin.";
            this.logger.logLn(LogLevel.ERROR, fehler);
            throw new UserNotificationException(fehler);
        }
        for (KursblockungDynKurs kurs2 : this.kursMap.values()) {
            this.statistik.aktionKurspaarInSchieneHinzufuegen(kurs1, kurs2);
        }
        this.kursMap.put(kursID, kurs1);
    }

    public void aktionKursEntfernen(@NotNull KursblockungDynKurs kurs1) {
        long kursID = kurs1.gibDatenbankID();
        if (!this.kursMap.containsKey(kursID)) {
            String fehler = "Kurs '" + kurs1.toString() + "' soll aus Schiene " + this.nr + " entfernt werden, ist aber nicht drin.";
            this.logger.logLn(LogLevel.ERROR, fehler);
            throw new UserNotificationException(fehler);
        }
        this.kursMap.remove(kursID);
        for (KursblockungDynKurs kurs2 : this.kursMap.values()) {
            this.statistik.aktionKurspaarInSchieneEntfernen(kurs1, kurs2);
        }
    }

    public int gibNr() {
        return this.nr;
    }

    public int gibKursAnzahl() {
        return this.kursMap.size();
    }

    public void debug(boolean nurMultikurse) {
        this.logger.modifyIndent(4);
        for (KursblockungDynKurs k : this.kursMap.values()) {
            if (nurMultikurse && k.gibSchienenAnzahl() < 2) continue;
            this.logger.logLn("    " + k.toString());
        }
        this.logger.modifyIndent(-4);
    }

    int gibAnzahlGleicherFacharten() {
        AVLSet<Integer> setFachart = new AVLSet<Integer>();
        int summe = 0;
        for (KursblockungDynKurs kurs : this.kursMap.values()) {
            if (setFachart.add(kurs.gibFachart().gibNr())) continue;
            ++summe;
        }
        return summe;
    }
}

