/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.kursblockung;

import de.svws_nrw.core.exceptions.DeveloperNotificationException;
import de.svws_nrw.core.kursblockung.KursblockungDynFachart;
import de.svws_nrw.core.kursblockung.KursblockungDynKurs;
import de.svws_nrw.core.kursblockung.KursblockungDynStatistik;
import de.svws_nrw.core.kursblockung.KursblockungMatrix;
import de.svws_nrw.core.kursblockung.KursblockungStatic;
import de.svws_nrw.core.logger.Logger;
import jakarta.validation.constraints.NotNull;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Random;

public class KursblockungDynSchueler {
    @NotNull
    private final Random _random;
    @NotNull
    private final Logger _logger;
    private final long guiID;
    @NotNull
    private final String representation;
    @NotNull
    private @NotNull KursblockungDynFachart @NotNull [] fachartArr;
    @NotNull
    private KursblockungDynKurs[] fachartZuKurs;
    @NotNull
    private KursblockungDynKurs[] fachartZuKursSaveS;
    @NotNull
    private KursblockungDynKurs[] fachartZuKursSaveK;
    @NotNull
    private KursblockungDynKurs[] fachartZuKursSaveG;
    @NotNull
    private final KursblockungDynStatistik statistik;
    private int nichtwahlen;
    @NotNull
    private final boolean[] schieneBelegt;
    @NotNull
    private KursblockungMatrix matrix;
    @NotNull
    private final boolean[] kursGesperrt;

    KursblockungDynSchueler(@NotNull Logger pLogger, @NotNull Random pRandom, long pSchuelerID, @NotNull KursblockungDynStatistik pStatistik, int pSchienenAnzahl, int pKursAnzahl) {
        this._random = pRandom;
        this._logger = pLogger;
        this.guiID = pSchuelerID;
        this.representation = "Sch\u00fcler " + pSchuelerID;
        this.statistik = pStatistik;
        this.fachartArr = new KursblockungDynFachart[0];
        this.fachartZuKurs = new KursblockungDynKurs[0];
        this.fachartZuKursSaveS = new KursblockungDynKurs[0];
        this.fachartZuKursSaveK = new KursblockungDynKurs[0];
        this.fachartZuKursSaveG = new KursblockungDynKurs[0];
        this.nichtwahlen = 0;
        this.schieneBelegt = new boolean[pSchienenAnzahl];
        this.kursGesperrt = new boolean[pKursAnzahl];
        this.matrix = new KursblockungMatrix(this._random, 0, 0);
    }

    @NotNull
    public String toString() {
        return this.representation;
    }

    @NotNull
    long gibDatenbankID() {
        return this.guiID;
    }

    @NotNull
    String gibRepresentation() {
        return this.representation;
    }

    int gibNichtwahlen() {
        return this.nichtwahlen;
    }

    @NotNull
    @NotNull KursblockungDynFachart @NotNull [] gibFacharten() {
        return this.fachartArr;
    }

    boolean gibHatMultikurs() {
        for (KursblockungDynFachart fachart : this.fachartArr) {
            if (!fachart.gibHatMultikurs()) continue;
            return true;
        }
        return false;
    }

    @NotNull
    KursblockungDynKurs[] gibKurswahlen() {
        return this.fachartZuKurs;
    }

    void aktionSetzeFachartenUndIDs(@NotNull @NotNull KursblockungDynFachart @NotNull [] pFacharten) {
        int nFacharten = pFacharten.length;
        this.fachartArr = pFacharten;
        this.fachartZuKurs = new KursblockungDynKurs[nFacharten];
        this.fachartZuKursSaveS = new KursblockungDynKurs[nFacharten];
        this.fachartZuKursSaveK = new KursblockungDynKurs[nFacharten];
        this.fachartZuKursSaveG = new KursblockungDynKurs[nFacharten];
        this.statistik.aktionNichtwahlenVeraendern(nFacharten);
        this.nichtwahlen = nFacharten;
        for (int i = 1; i < nFacharten; ++i) {
            for (int j = i; j >= 1; --j) {
                KursblockungDynFachart fR;
                int anzR;
                int anzL = this.fachartArr[j - 1].gibKurseMax();
                if (anzL <= (anzR = this.fachartArr[j].gibKurseMax())) continue;
                KursblockungDynFachart fL = this.fachartArr[j - 1];
                this.fachartArr[j - 1] = fR = this.fachartArr[j];
                this.fachartArr[j] = fL;
            }
        }
        this.matrix = new KursblockungMatrix(this._random, nFacharten, this.schieneBelegt.length);
    }

    void aktionSetzeKursSperrung(int pInterneKursID) {
        this.kursGesperrt[pInterneKursID] = true;
    }

    void aktionZustandSpeichernS() {
        System.arraycopy(this.fachartZuKurs, 0, this.fachartZuKursSaveS, 0, this.fachartZuKurs.length);
    }

    void aktionZustandSpeichernK() {
        System.arraycopy(this.fachartZuKurs, 0, this.fachartZuKursSaveK, 0, this.fachartZuKurs.length);
    }

    void aktionZustandSpeichernG() {
        System.arraycopy(this.fachartZuKurs, 0, this.fachartZuKursSaveG, 0, this.fachartZuKurs.length);
    }

    void aktionZustandLadenS() {
        this.aktionWaehleKurse(this.fachartZuKursSaveS);
    }

    void aktionZustandLadenK() {
        this.aktionWaehleKurse(this.fachartZuKursSaveK);
    }

    void aktionZustandLadenG() {
        this.aktionWaehleKurse(this.fachartZuKursSaveG);
    }

    private void aktionWaehleKurse(@NotNull KursblockungDynKurs[] wahl) {
        this.aktionKurseAlleEntfernen();
        for (int i = 0; i < this.fachartZuKurs.length; ++i) {
            KursblockungDynKurs kurs = wahl[i];
            if (kurs == null) continue;
            if (this.kursGesperrt[kurs.gibInternalID()]) {
                throw new DeveloperNotificationException("FEHLER: Sch\u00fcler " + this.guiID + " darf den Kurs " + kurs.gibDatenbankID() + " nicht w\u00e4hlen.");
            }
            this.aktionKursHinzufuegen(i, kurs);
        }
    }

    void aktionKurseAlleEntfernen() {
        for (int i = 0; i < this.fachartArr.length; ++i) {
            KursblockungDynKurs kurs = this.fachartZuKurs[i];
            if (kurs == null) continue;
            this.aktionKursEntfernen(i, kurs);
        }
    }

    void aktionKurseVerteilenNurMultikurseZufaellig() {
        @NotNull int[] perm = KursblockungStatic.gibPermutation(this._random, this.fachartArr.length);
        block0: for (int pFachart = 0; pFachart < this.fachartArr.length; ++pFachart) {
            KursblockungDynFachart fachart;
            int iFachart = perm[pFachart];
            if (this.fachartZuKurs[iFachart] != null || !(fachart = this.fachartArr[iFachart]).gibHatMultikurs()) continue;
            @NotNull KursblockungDynKurs @NotNull [] kurse = fachart.gibKurse();
            @NotNull int[] perm2 = KursblockungStatic.gibPermutation(this._random, kurse.length);
            for (int pKurs = 0; pKurs < perm2.length; ++pKurs) {
                KursblockungDynKurs kurs = kurse[perm2[pKurs]];
                if (this.kursGesperrt[kurs.gibInternalID()]) continue;
                boolean waehlbar = true;
                for (int nr : kurs.gibSchienenLage()) {
                    if (!this.schieneBelegt[nr]) continue;
                    waehlbar = false;
                }
                if (!waehlbar) continue;
                this.aktionKursHinzufuegen(iFachart, kurs);
                continue block0;
            }
        }
    }

    void aktionKurseVerteilenNurFachartenMitEinemKurs() {
        block0: for (int iFachart = 0; iFachart < this.fachartArr.length; ++iFachart) {
            KursblockungDynFachart fachart;
            if (this.fachartZuKurs[iFachart] != null || (fachart = this.fachartArr[iFachart]).gibKurseMax() != 1) continue;
            @NotNull KursblockungDynKurs @NotNull [] kurse = fachart.gibKurse();
            for (int iKurse = 0; iKurse < kurse.length; ++iKurse) {
                KursblockungDynKurs kurs = kurse[iKurse];
                if (this.kursGesperrt[kurs.gibInternalID()]) continue;
                boolean waehlbar = true;
                for (int nr : kurs.gibSchienenLage()) {
                    if (!this.schieneBelegt[nr]) continue;
                    waehlbar = false;
                }
                if (!waehlbar) continue;
                this.aktionKursHinzufuegen(iFachart, kurs);
                continue block0;
            }
        }
    }

    void aktionKurseVerteilenMitBipartiteMatchingGewichtetem() {
        long _INFINITY = 1000000L;
        @NotNull long @NotNull [][] data = this.matrix.getMatrix();
        for (int r = 0; r < this.fachartArr.length; ++r) {
            int c;
            for (c = 0; c < this.schieneBelegt.length; ++c) {
                data[r][c] = 1000000L;
            }
            if (this.fachartZuKurs[r] != null || this.fachartArr[r].gibHatMultikurs()) continue;
            for (c = 0; c < this.schieneBelegt.length; ++c) {
                KursblockungDynKurs kurs;
                if (this.schieneBelegt[c] || (kurs = this.fachartArr[r].gibKleinstenKursInSchiene(c, this.kursGesperrt)) == null) continue;
                data[r][c] = kurs.gibGewichtetesMatchingBewertung();
            }
        }
        @NotNull int[] r2c = this.matrix.gibMinimalesBipartitesMatchingGewichtet(true);
        for (int r = 0; r < this.fachartArr.length; ++r) {
            int c;
            if (this.fachartZuKurs[r] != null || this.fachartArr[r].gibHatMultikurs() || (c = r2c[r]) < 0 || data[r][c] == 1000000L) continue;
            KursblockungDynKurs kursGefunden = this.fachartArr[r].gibKleinstenKursInSchiene(c, this.kursGesperrt);
            if (kursGefunden != null) {
                this.aktionKursHinzufuegen(r, kursGefunden);
                continue;
            }
            throw new DeveloperNotificationException("FEHLER: Kein Kurs in [" + r + "/" + c + "] gefunden!");
        }
    }

    void aktionKurseVerteilenMitBipartiteMatching() {
        @NotNull long @NotNull [][] data = this.matrix.getMatrix();
        for (int r = 0; r < this.fachartArr.length; ++r) {
            int c;
            for (c = 0; c < this.schieneBelegt.length; ++c) {
                data[r][c] = 0L;
            }
            if (this.fachartZuKurs[r] != null || this.fachartArr[r].gibHatMultikurs()) continue;
            for (c = 0; c < this.schieneBelegt.length; ++c) {
                KursblockungDynKurs kurs;
                if (this.schieneBelegt[c] || (kurs = this.fachartArr[r].gibKleinstenKursInSchiene(c, this.kursGesperrt)) == null) continue;
                data[r][c] = 1L;
            }
        }
        @NotNull int[] r2c = this.matrix.gibMaximalesBipartitesMatching(true);
        for (int r = 0; r < this.fachartArr.length; ++r) {
            int c;
            if (this.fachartZuKurs[r] != null || this.fachartArr[r].gibHatMultikurs() || (c = r2c[r]) == -1) continue;
            KursblockungDynKurs kursGefunden = this.fachartArr[r].gibKleinstenKursInSchiene(c, this.kursGesperrt);
            if (kursGefunden != null) {
                this.aktionKursHinzufuegen(r, kursGefunden);
                continue;
            }
            throw new DeveloperNotificationException("FEHLER: Kein Kurs in [" + r + "/" + c + "] gefunden!");
        }
    }

    boolean aktionKurseVerteilenNachDeinemWunsch() {
        long _VAL_UNGUELTIG = 1000000L;
        long _VAL_KURS_GEWAEHLT = 0L;
        long _VAL_KURS_MUSS_WANDERN = 1L;
        @NotNull long @NotNull [][] data = this.matrix.getMatrix();
        for (int r = 0; r < this.fachartArr.length; ++r) {
            int c;
            KursblockungDynFachart fachart = this.fachartArr[r];
            for (c = 0; c < this.schieneBelegt.length; ++c) {
                data[r][c] = 1000000L;
            }
            if (this.fachartZuKurs[r] != null || fachart.gibHatMultikurs()) continue;
            for (c = 0; c < this.schieneBelegt.length; ++c) {
                if (this.schieneBelegt[c]) continue;
                data[r][c] = fachart.gibHatKursInSchiene(c, this.kursGesperrt) ? 0L : (fachart.gibHatKursMitFreierSchiene(c, this.kursGesperrt) ? 1L : 1000000L);
            }
        }
        @NotNull int[] r2c = this.matrix.gibMinimalesBipartitesMatchingGewichtet(true);
        boolean kurslage_veraendert = false;
        for (int r = 0; r < this.fachartArr.length; ++r) {
            int c;
            KursblockungDynFachart fachart = this.fachartArr[r];
            if (this.fachartZuKurs[r] != null || fachart.gibHatMultikurs() || (c = r2c[r]) < 0 || data[r][c] == 1000000L || data[r][c] == 0L) continue;
            fachart.aktionZufaelligerKursWandertNachSchiene(c);
            kurslage_veraendert = true;
        }
        return kurslage_veraendert;
    }

    void aktionKurseVerteilenZufaellig() {
        @NotNull int[] perm = KursblockungStatic.gibPermutation(this._random, this.fachartArr.length);
        block0: for (int pFachart = 0; pFachart < this.fachartArr.length; ++pFachart) {
            int iFachart = perm[pFachart];
            if (this.fachartZuKurs[iFachart] != null) continue;
            KursblockungDynFachart fachart = this.fachartArr[iFachart];
            @NotNull KursblockungDynKurs @NotNull [] kurse = fachart.gibKurse();
            for (int iKurs = 0; iKurs < kurse.length; ++iKurs) {
                KursblockungDynKurs kurs = kurse[iKurs];
                if (this.kursGesperrt[kurs.gibInternalID()]) continue;
                boolean waehlbar = true;
                for (int nr : kurs.gibSchienenLage()) {
                    if (!this.schieneBelegt[nr]) continue;
                    waehlbar = false;
                }
                if (!waehlbar) continue;
                this.aktionKursHinzufuegen(iFachart, kurs);
                continue block0;
            }
        }
    }

    private void aktionKursHinzufuegen(int fachartIndex, @NotNull KursblockungDynKurs kurs) {
        kurs.aktionSchuelerHinzufuegen();
        this.statistik.aktionNichtwahlenVeraendern(-1);
        --this.nichtwahlen;
        for (int nr : kurs.gibSchienenLage()) {
            DeveloperNotificationException.ifTrue("FEHLER: Schienen-Doppelbelegung! " + this.representation, this.schieneBelegt[nr]);
            this.schieneBelegt[nr] = true;
        }
        this.fachartZuKurs[fachartIndex] = kurs;
    }

    private void aktionKursEntfernen(int fachartIndex, @NotNull KursblockungDynKurs kurs) {
        kurs.aktionSchuelerEntfernen();
        this.statistik.aktionNichtwahlenVeraendern(1);
        ++this.nichtwahlen;
        for (int nr : kurs.gibSchienenLage()) {
            DeveloperNotificationException.ifTrue("FEHLER: Kurs ist gar nicht in Schiene ! " + this.representation, !this.schieneBelegt[nr]);
            this.schieneBelegt[nr] = false;
        }
        this.fachartZuKurs[fachartIndex] = null;
    }

    boolean gibIstInKurs(KursblockungDynKurs kurs) {
        for (KursblockungDynKurs zugeordneterKurs : this.fachartZuKurs) {
            if (zugeordneterKurs != kurs) continue;
            return true;
        }
        return false;
    }

    public void debugKurswahlen() {
        this._logger.modifyIndent(4);
        this._logger.logLn("");
        this._logger.logLn(this.representation);
        HashSet<Integer> setSchienenLage = new HashSet<Integer>();
        for (int i = 0; i < this.fachartZuKurs.length; ++i) {
            KursblockungDynKurs kurs = this.fachartZuKurs[i];
            if (kurs == null) continue;
            this._logger.logLn("    " + kurs.toString() + "    " + Arrays.toString(kurs.gibSchienenLage()));
            for (int schiene : kurs.gibSchienenLage()) {
                if (setSchienenLage.add(schiene)) continue;
                this._logger.logLn("Kollision");
                return;
            }
        }
        this._logger.modifyIndent(-4);
    }
}

