/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.kursblockung;

import de.svws_nrw.core.kursblockung.KursblockungDynKurs;
import de.svws_nrw.core.logger.Logger;
import jakarta.validation.constraints.NotNull;
import java.util.Arrays;

public class KursblockungDynStatistik {
    @NotNull
    private final Logger _logger;
    @NotNull
    private @NotNull int @NotNull [][] matrixFachartPaar = new int[0][0];
    @NotNull
    private @NotNull int @NotNull [][] regelVerletzungKursMitKurs = new int[0][0];
    private int bewertungRegelverletzungen;
    private int bewertungRegelverletzungenSaveS;
    private int bewertungRegelverletzungenSaveK;
    private int bewertungRegelverletzungenSaveG;
    private long bewertungFachartPaar;
    private long bewertungFachartPaarSaveK;
    private long bewertungFachartPaarSaveG;
    private int bewertungNichtwahlen;
    private int bewertungNichtwahlenSaveS;
    private int bewertungNichtwahlenSaveK;
    private int bewertungNichtwahlenSaveG;
    @NotNull
    private int[] bewertungKursdifferenzen = new int[0];
    @NotNull
    private int[] bewertungKursdifferenzenSaveS = new int[0];
    @NotNull
    private int[] bewertungKursdifferenzenSaveK = new int[0];
    @NotNull
    private int[] bewertungKursdifferenzenSaveG = new int[0];
    private int bewertungKursdifferenzenMaxIndex;

    KursblockungDynStatistik(@NotNull Logger pLogger) {
        this._logger = pLogger;
        this.clear();
    }

    void clear() {
        this.matrixFachartPaar = new int[0][0];
        this.regelVerletzungKursMitKurs = new int[0][0];
        this.bewertungRegelverletzungen = 0;
        this.bewertungRegelverletzungenSaveS = 0;
        this.bewertungRegelverletzungenSaveK = 0;
        this.bewertungRegelverletzungenSaveG = 0;
        this.bewertungFachartPaar = 0L;
        this.bewertungFachartPaarSaveK = 0L;
        this.bewertungFachartPaarSaveG = 0L;
        this.bewertungNichtwahlen = 0;
        this.bewertungNichtwahlenSaveS = 0;
        this.bewertungNichtwahlenSaveK = 0;
        this.bewertungNichtwahlenSaveG = 0;
        this.bewertungKursdifferenzen = new int[0];
        this.bewertungKursdifferenzenSaveS = new int[0];
        this.bewertungKursdifferenzenSaveK = new int[0];
        this.bewertungKursdifferenzenSaveG = new int[0];
        this.bewertungKursdifferenzenMaxIndex = 0;
    }

    void aktionInitialisiere(@NotNull @NotNull int @NotNull [][] pMatrixFachartPaar, int pMaxSchueler, int pMaxFacharten, int pMaxKurse) {
        this.matrixFachartPaar = pMatrixFachartPaar;
        this.regelVerletzungKursMitKurs = new int[pMaxKurse][pMaxKurse];
        this.bewertungRegelverletzungen = 0;
        this.bewertungRegelverletzungenSaveS = 0;
        this.bewertungRegelverletzungenSaveK = 0;
        this.bewertungRegelverletzungenSaveG = 0;
        this.bewertungKursdifferenzenMaxIndex = 0;
        this.bewertungKursdifferenzen = new int[pMaxSchueler + 1];
        this.bewertungKursdifferenzenSaveS = new int[pMaxSchueler + 1];
        this.bewertungKursdifferenzenSaveK = new int[pMaxSchueler + 1];
        this.bewertungKursdifferenzenSaveG = new int[pMaxSchueler + 1];
        this.bewertungKursdifferenzen[0] = pMaxFacharten;
        this.bewertungKursdifferenzenSaveS[0] = pMaxFacharten;
        this.bewertungKursdifferenzenSaveK[0] = pMaxFacharten;
        this.bewertungKursdifferenzenSaveG[0] = pMaxFacharten;
        this.aktionBewertungSpeichernS();
        this.aktionBewertungSpeichernK();
        this.aktionBewertungSpeichernG();
    }

    void debug(@NotNull String pPrefix) {
        this._logger.modifyIndent(4);
        this._logger.logLn(pPrefix + ", RV = " + this.bewertungRegelverletzungen + ", NW = " + this.bewertungNichtwahlen + ", FW = " + this.bewertungFachartPaar + ", KDs = " + this.bewertungKursdifferenzenMaxIndex + " = " + Arrays.toString(this.bewertungKursdifferenzen));
        this._logger.modifyIndent(-4);
    }

    long gibBewertungFachartPaar() {
        return this.bewertungFachartPaar;
    }

    int gibBewertungNichtwahlen() {
        return this.bewertungNichtwahlen;
    }

    int gibBewertungKursdifferenz() {
        return this.bewertungKursdifferenzenMaxIndex;
    }

    int gibBewertungZustandS_NW_KD() {
        if (this.bewertungRegelverletzungen > this.bewertungRegelverletzungenSaveS) {
            return -1;
        }
        if (this.bewertungRegelverletzungen < this.bewertungRegelverletzungenSaveS) {
            return 1;
        }
        if (this.bewertungNichtwahlen > this.bewertungNichtwahlenSaveS) {
            return -1;
        }
        if (this.bewertungNichtwahlen < this.bewertungNichtwahlenSaveS) {
            return 1;
        }
        for (int i = this.bewertungKursdifferenzen.length - 1; i >= 0; --i) {
            if (this.bewertungKursdifferenzen[i] > this.bewertungKursdifferenzenSaveS[i]) {
                return -1;
            }
            if (this.bewertungKursdifferenzen[i] >= this.bewertungKursdifferenzenSaveS[i]) continue;
            return 1;
        }
        return 0;
    }

    int gibCompareZustandK_NW_KD_FW() {
        if (this.bewertungRegelverletzungen > this.bewertungRegelverletzungenSaveK) {
            return -1;
        }
        if (this.bewertungRegelverletzungen < this.bewertungRegelverletzungenSaveK) {
            return 1;
        }
        if (this.bewertungNichtwahlen > this.bewertungNichtwahlenSaveK) {
            return -1;
        }
        if (this.bewertungNichtwahlen < this.bewertungNichtwahlenSaveK) {
            return 1;
        }
        for (int i = this.bewertungKursdifferenzen.length - 1; i >= 0; --i) {
            if (this.bewertungKursdifferenzen[i] > this.bewertungKursdifferenzenSaveK[i]) {
                return -1;
            }
            if (this.bewertungKursdifferenzen[i] >= this.bewertungKursdifferenzenSaveK[i]) continue;
            return 1;
        }
        if (this.bewertungFachartPaar > this.bewertungFachartPaarSaveK) {
            return -1;
        }
        if (this.bewertungFachartPaar < this.bewertungFachartPaarSaveK) {
            return 1;
        }
        return 0;
    }

    int gibCompareZustandK_FW_NW_KD() {
        if (this.bewertungRegelverletzungen > this.bewertungRegelverletzungenSaveK) {
            return -1;
        }
        if (this.bewertungRegelverletzungen < this.bewertungRegelverletzungenSaveK) {
            return 1;
        }
        if (this.bewertungFachartPaar > this.bewertungFachartPaarSaveK) {
            return -1;
        }
        if (this.bewertungFachartPaar < this.bewertungFachartPaarSaveK) {
            return 1;
        }
        if (this.bewertungNichtwahlen > this.bewertungNichtwahlenSaveK) {
            return -1;
        }
        if (this.bewertungNichtwahlen < this.bewertungNichtwahlenSaveK) {
            return 1;
        }
        for (int i = this.bewertungKursdifferenzen.length - 1; i >= 0; --i) {
            if (this.bewertungKursdifferenzen[i] > this.bewertungKursdifferenzenSaveK[i]) {
                return -1;
            }
            if (this.bewertungKursdifferenzen[i] >= this.bewertungKursdifferenzenSaveK[i]) continue;
            return 1;
        }
        return 0;
    }

    int gibCompareZustandG_NW_KD_FW() {
        if (this.bewertungRegelverletzungen > this.bewertungRegelverletzungenSaveG) {
            return -1;
        }
        if (this.bewertungRegelverletzungen < this.bewertungRegelverletzungenSaveG) {
            return 1;
        }
        if (this.bewertungNichtwahlen > this.bewertungNichtwahlenSaveG) {
            return -1;
        }
        if (this.bewertungNichtwahlen < this.bewertungNichtwahlenSaveG) {
            return 1;
        }
        for (int i = this.bewertungKursdifferenzen.length - 1; i >= 0; --i) {
            if (this.bewertungKursdifferenzen[i] > this.bewertungKursdifferenzenSaveG[i]) {
                return -1;
            }
            if (this.bewertungKursdifferenzen[i] >= this.bewertungKursdifferenzenSaveG[i]) continue;
            return 1;
        }
        if (this.bewertungFachartPaar > this.bewertungFachartPaarSaveG) {
            return -1;
        }
        if (this.bewertungFachartPaar < this.bewertungFachartPaarSaveG) {
            return 1;
        }
        return 0;
    }

    @NotNull
    int[] gibArrayDerKursdifferenzen() {
        return this.bewertungKursdifferenzen;
    }

    void aktionKurspaarInSchieneHinzufuegen(@NotNull KursblockungDynKurs pKurs1, @NotNull KursblockungDynKurs pKurs2) {
        int faNr1 = pKurs1.gibFachart().gibNr();
        int faNr2 = pKurs2.gibFachart().gibNr();
        int kuNr1 = pKurs1.gibInternalID();
        int kuNr2 = pKurs2.gibInternalID();
        this.bewertungFachartPaar += (long)this.matrixFachartPaar[faNr1][faNr2];
        this.bewertungRegelverletzungen += this.regelVerletzungKursMitKurs[kuNr1][kuNr2];
    }

    void aktionKurspaarInSchieneEntfernen(@NotNull KursblockungDynKurs pKurs1, @NotNull KursblockungDynKurs pKurs2) {
        int faNr1 = pKurs1.gibFachart().gibNr();
        int faNr2 = pKurs2.gibFachart().gibNr();
        int kuNr1 = pKurs1.gibInternalID();
        int kuNr2 = pKurs2.gibInternalID();
        this.bewertungFachartPaar -= (long)this.matrixFachartPaar[faNr1][faNr2];
        this.bewertungRegelverletzungen -= this.regelVerletzungKursMitKurs[kuNr1][kuNr2];
    }

    void aktionNichtwahlenVeraendern(int pVeraenderung) {
        this.bewertungNichtwahlen += pVeraenderung;
    }

    void aktionKursdifferenzHinzufuegen(int pIndex) {
        int n = pIndex;
        this.bewertungKursdifferenzen[n] = this.bewertungKursdifferenzen[n] + 1;
        if (pIndex > this.bewertungKursdifferenzenMaxIndex) {
            this.bewertungKursdifferenzenMaxIndex = pIndex;
        }
    }

    void aktionKursdifferenzEntfernen(int pIndex) {
        int n = pIndex;
        this.bewertungKursdifferenzen[n] = this.bewertungKursdifferenzen[n] - 1;
        if (pIndex == this.bewertungKursdifferenzenMaxIndex) {
            while (this.bewertungKursdifferenzen[this.bewertungKursdifferenzenMaxIndex] == 0 && this.bewertungKursdifferenzenMaxIndex > 0) {
                --this.bewertungKursdifferenzenMaxIndex;
            }
        }
    }

    void aktionBewertungSpeichernS() {
        this.bewertungRegelverletzungenSaveS = this.bewertungRegelverletzungen;
        this.bewertungNichtwahlenSaveS = this.bewertungNichtwahlen;
        System.arraycopy(this.bewertungKursdifferenzen, 0, this.bewertungKursdifferenzenSaveS, 0, this.bewertungKursdifferenzen.length);
    }

    void aktionBewertungSpeichernK() {
        this.bewertungRegelverletzungenSaveK = this.bewertungRegelverletzungen;
        this.bewertungNichtwahlenSaveK = this.bewertungNichtwahlen;
        this.bewertungFachartPaarSaveK = this.bewertungFachartPaar;
        System.arraycopy(this.bewertungKursdifferenzen, 0, this.bewertungKursdifferenzenSaveK, 0, this.bewertungKursdifferenzen.length);
    }

    void aktionBewertungSpeichernG() {
        this.bewertungRegelverletzungenSaveG = this.bewertungRegelverletzungen;
        this.bewertungNichtwahlenSaveG = this.bewertungNichtwahlen;
        this.bewertungFachartPaarSaveG = this.bewertungFachartPaar;
        System.arraycopy(this.bewertungKursdifferenzen, 0, this.bewertungKursdifferenzenSaveG, 0, this.bewertungKursdifferenzen.length);
    }

    void regelHinzufuegenKursVerbieteMitKurs(@NotNull KursblockungDynKurs kurs1, @NotNull KursblockungDynKurs kurs2) {
        int nr1 = kurs1.gibInternalID();
        int nr2 = kurs2.gibInternalID();
        int[] nArray = this.regelVerletzungKursMitKurs[nr1];
        int n = nr2;
        nArray[n] = nArray[n] + 1;
        int[] nArray2 = this.regelVerletzungKursMitKurs[nr2];
        int n2 = nr1;
        nArray2[n2] = nArray2[n2] + 1;
    }

    void regelHinzufuegenKursZusammenMitKurs(@NotNull KursblockungDynKurs kurs1, @NotNull KursblockungDynKurs kurs2) {
        int nr1 = kurs1.gibInternalID();
        int nr2 = kurs2.gibInternalID();
        int[] nArray = this.regelVerletzungKursMitKurs[nr1];
        int n = nr2;
        nArray[n] = nArray[n] - 1;
        int[] nArray2 = this.regelVerletzungKursMitKurs[nr2];
        int n2 = nr1;
        nArray2[n2] = nArray2[n2] - 1;
        this.bewertungRegelverletzungen += Math.max(kurs1.gibSchienenAnzahl(), kurs2.gibSchienenAnzahl());
    }
}

