/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.kursblockung;

import jakarta.validation.constraints.NotNull;
import java.util.Arrays;
import java.util.Random;

public class KursblockungMatrix {
    @NotNull
    private final Random _random;
    @NotNull
    private final @NotNull long @NotNull [] @NotNull [] matrix;
    private final int rows;
    private final int cols;
    @NotNull
    private final int[] permR;
    @NotNull
    private final int[] permC;
    @NotNull
    private final int[] r2c;
    @NotNull
    private final int[] c2r;
    @NotNull
    private final boolean[] besuchtR;
    @NotNull
    private final boolean[] abgearbeitetC;
    @NotNull
    private final int[] vorgaengerCzuR;
    @NotNull
    private final int[] queueR;
    @NotNull
    private final long[] potentialR;
    @NotNull
    private final long[] potentialC;
    @NotNull
    private final long[] distanzC;

    public KursblockungMatrix(@NotNull Random pRandom, int rows, int cols) {
        this._random = pRandom;
        this.rows = rows;
        this.cols = cols;
        this.matrix = new long[rows][cols];
        this.permR = new int[rows];
        this.permC = new int[cols];
        this.r2c = new int[rows];
        this.c2r = new int[cols];
        this.besuchtR = new boolean[rows];
        this.abgearbeitetC = new boolean[cols];
        this.vorgaengerCzuR = new int[cols];
        this.queueR = new int[rows];
        this.potentialR = new long[rows];
        this.potentialC = new long[cols];
        this.distanzC = new long[cols];
        KursblockungMatrix.initialisiere(this.permR);
        KursblockungMatrix.initialisiere(this.permC);
    }

    @NotNull
    public int[] gibMaximalesBipartitesMatching(boolean nichtdeterministisch) {
        Arrays.fill(this.r2c, -1);
        Arrays.fill(this.c2r, -1);
        this.initialisierPermRundPermC(nichtdeterministisch);
        for (int pseudoR = 0; pseudoR < this.rows; ++pseudoR) {
            int r = this.permR[pseudoR];
            Arrays.fill(this.besuchtR, false);
            Arrays.fill(this.vorgaengerCzuR, -1);
            int queue_first = 0;
            int queue_last = 0;
            this.queueR[queue_last] = r;
            ++queue_last;
            this.besuchtR[r] = true;
            block1: while (queue_first < queue_last) {
                int vonR = this.queueR[queue_first];
                ++queue_first;
                for (int pseudoC = 0; pseudoC < this.cols; ++pseudoC) {
                    int ueberC = this.permC[pseudoC];
                    if (this.matrix[vonR][ueberC] == 0L || this.r2c[vonR] == ueberC) continue;
                    int zuR = this.c2r[ueberC];
                    if (zuR == -1) {
                        this.vorgaengerCzuR[ueberC] = vonR;
                        int c2 = ueberC;
                        while (c2 >= 0) {
                            int r2 = this.vorgaengerCzuR[c2];
                            int saveC = this.r2c[r2];
                            this.c2r[c2] = r2;
                            this.r2c[r2] = c2;
                            c2 = saveC;
                        }
                        queue_last = queue_first;
                        continue block1;
                    }
                    if (this.besuchtR[zuR]) continue;
                    this.besuchtR[zuR] = true;
                    this.queueR[queue_last] = zuR;
                    ++queue_last;
                    this.vorgaengerCzuR[ueberC] = vonR;
                }
            }
        }
        return this.r2c;
    }

    @NotNull
    public int[] gibMinimalesBipartitesMatchingGewichtet(boolean nichtdeterministisch) {
        long kante;
        int c;
        long min;
        Arrays.fill(this.r2c, -1);
        Arrays.fill(this.c2r, -1);
        Arrays.fill(this.potentialR, 0L);
        Arrays.fill(this.potentialC, 0L);
        this.initialisierPermRundPermC(nichtdeterministisch);
        if (this.rows <= this.cols) {
            int r = 0;
            while (r < this.rows) {
                min = this.matrix[r][0] + this.potentialR[r] - this.potentialC[0];
                for (c = 0; c < this.cols; ++c) {
                    kante = this.matrix[r][c] + this.potentialR[r] - this.potentialC[c];
                    min = Math.min(min, kante);
                }
                int n = r++;
                this.potentialR[n] = this.potentialR[n] - min;
            }
        }
        if (this.cols <= this.rows) {
            int c2 = 0;
            while (c2 < this.cols) {
                min = this.matrix[0][c2] + this.potentialR[0] - this.potentialC[c2];
                for (int r = 0; r < this.rows; ++r) {
                    kante = this.matrix[r][c2] + this.potentialR[r] - this.potentialC[c2];
                    min = Math.min(min, kante);
                }
                int n = c2++;
                this.potentialC[n] = this.potentialC[n] + min;
            }
        }
        int dijkstraRunden = Math.min(this.rows, this.cols);
        Arrays.fill(this.abgearbeitetC, false);
        block4: for (int ir = 0; ir < this.rows; ++ir) {
            int r = this.permR[ir];
            for (int ic = 0; ic < this.cols; ++ic) {
                long kante2;
                int c3 = this.permC[ic];
                if (this.abgearbeitetC[c3] || (kante2 = this.matrix[r][c3] + this.potentialR[r] - this.potentialC[c3]) != 0L) continue;
                this.r2c[r] = c3;
                this.c2r[c3] = r;
                this.abgearbeitetC[c3] = true;
                --dijkstraRunden;
                continue block4;
            }
        }
        for (int dijkstraRunde = 0; dijkstraRunde < dijkstraRunden; ++dijkstraRunde) {
            for (int ic = 0; ic < this.cols; ++ic) {
                c = this.permC[ic];
                this.vorgaengerCzuR[c] = -1;
                this.abgearbeitetC[c] = false;
                this.distanzC[c] = Long.MAX_VALUE;
                for (int ir = 0; ir < this.rows; ++ir) {
                    long kante3;
                    int r = this.permR[ir];
                    if (this.r2c[r] >= 0 || (kante3 = this.matrix[r][c] + this.potentialR[r] - this.potentialC[c]) >= this.distanzC[c]) continue;
                    this.distanzC[c] = kante3;
                    this.vorgaengerCzuR[c] = r;
                }
            }
            int endknotenC = -1;
            for (int dijkstraZyklus = 0; dijkstraZyklus < this.cols; ++dijkstraZyklus) {
                int fromC = 0;
                for (int ic = 0; ic < this.cols; ++ic) {
                    int c4 = this.permC[ic];
                    if (this.abgearbeitetC[c4] || !this.abgearbeitetC[fromC] && this.distanzC[c4] >= this.distanzC[fromC]) continue;
                    fromC = c4;
                }
                this.abgearbeitetC[fromC] = true;
                int overR = this.c2r[fromC];
                if (overR >= 0) {
                    for (int ic = 0; ic < this.cols; ++ic) {
                        int toC = this.permC[ic];
                        long kante4 = this.matrix[overR][toC] + this.potentialR[overR] - this.potentialC[toC];
                        long distance = this.distanzC[fromC] + kante4;
                        if (distance >= this.distanzC[toC]) continue;
                        this.distanzC[toC] = distance;
                        this.vorgaengerCzuR[toC] = overR;
                    }
                    continue;
                }
                if (endknotenC >= 0) continue;
                endknotenC = fromC;
            }
            int currentC = endknotenC;
            while (currentC >= 0) {
                int prevR = this.vorgaengerCzuR[currentC];
                int prevC = this.r2c[prevR];
                this.r2c[prevR] = currentC;
                this.c2r[currentC] = prevR;
                currentC = prevC;
            }
            for (int r = 0; r < this.rows; ++r) {
                int c5 = this.r2c[r];
                if (c5 < 0) continue;
                long kante5 = this.matrix[r][c5] + this.potentialR[r] - this.potentialC[c5];
                int n = r;
                this.potentialR[n] = this.potentialR[n] + (this.distanzC[c5] - kante5);
                int n2 = c5;
                this.potentialC[n2] = this.potentialC[n2] + this.distanzC[c5];
            }
        }
        return this.r2c;
    }

    private void initialisierPermRundPermC(boolean nichtdeterministisch) {
        if (nichtdeterministisch) {
            this.permutiere(this.permR);
            this.permutiere(this.permC);
        } else {
            KursblockungMatrix.initialisiere(this.permR);
            KursblockungMatrix.initialisiere(this.permC);
        }
    }

    private static void initialisiere(@NotNull int[] perm) {
        int laenge = perm.length;
        for (int i = 0; i < laenge; ++i) {
            perm[i] = i;
        }
    }

    private void permutiere(@NotNull int[] perm) {
        int laenge = perm.length;
        for (int i = 0; i < laenge; ++i) {
            int saveJ;
            int j = this._random.nextInt(laenge);
            int saveI = perm[i];
            perm[i] = saveJ = perm[j];
            perm[j] = saveI;
        }
    }

    @NotNull
    public @NotNull long @NotNull [][] getMatrix() {
        return this.matrix;
    }

    @NotNull
    public String convertToString(@NotNull String kommentar, int zellenbreite, boolean mitKnotenPotential) {
        @NotNull StringBuilder sb = new StringBuilder(kommentar + System.lineSeparator());
        for (int r = 0; r < this.rows; ++r) {
            for (int c = 0; c < this.cols; ++c) {
                long wert = mitKnotenPotential ? this.matrix[r][c] + this.potentialR[r] - this.potentialC[c] : this.matrix[r][c];
                @NotNull StringBuilder sWert1 = new StringBuilder();
                @NotNull StringBuilder sWert2 = new StringBuilder("" + wert);
                while (sWert1.length() + sWert2.length() < zellenbreite) {
                    sWert1.append(" ");
                }
                @NotNull String sZusatz = this.r2c[r] == c ? "*" : " ";
                sb.append((CharSequence)sWert1);
                sb.append((CharSequence)sWert2);
                sb.append(sZusatz);
            }
            sb.append("\n");
        }
        sb.append("r2c = " + Arrays.toString(this.r2c));
        sb.append("\n");
        return sb.toString();
    }

    public void fuelleMitZufallszahlenVonBis(int von, int bis) {
        for (int r = 0; r < this.rows; ++r) {
            for (int c = 0; c < this.cols; ++c) {
                this.matrix[r][c] = this._random.nextLong((long)(bis - von) + 1L) + (long)von;
            }
        }
    }

    public int gibZeilen() {
        return this.rows;
    }

    public int gibSpalten() {
        return this.cols;
    }
}

