/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.kursblockung;

import de.svws_nrw.core.data.gost.GostFachwahl;
import de.svws_nrw.core.data.kursblockung.SchuelerblockungInput;
import de.svws_nrw.core.data.kursblockung.SchuelerblockungInputKurs;
import de.svws_nrw.core.data.kursblockung.SchuelerblockungOutput;
import de.svws_nrw.core.data.kursblockung.SchuelerblockungOutputFachwahlZuKurs;
import de.svws_nrw.core.exceptions.DeveloperNotificationException;
import de.svws_nrw.core.kursblockung.KursblockungMatrix;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Random;

public class SchuelerblockungDynDaten {
    private static final int UNENDLICH = 1000000;
    @NotNull
    private final Random _random;
    private final int nFachwahlen;
    private final int nSchienen;
    @NotNull
    private final @NotNull ArrayList<@NotNull ArrayList<@NotNull SchuelerblockungInputKurs>> _fachwahlZuKurse;
    @NotNull
    private final boolean[] _fachwahlZuHatMultikurse;
    @NotNull
    private final long[] _fachwahlZuFachID;
    @NotNull
    private final int[] _fachwahlZuKursartID;
    @NotNull
    private final KursblockungMatrix _aktuellMatrix;
    @NotNull
    private final boolean[] _aktuellGesperrteSchiene;
    @NotNull
    private final long[] _aktuellFachwahlZuKurs;
    @NotNull
    private final long[] _aktuellFachwahlZuKursBest;
    private int _aktuellNichtwahlen;
    private int _aktuellNichtwahlenBest;
    private long _aktuellBewertung;
    private long _aktuellBewertungBest;

    public SchuelerblockungDynDaten(@NotNull Random pRandom, @NotNull SchuelerblockungInput pInput) {
        this._random = pRandom;
        this.aktionPruefeEingabedaten(pInput);
        this.nFachwahlen = pInput.fachwahlen.size();
        this.nSchienen = pInput.schienen;
        this._fachwahlZuKurse = new ArrayList();
        this._fachwahlZuHatMultikurse = new boolean[this.nFachwahlen];
        this._fachwahlZuFachID = new long[this.nFachwahlen];
        this._fachwahlZuKursartID = new int[this.nFachwahlen];
        this.aktionInitialisiereDatenstrukturen(pInput);
        this._aktuellMatrix = new KursblockungMatrix(pRandom, this.nFachwahlen, this.nSchienen);
        this._aktuellGesperrteSchiene = new boolean[this.nSchienen];
        this._aktuellFachwahlZuKurs = new long[this.nFachwahlen];
        this._aktuellFachwahlZuKursBest = new long[this.nFachwahlen];
        this._aktuellBewertung = 0L;
        this._aktuellBewertungBest = 0L;
    }

    void aktionPruefeEingabedaten(@NotNull SchuelerblockungInput pInput) {
        if (pInput == null) {
            throw new DeveloperNotificationException("pInput == NULL");
        }
        if (pInput.fachwahlen == null) {
            throw new DeveloperNotificationException("pInput.fachwahlen == NULL");
        }
        if (pInput.kurse == null) {
            throw new DeveloperNotificationException("pInput.kurse == NULL");
        }
        int tmpNFachwahlen = pInput.fachwahlen.size();
        DeveloperNotificationException.ifTrue("Der Sch\u00fcler hat zu wenig Fachwahlen (" + tmpNFachwahlen + "), ein Blocken sollte gar nicht angeboten werden!", tmpNFachwahlen < 1);
        int tmpNSchienen = pInput.schienen;
        DeveloperNotificationException.ifTrue("Die Schienenanzahl (" + tmpNSchienen + ") ist zu gering!", tmpNSchienen < 1);
        int nKurse = pInput.kurse.size();
        DeveloperNotificationException.ifTrue("Die Kursanzahl (" + nKurse + ") ist zu gering!", nKurse < 1);
        HashSet setKursID = new HashSet();
        for (SchuelerblockungInputKurs kurs : pInput.kurse) {
            DeveloperNotificationException.ifInvalidID("kurs.id", kurs.id);
            DeveloperNotificationException.ifSetAddsDuplicate("setKursID", setKursID, kurs.id);
            DeveloperNotificationException.ifInvalidID("kurs.fach", kurs.fach);
            DeveloperNotificationException.ifTrue("kurs.kursart (" + kurs.kursart + ") ist zu gering!", kurs.kursart < 0);
            DeveloperNotificationException.ifTrue("kurs.anzahlSuS (" + kurs.anzahlSuS + ") ist zu gering!", kurs.anzahlSuS < 0);
            DeveloperNotificationException.ifTrue("kurs.schienen == (" + String.valueOf(kurs.schienen) + ") ist nicht definiert!", kurs.schienen == null);
            DeveloperNotificationException.ifTrue("kurs.schienen.length (" + kurs.schienen.length + ") ist zu gering!", kurs.schienen.length <= 0);
            DeveloperNotificationException.ifTrue("kurs.schienen.length (" + kurs.schienen.length + ") ist zu gro\u00df!", kurs.schienen.length > tmpNSchienen);
            for (int schiene1 : kurs.schienen) {
                DeveloperNotificationException.ifTrue("Kurs " + kurs.id + " ist in zu kleiner Schiene (" + schiene1 + ")!", schiene1 < 1);
                DeveloperNotificationException.ifTrue("Kurs " + kurs.id + " ist in zu gro\u00dfer Schiene (" + schiene1 + ")!", schiene1 > tmpNSchienen);
            }
            DeveloperNotificationException.ifTrue("Kurs " + kurs.id + " ist fixiert und gesperrt, das sollte nicht m\u00f6glich sein!", kurs.istFixiert && kurs.istGesperrt);
        }
        for (GostFachwahl fachwahl : pInput.fachwahlen) {
            DeveloperNotificationException.ifInvalidID("fachwahl.schuelerID", fachwahl.schuelerID);
            DeveloperNotificationException.ifInvalidID("fachwahl.fachID", fachwahl.fachID);
            DeveloperNotificationException.ifInvalidID("fachwahl.kursartID", fachwahl.kursartID);
        }
        for (int iFachwahl = 0; iFachwahl < tmpNFachwahlen; ++iFachwahl) {
            DeveloperNotificationException.ifTrue("pInput.fachwahlenText: Es fehlt der Text zur Fachwahl (" + iFachwahl + ")!", iFachwahl >= pInput.fachwahlenText.size());
            @NotNull String representation = pInput.fachwahlenText.get(iFachwahl);
            @NotNull GostFachwahl fachwahl = pInput.fachwahlen.get(iFachwahl);
            boolean kursWurdeFixiert = false;
            for (SchuelerblockungInputKurs kurs : pInput.kurse) {
                if (fachwahl.fachID != kurs.fach || fachwahl.kursartID != kurs.kursart || kurs.istGesperrt || !kurs.istFixiert) continue;
                DeveloperNotificationException.ifTrue("Die Fachart/Fachwahl (" + representation + ") hat mehr als eine Fixierung!", kursWurdeFixiert);
                kursWurdeFixiert = true;
            }
        }
        for (SchuelerblockungInputKurs kurs : pInput.kurse) {
            int gefunden = 0;
            for (int r = 0; r < tmpNFachwahlen; ++r) {
                @NotNull GostFachwahl fachwahl = pInput.fachwahlen.get(r);
                if (fachwahl.fachID != kurs.fach || fachwahl.kursartID != kurs.kursart) continue;
                ++gefunden;
            }
            DeveloperNotificationException.ifTrue("Der Kurs (" + kurs.id + ") konnte keiner Fachart/Fachwahl zugeordnet werden!", gefunden == 0);
        }
    }

    private void aktionInitialisiereDatenstrukturen(@NotNull SchuelerblockungInput pInput) {
        for (int iFachwahl = 0; iFachwahl < this.nFachwahlen; ++iFachwahl) {
            @NotNull GostFachwahl fachwahl = pInput.fachwahlen.get(iFachwahl);
            this._fachwahlZuFachID[iFachwahl] = fachwahl.fachID;
            this._fachwahlZuKursartID[iFachwahl] = fachwahl.kursartID;
            ArrayList<@NotNull SchuelerblockungInputKurs> kurse = new ArrayList<SchuelerblockungInputKurs>();
            boolean hatFixiertenKurs = false;
            for (SchuelerblockungInputKurs kurs : pInput.kurse) {
                if (fachwahl.fachID != kurs.fach || fachwahl.kursartID != kurs.kursart || kurs.istGesperrt || hatFixiertenKurs) continue;
                if (kurs.istFixiert) {
                    hatFixiertenKurs = true;
                    kurse.clear();
                }
                kurse.add(kurs);
            }
            this._fachwahlZuKurse.add(kurse);
            int max = 1;
            for (SchuelerblockungInputKurs kurs : kurse) {
                max = Math.max(max, kurs.schienen.length);
            }
            this._fachwahlZuHatMultikurse[iFachwahl] = max >= 2;
        }
    }

    @NotNull
    SchuelerblockungOutput gibBestesMatching() {
        this._aktuellNichtwahlen = 0;
        this._aktuellBewertung = 0L;
        this._aktuellNichtwahlenBest = 1000000;
        this._aktuellBewertungBest = 1000000L;
        Arrays.fill(this._aktuellFachwahlZuKurs, -1L);
        Arrays.fill(this._aktuellFachwahlZuKursBest, -1L);
        Arrays.fill(this._aktuellGesperrteSchiene, false);
        this.aktionVerteileMultikurseRekursiv(0);
        @NotNull SchuelerblockungOutput out = new SchuelerblockungOutput();
        for (int iFachwahl = 0; iFachwahl < this.nFachwahlen; ++iFachwahl) {
            @NotNull SchuelerblockungOutputFachwahlZuKurs wahl = new SchuelerblockungOutputFachwahlZuKurs();
            wahl.fachID = this._fachwahlZuFachID[iFachwahl];
            wahl.kursartID = this._fachwahlZuKursartID[iFachwahl];
            wahl.kursID = this._aktuellFachwahlZuKursBest[iFachwahl];
            out.fachwahlenZuKurs.add(wahl);
        }
        return out;
    }

    private void aktionVerteileMultikurseRekursiv(int iFachwahl) {
        if (iFachwahl >= this.nFachwahlen) {
            this.aktionVerteileMitMatching();
            return;
        }
        if (!this._fachwahlZuHatMultikurse[iFachwahl]) {
            this.aktionVerteileMultikurseRekursiv(iFachwahl + 1);
            return;
        }
        int schienenAnzahl = 2;
        for (SchuelerblockungInputKurs kurs : this._fachwahlZuKurse.get(iFachwahl)) {
            schienenAnzahl = Math.max(schienenAnzahl, kurs.schienen.length);
            if (!this.aktionBelegeKurs(iFachwahl, kurs)) continue;
            this.aktionVerteileMultikurseRekursiv(iFachwahl + 1);
            if (this.aktionBelegeKursUndo(iFachwahl, kurs)) continue;
            throw new DeveloperNotificationException("In der Methode 'SchuelerblockungDynDaten.aktionVerteileMultikurseRekursiv' ist ein unerwarteter Fehler passiert: Der Kurs (" + kurs.id + ") konnte vom Algorithmus nicht entfernt werden! Diesen Fehler kann nur das Programmier-Team beheben.");
        }
        this._aktuellNichtwahlen += schienenAnzahl;
        if (this._aktuellNichtwahlen <= this._aktuellNichtwahlenBest) {
            this.aktionVerteileMultikurseRekursiv(iFachwahl + 1);
        }
        this._aktuellNichtwahlen -= schienenAnzahl;
    }

    private void aktionVerteileMitMatching() {
        SchuelerblockungInputKurs kurs;
        int iFachwahl;
        int iFachwahl2;
        @NotNull long @NotNull [][] data = this._aktuellMatrix.getMatrix();
        for (iFachwahl2 = 0; iFachwahl2 < this.nFachwahlen; ++iFachwahl2) {
            for (int iSchiene = 0; iSchiene < this.nSchienen; ++iSchiene) {
                data[iFachwahl2][iSchiene] = 1000000L;
            }
        }
        for (iFachwahl2 = 0; iFachwahl2 < this.nFachwahlen; ++iFachwahl2) {
            if (this._fachwahlZuHatMultikurse[iFachwahl2]) continue;
            for (int schiene = 0; schiene < this.nSchienen; ++schiene) {
                SchuelerblockungInputKurs kurs2;
                if (this._aktuellGesperrteSchiene[schiene] || (kurs2 = SchuelerblockungDynDaten.gibKleinstenKursInSchiene(this._fachwahlZuKurse.get(iFachwahl2), schiene)) == null) continue;
                data[iFachwahl2][schiene] = (long)kurs2.anzahlSuS * (long)kurs2.anzahlSuS;
            }
        }
        @NotNull int[] r2c = this._aktuellMatrix.gibMinimalesBipartitesMatchingGewichtet(true);
        for (iFachwahl = 0; iFachwahl < this.nFachwahlen; ++iFachwahl) {
            if (this._fachwahlZuHatMultikurse[iFachwahl]) continue;
            int schiene = r2c[iFachwahl];
            if (schiene < 0 || data[iFachwahl][schiene] == 1000000L) {
                ++this._aktuellNichtwahlen;
                continue;
            }
            kurs = SchuelerblockungDynDaten.gibKleinstenKursInSchiene(this._fachwahlZuKurse.get(iFachwahl), schiene);
            if (kurs == null) {
                throw new DeveloperNotificationException("In der Methode 'SchuelerblockungDynDaten.aktionVerteileMitMatching' ist ein unerwarteter Fehler passiert: Der Fachart (" + iFachwahl + ") wurde ein NULL-Kurs zugeordnet! Diesen Fehler kann nur das Programmier-Team beheben.");
            }
            if (this.aktionBelegeKurs(iFachwahl, kurs)) continue;
            throw new DeveloperNotificationException("In der Methode 'SchuelerblockungDynDaten.aktionVerteileMitMatching' ist ein unerwarteter Fehler passiert: Der Kurs (" + kurs.id + ") konnte nicht belegt werden! Diesen Fehler kann nur das Programmier-Team beheben.");
        }
        if (this._aktuellNichtwahlen < this._aktuellNichtwahlenBest || this._aktuellNichtwahlen == this._aktuellNichtwahlenBest && this._aktuellBewertung < this._aktuellBewertungBest) {
            this._aktuellNichtwahlenBest = this._aktuellNichtwahlen;
            this._aktuellBewertungBest = this._aktuellBewertung;
            System.arraycopy(this._aktuellFachwahlZuKurs, 0, this._aktuellFachwahlZuKursBest, 0, this.nFachwahlen);
        }
        for (iFachwahl = 0; iFachwahl < this.nFachwahlen; ++iFachwahl) {
            if (this._fachwahlZuHatMultikurse[iFachwahl]) continue;
            int schiene = r2c[iFachwahl];
            if (schiene < 0 || data[iFachwahl][schiene] == 1000000L) {
                --this._aktuellNichtwahlen;
                continue;
            }
            kurs = SchuelerblockungDynDaten.gibKleinstenKursInSchiene(this._fachwahlZuKurse.get(iFachwahl), schiene);
            if (kurs == null) {
                throw new DeveloperNotificationException("In der Methode 'SchuelerblockungDynDaten.aktionVerteileMitMatching' ist ein unerwarteter Fehler passiert: Der Fachart (" + iFachwahl + ") wurde ein NULL-Kurs zugeordnet! Diesen Fehler kann nur das Programmier-Team beheben.");
            }
            if (this.aktionBelegeKursUndo(iFachwahl, kurs)) continue;
            throw new DeveloperNotificationException("In der Methode 'SchuelerblockungDynDaten.aktionVerteileMitMatching' ist ein unerwarteter Fehler passiert: Der Kurs (" + kurs.id + ") konnte nicht entfernt werden! Diesen Fehler kann nur das Programmier-Team beheben.");
        }
    }

    private static SchuelerblockungInputKurs gibKleinstenKursInSchiene(@NotNull @NotNull ArrayList<@NotNull SchuelerblockungInputKurs> pKurse, int pSchiene) {
        long maxSuS = Integer.MAX_VALUE;
        SchuelerblockungInputKurs best = null;
        for (SchuelerblockungInputKurs kurs : pKurse) {
            if (kurs.schienen[0] - 1 != pSchiene || (long)kurs.anzahlSuS >= Integer.MAX_VALUE) continue;
            best = kurs;
        }
        return best;
    }

    private boolean aktionBelegeKurs(int iFachwahl, @NotNull SchuelerblockungInputKurs kurs) {
        for (int schiene1 : kurs.schienen) {
            if (!this._aktuellGesperrteSchiene[schiene1 - 1]) continue;
            return false;
        }
        this._aktuellFachwahlZuKurs[iFachwahl] = kurs.id;
        for (int schiene1 : kurs.schienen) {
            this._aktuellGesperrteSchiene[schiene1 - 1] = true;
        }
        this._aktuellBewertung += (long)(kurs.anzahlSuS * kurs.anzahlSuS);
        return true;
    }

    private boolean aktionBelegeKursUndo(int iFachwahl, @NotNull SchuelerblockungInputKurs kurs) {
        if (this._aktuellFachwahlZuKurs[iFachwahl] < 0L) {
            return false;
        }
        for (int schiene1 : kurs.schienen) {
            if (this._aktuellGesperrteSchiene[schiene1 - 1]) continue;
            return false;
        }
        this._aktuellFachwahlZuKurs[iFachwahl] = -1L;
        for (int schiene1 : kurs.schienen) {
            this._aktuellGesperrteSchiene[schiene1 - 1] = false;
        }
        this._aktuellBewertung -= (long)(kurs.anzahlSuS * kurs.anzahlSuS);
        return true;
    }

    private void debug(@NotNull String pHeader, boolean pPrintMatrix) {
        System.out.println();
        System.out.println("#################### " + pHeader + " ####################");
        System.out.println("Bewertung      = " + this._aktuellNichtwahlen + " / " + this._aktuellBewertung);
        System.out.println("Fachwahlen     = " + Arrays.toString(this._aktuellFachwahlZuKurs));
        System.out.println("BewertungBest  = " + this._aktuellNichtwahlenBest + " / " + this._aktuellBewertungBest);
        System.out.println("FachwahlenBest = " + Arrays.toString(this._aktuellFachwahlZuKursBest));
        if (!pPrintMatrix) {
            return;
        }
        @NotNull long @NotNull [][] data = this._aktuellMatrix.getMatrix();
        for (int schiene = 0; schiene < this.nSchienen; ++schiene) {
            String sData = this._aktuellGesperrteSchiene[schiene] ? "1" : "0";
            System.out.print(String.format("%5s", sData));
        }
        System.out.println();
        for (int iFachwahl = 0; iFachwahl < this.nFachwahlen; ++iFachwahl) {
            for (int schiene = 0; schiene < this.nSchienen; ++schiene) {
                @NotNull Object sData = "" + data[iFachwahl][schiene];
                if (data[iFachwahl][schiene] == 1000000L) {
                    sData = "INF";
                }
                System.out.print(String.format("%5s", sData));
            }
            System.out.println();
        }
    }
}

