/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.logger;

import de.svws_nrw.core.logger.LogData;
import jakarta.validation.constraints.NotNull;
import java.util.function.Consumer;

public class LogConsumerConsole
implements Consumer<LogData> {
    public final boolean printTime;
    public final boolean printLevel;

    public LogConsumerConsole() {
        this.printTime = false;
        this.printLevel = false;
    }

    public LogConsumerConsole(boolean printTime, boolean printLevel) {
        this.printTime = printTime;
        this.printLevel = printLevel;
    }

    @Override
    public void accept(@NotNull LogData t) {
        if (t == null) {
            return;
        }
        String s = (String)(this.printTime ? t.getTime() + " " : "") + (String)(this.printLevel ? String.valueOf((Object)t.getLevel()) + " " : "") + t.getText();
        if (t.isNewLine()) {
            System.out.println(s);
        } else {
            System.out.print(s);
        }
        System.out.flush();
    }
}

