/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.logger;

import de.svws_nrw.core.logger.LogData;
import de.svws_nrw.core.logger.LogLevel;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

public class LogConsumerList
implements Consumer<LogData> {
    public final boolean printTime;
    public final boolean printLevel;
    @NotNull
    private final @NotNull ArrayList<@NotNull LogData> logData = new ArrayList();

    public LogConsumerList() {
        this.printTime = false;
        this.printLevel = false;
    }

    public LogConsumerList(boolean printTime, boolean printLevel) {
        this.printTime = printTime;
        this.printLevel = printLevel;
    }

    public void append(@NotNull LogConsumerList log) {
        this.logData.addAll(log.logData);
    }

    @Override
    public void accept(LogData t) {
        if (t == null) {
            return;
        }
        this.logData.add(t);
    }

    @NotNull
    public @NotNull List<@NotNull LogData> getLogData() {
        return this.logData;
    }

    public List<@NotNull String> getStrings() {
        return this.getStrings("");
    }

    public List<@NotNull String> getStrings(@NotNull String indent) {
        ArrayList<@NotNull String> result = new ArrayList<String>();
        @NotNull Object temp = indent;
        for (int i = 0; i < this.logData.size(); ++i) {
            @NotNull LogData data = this.logData.get(i);
            if (data == null) continue;
            temp = (String)temp + data.getText();
            if (!data.isNewLine()) continue;
            result.add((String)temp);
            temp = indent;
        }
        if (!indent.equals(temp)) {
            result.add((String)temp);
        }
        return result;
    }

    @NotNull
    public String getText() {
        return this.getText(LogLevel.INFO, "");
    }

    @NotNull
    public String getText(@NotNull LogLevel level) {
        return this.getText(level, "");
    }

    @NotNull
    public String getText(@NotNull LogLevel level, @NotNull String indent) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.logData.size(); ++i) {
            LogData data = this.logData.get(i);
            if (data == null || data.getLevel().toInteger() > level.toInteger()) continue;
            sb.append(indent);
            sb.append(data.getText());
            sb.append("\n");
        }
        return sb.toString();
    }
}

