/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.logger;

import de.svws_nrw.core.logger.LogLevel;
import jakarta.validation.constraints.NotNull;
import java.util.Arrays;

public final class LogData
implements Comparable<LogData> {
    private final long time = System.currentTimeMillis();
    @NotNull
    private final LogLevel level;
    @NotNull
    private final String text;
    private final boolean newLine;
    private int indent;

    public LogData(@NotNull LogLevel level, int indent, boolean newLine, @NotNull String text) {
        this.level = level;
        this.indent = indent < 0 ? 0 : indent;
        this.newLine = newLine;
        this.text = text == null ? "" : text;
    }

    @Override
    public int compareTo(@NotNull LogData other) {
        if (this.time < other.time) {
            return -1;
        }
        if (this.time > other.time) {
            return 1;
        }
        return 0;
    }

    @NotNull
    public String toString() {
        return "{ \"time\":" + this.time + ", \"level\":" + this.level.toInteger() + ", \"text\":\"" + this.getText() + "\"}";
    }

    public void addIndent(int indent) {
        this.indent += indent;
    }

    public long getTime() {
        return this.time;
    }

    @NotNull
    public LogLevel getLevel() {
        return this.level;
    }

    public boolean isNewLine() {
        return this.newLine;
    }

    @NotNull
    public String getText() {
        if (this.indent <= 0) {
            return this.text;
        }
        char[] indentChars = new char[this.indent];
        Arrays.fill(indentChars, ' ');
        return new String(indentChars) + this.text;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof LogData) {
            return this.compareTo((LogData)obj) == 0;
        }
        return super.equals(obj);
    }
}

