/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.logger;

import de.svws_nrw.core.logger.LogData;
import de.svws_nrw.core.logger.LogLevel;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.function.Consumer;

public class Logger {
    @NotNull
    private final @NotNull ArrayList<@NotNull Consumer<@NotNull LogData>> consumer = new ArrayList();
    @NotNull
    private LogLevel defaultLevel = LogLevel.INFO;
    private int indent = 0;

    public void addConsumer(@NotNull @NotNull Consumer<@NotNull LogData> c) {
        this.consumer.add(c);
    }

    public void copyConsumer(@NotNull Logger other) {
        this.consumer.addAll(other.consumer);
    }

    public void removeConsumer(@NotNull @NotNull Consumer<@NotNull LogData> c) {
        this.consumer.remove(c);
    }

    @NotNull
    public LogLevel getDefaultLevel() {
        return this.defaultLevel;
    }

    public void setDefaultLevel(@NotNull LogLevel defaultLevel) {
        this.defaultLevel = defaultLevel;
    }

    public void setIndent(int indent) {
        this.indent = indent < 0 ? 0 : indent;
    }

    public void modifyIndent(int indent) {
        this.indent = this.indent + indent < 0 ? 0 : this.indent + indent;
    }

    private void log(@NotNull LogData data) {
        for (int i = 0; i < this.consumer.size(); ++i) {
            @NotNull Consumer<@NotNull LogData> c = this.consumer.get(i);
            if (c == null) continue;
            c.accept(data);
        }
    }

    public void log(@NotNull LogLevel level, int indent, @NotNull String text) {
        this.log(new LogData(level, indent, false, text));
    }

    public void logLn(@NotNull LogLevel level, int indent, @NotNull String text) {
        this.log(new LogData(level, indent, true, text));
    }

    public void log(@NotNull LogLevel level, @NotNull String text) {
        this.log(level, this.indent, text);
    }

    public void logLn(@NotNull LogLevel level, @NotNull String text) {
        this.logLn(level, this.indent, text);
    }

    public void log(int indent, @NotNull String text) {
        this.log(this.defaultLevel, indent, text);
    }

    public void logLn(int indent, @NotNull String text) {
        this.logLn(this.defaultLevel, indent, text);
    }

    public void log(@NotNull String text) {
        this.log(this.defaultLevel, text);
    }

    public void logLn(@NotNull String text) {
        this.logLn(this.defaultLevel, text);
    }
}

