/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.types;

import jakarta.validation.constraints.NotNull;

public enum Geschlecht {
    M(3, "m", "m\u00e4nnlich", "m\u00e4nnlich"),
    W(4, "w", "weiblich", "weiblich"),
    D(5, "d", "divers", "divers"),
    X(6, "x", "ohne Angabe", "ohne Angabe im Geburtenregister");

    public final int id;
    @NotNull
    public final String kuerzel;
    @NotNull
    public final String text;
    @NotNull
    public final String textLang;

    private Geschlecht(@NotNull int id, @NotNull String kuerzel, String text, String textLang) {
        this.id = id;
        this.kuerzel = kuerzel;
        this.text = text;
        this.textLang = textLang;
    }

    public static Geschlecht fromValue(Integer value) {
        if (value == null) {
            return null;
        }
        switch (value) {
            case 3: {
                return M;
            }
            case 4: {
                return W;
            }
            case 5: {
                return D;
            }
            case 6: {
                return X;
            }
        }
        return null;
    }

    @NotNull
    public static Geschlecht fromStringValue(String text) {
        String upperValue;
        if (text == null || "".equals(text)) {
            return X;
        }
        switch (upperValue = text.toUpperCase()) {
            case "M\u00c4NNLICH": 
            case "MAENNLICH": 
            case "M": {
                return M;
            }
            case "WEIBLICH": 
            case "W": {
                return W;
            }
            case "DIVERS": 
            case "D": {
                return D;
            }
            case "-": 
            case "X": 
            case "OHNE ANGABE": 
            case "OHNE_ANGABE": 
            case "OHNE ANGABE IM GEBURTENREGISTER": {
                return X;
            }
        }
        return X;
    }

    public String getAnrede(int alter) {
        switch (this.id) {
            case 3: {
                return alter < 18 ? "Lieber" : "Sehr geehrter Herr";
            }
            case 4: {
                return alter < 18 ? "Liebe" : "Sehr geehrte Frau";
            }
            case 5: {
                return "Guten Tag";
            }
            case 6: {
                return "Guten Tag";
            }
        }
        return "Guten Tag";
    }

    @NotNull
    public String toString() {
        return this.kuerzel;
    }
}

