/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.types;

import jakarta.validation.constraints.NotNull;

public enum KursFortschreibungsart {
    KEINE(0, "N", "Keine", null, null),
    NUR_DEFINITION_JAHRGANG_HOCHSCHREIBEN(1, "D", "Nur Definition, Jahrgang hochschreiben", null, null),
    NUR_DEFINITION_JAHRGANG_BEIBEHALTEN(2, "B", "Nur Definition, Jahrgang beibehalten", null, null),
    KOMPLETT(3, "K", "Komplett", null, null);

    public static final long VERSION = 1L;
    public final int id;
    @NotNull
    public final String kuerzel;
    @NotNull
    public final String beschreibung;
    public final Integer gueltigVon;
    public final Integer gueltigBis;

    private KursFortschreibungsart(@NotNull int id, String kuerzel, String beschreibung, Integer gueltigVon, Integer gueltigBis) {
        this.id = id;
        this.kuerzel = kuerzel;
        this.beschreibung = beschreibung;
        this.gueltigVon = gueltigVon;
        this.gueltigBis = gueltigBis;
    }

    public static KursFortschreibungsart fromID(Integer id) {
        if (id == null) {
            return KEINE;
        }
        switch (id) {
            case 0: {
                return KEINE;
            }
            case 1: {
                return NUR_DEFINITION_JAHRGANG_HOCHSCHREIBEN;
            }
            case 2: {
                return NUR_DEFINITION_JAHRGANG_BEIBEHALTEN;
            }
            case 3: {
                return KOMPLETT;
            }
        }
        return KEINE;
    }

    public static KursFortschreibungsart fromKuerzel(String kuerzel) {
        if (kuerzel == null) {
            return KEINE;
        }
        switch (kuerzel) {
            case "N": {
                return KEINE;
            }
            case "D": {
                return NUR_DEFINITION_JAHRGANG_HOCHSCHREIBEN;
            }
            case "B": {
                return NUR_DEFINITION_JAHRGANG_BEIBEHALTEN;
            }
            case "K": {
                return KOMPLETT;
            }
        }
        return KEINE;
    }

    public static boolean isValidKuerzel(String kuerzel) {
        for (KursFortschreibungsart art : KursFortschreibungsart.values()) {
            if (!art.kuerzel.equals(kuerzel)) continue;
            return true;
        }
        return false;
    }
}

