/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.types;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.svws_nrw.core.data.schule.NotenKatalogEintrag;
import jakarta.validation.constraints.NotNull;

public enum Note {
    KEINE(-1, -1, null, "", "", "--------------------", null, null),
    UNGENUEGEND(0, 600, 0, "6", "ungenuegend", "ungenuegend", null, null),
    MANGELHAFT_MINUS(1, 501, 1, "5-", "mangelhaft (minus)", "mangelhaft", null, null),
    MANGELHAFT(2, 500, 2, "5", "mangelhaft", "mangelhaft", null, null),
    MANGELHAFT_PLUS(3, 499, 3, "5+", "mangelhaft (plus)", "mangelhaft", null, null),
    AUSREICHEND_MINUS(4, 401, 4, "4-", "ausreichend (minus)", "ausreichend", null, null),
    AUSREICHEND(5, 400, 5, "4", "ausreichend", "ausreichend", null, null),
    AUSREICHEND_PLUS(6, 399, 6, "4+", "ausreichend (plus)", "ausreichend", null, null),
    BEFRIEDIGEND_MINUS(7, 301, 7, "3-", "befriedigend (minus)", "befriedigend", null, null),
    BEFRIEDIGEND(8, 300, 8, "3", "befriedigend", "befriedigend", null, null),
    BEFRIEDIGEND_PLUS(9, 299, 9, "3+", "befriedigend (plus)", "befriedigend", null, null),
    GUT_MINUS(10, 201, 10, "2-", "gut (minus)", "gut", null, null),
    GUT(11, 200, 11, "2", "gut", "gut", null, null),
    GUT_PLUS(12, 199, 12, "2+", "gut (plus)", "gut", null, null),
    SEHR_GUT_MINUS(13, 101, 13, "1-", "sehr gut (minus)", "sehr gut", null, null),
    SEHR_GUT(14, 100, 14, "1", "sehr gut", "sehr gut", null, null),
    SEHR_GUT_PLUS(15, 99, 15, "1+", "sehr gut (plus)", "sehr gut", null, null),
    ATTEST(16, 2500, null, "AT", "(\u00e4rtzliches Attest)", "--------------------", null, null),
    E1_MIT_BESONDEREM_ERFOLG_TEILGENOMMEN(17, 1000, null, "E1", "mit besonderem Erfolg teilgenommen", "mit besonderem Erfolg teilgenommen", null, null),
    E2_MIT_ERFOLG_TEILGENOMMEN(18, 1001, null, "E2", "mit Erfolg teilgenommen", "mit Erfolg teilgenommen", null, null),
    E3_TEILGENOMMEN(19, 1002, null, "E3", "teilgenommen", "teilgenommen", null, null),
    NICHT_TEILGENOMMEN(20, 4010, null, "NT", "(nicht teilgenommen)", "--------------------", null, null),
    NICHT_BEURTEILT(21, 4000, null, "NB", "(kann nicht beurteilt werden)", "--------------------", null, null),
    NICHT_ERTEILT(22, 4020, null, "NE", "(nicht erteilt)", "--------------------", null, null),
    LEHRERMANGEL(23, 9000, null, "LM", "(kein Unterricht wegen Lehrermangels)", "--------------------", null, null),
    ABGEMELDET(24, 2000, null, "AM", "(abgemeldet)", "--------------------", null, null);

    public static final long VERSION = 1L;
    public final int id;
    public final int sortierung;
    public final Integer notenpunkte;
    @NotNull
    public final String kuerzel;
    @NotNull
    public final String text;
    @NotNull
    public final String textZeugnis;
    public final Integer gueltigVon;
    public final Integer gueltigBis;
    private NotenKatalogEintrag katalogEintrag = null;

    private Note(int id, @NotNull int sortierung, @NotNull Integer notenpunkte, @NotNull String kuerzel, String text, String textZeugnis, Integer gueltigVon, Integer gueltigBis) {
        this.id = id;
        this.sortierung = sortierung;
        this.notenpunkte = notenpunkte;
        this.kuerzel = kuerzel;
        this.text = text;
        this.textZeugnis = textZeugnis;
        this.gueltigVon = gueltigVon;
        this.gueltigBis = gueltigBis;
    }

    @JsonIgnore
    public boolean istNote() {
        return this.notenpunkte != null;
    }

    public static Note fromNoteSekI(Integer noteSekI) {
        if (noteSekI == null) {
            return null;
        }
        switch (noteSekI) {
            case 1: {
                return SEHR_GUT;
            }
            case 2: {
                return GUT;
            }
            case 3: {
                return BEFRIEDIGEND;
            }
            case 4: {
                return AUSREICHEND;
            }
            case 5: {
                return MANGELHAFT;
            }
            case 6: {
                return UNGENUEGEND;
            }
        }
        return null;
    }

    @NotNull
    public static Note fromNotenpunkte(Integer notenpunkte) {
        if (notenpunkte == null) {
            return KEINE;
        }
        switch (notenpunkte) {
            case 0: {
                return UNGENUEGEND;
            }
            case 1: {
                return MANGELHAFT_MINUS;
            }
            case 2: {
                return MANGELHAFT;
            }
            case 3: {
                return MANGELHAFT_PLUS;
            }
            case 4: {
                return AUSREICHEND_MINUS;
            }
            case 5: {
                return AUSREICHEND;
            }
            case 6: {
                return AUSREICHEND_PLUS;
            }
            case 7: {
                return BEFRIEDIGEND_MINUS;
            }
            case 8: {
                return BEFRIEDIGEND;
            }
            case 9: {
                return BEFRIEDIGEND_PLUS;
            }
            case 10: {
                return GUT_MINUS;
            }
            case 11: {
                return GUT;
            }
            case 12: {
                return GUT_PLUS;
            }
            case 13: {
                return SEHR_GUT_MINUS;
            }
            case 14: {
                return SEHR_GUT;
            }
            case 15: {
                return SEHR_GUT_PLUS;
            }
        }
        return KEINE;
    }

    @NotNull
    public static Note fromKuerzel(String kuerzel) {
        String kuerzelUppercase;
        if (kuerzel == null) {
            return KEINE;
        }
        switch (kuerzelUppercase = kuerzel.toUpperCase()) {
            case "6": {
                return UNGENUEGEND;
            }
            case "5-": {
                return MANGELHAFT_MINUS;
            }
            case "5": {
                return MANGELHAFT;
            }
            case "5+": {
                return MANGELHAFT_PLUS;
            }
            case "4-": {
                return AUSREICHEND_MINUS;
            }
            case "4": {
                return AUSREICHEND;
            }
            case "4+": {
                return AUSREICHEND_PLUS;
            }
            case "3-": {
                return BEFRIEDIGEND_MINUS;
            }
            case "3": {
                return BEFRIEDIGEND;
            }
            case "3+": {
                return BEFRIEDIGEND_PLUS;
            }
            case "2-": {
                return GUT_MINUS;
            }
            case "2": {
                return GUT;
            }
            case "2+": {
                return GUT_PLUS;
            }
            case "1-": {
                return SEHR_GUT_MINUS;
            }
            case "1": {
                return SEHR_GUT;
            }
            case "1+": {
                return SEHR_GUT_PLUS;
            }
            case "E1": {
                return E1_MIT_BESONDEREM_ERFOLG_TEILGENOMMEN;
            }
            case "E2": {
                return E2_MIT_ERFOLG_TEILGENOMMEN;
            }
            case "E3": {
                return E3_TEILGENOMMEN;
            }
            case "AT": {
                return ATTEST;
            }
            case "AM": {
                return ABGEMELDET;
            }
            case "NB": {
                return NICHT_BEURTEILT;
            }
            case "NT": {
                return NICHT_TEILGENOMMEN;
            }
            case "NE": {
                return NICHT_ERTEILT;
            }
            case "LM": {
                return LEHRERMANGEL;
            }
        }
        return KEINE;
    }

    @NotNull
    public static Note fromNotenpunkteString(String notenpunkte) {
        if (notenpunkte == null) {
            return KEINE;
        }
        switch (notenpunkte) {
            case "0": {
                return UNGENUEGEND;
            }
            case "1": {
                return MANGELHAFT_MINUS;
            }
            case "2": {
                return MANGELHAFT;
            }
            case "3": {
                return MANGELHAFT_PLUS;
            }
            case "4": {
                return AUSREICHEND_MINUS;
            }
            case "5": {
                return AUSREICHEND;
            }
            case "6": {
                return AUSREICHEND_PLUS;
            }
            case "7": {
                return BEFRIEDIGEND_MINUS;
            }
            case "8": {
                return BEFRIEDIGEND;
            }
            case "9": {
                return BEFRIEDIGEND_PLUS;
            }
            case "10": {
                return GUT_MINUS;
            }
            case "11": {
                return GUT;
            }
            case "12": {
                return GUT_PLUS;
            }
            case "13": {
                return SEHR_GUT_MINUS;
            }
            case "14": {
                return SEHR_GUT;
            }
            case "15": {
                return SEHR_GUT_PLUS;
            }
        }
        return KEINE;
    }

    public boolean hatTendenz() {
        return this.notenpunkte != null && this.notenpunkte != 0 && this.notenpunkte % 3 != 2;
    }

    @JsonIgnore
    @NotNull
    public Note ohneTendenz() {
        if (this.notenpunkte == null) {
            return KEINE;
        }
        switch (this.notenpunkte) {
            case 0: {
                return UNGENUEGEND;
            }
            case 1: 
            case 2: 
            case 3: {
                return MANGELHAFT;
            }
            case 4: 
            case 5: 
            case 6: {
                return AUSREICHEND;
            }
            case 7: 
            case 8: 
            case 9: {
                return BEFRIEDIGEND;
            }
            case 10: 
            case 11: 
            case 12: {
                return GUT;
            }
            case 13: 
            case 14: 
            case 15: {
                return SEHR_GUT;
            }
        }
        return KEINE;
    }

    @JsonIgnore
    @NotNull
    public String toString() {
        return this.kuerzel;
    }

    @JsonIgnore
    public Integer getNoteSekI() {
        switch (this.notenpunkte) {
            case 13: 
            case 14: 
            case 15: {
                return 1;
            }
            case 10: 
            case 11: 
            case 12: {
                return 2;
            }
            case 7: 
            case 8: 
            case 9: {
                return 3;
            }
            case 4: 
            case 5: 
            case 6: {
                return 4;
            }
            case 1: 
            case 2: 
            case 3: {
                return 5;
            }
            case 0: {
                return 6;
            }
        }
        return null;
    }

    @NotNull
    public NotenKatalogEintrag getKatalogEintrag() {
        if (this.katalogEintrag == null) {
            this.katalogEintrag = new NotenKatalogEintrag(this.id, this.sortierung, this.notenpunkte, this.kuerzel, this.text, this.textZeugnis, this.gueltigVon, this.gueltigBis);
        }
        return this.katalogEintrag;
    }
}

