/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.types;

import jakarta.validation.constraints.NotNull;
import java.util.HashMap;

public enum PersonalTyp {
    LEHRKRAFT(1, "LEHRKRAFT", "Lehrkraft", null, null),
    SEKRETARIAT(2, "SEKRETARIAT", "Sekret\u00e4r/Sekret\u00e4rin", null, null),
    PERSONAL(3, "PERSONAL", "Angestelltes Personal ohne Identnummer", null, null),
    EXTERN(4, "EXTERN", "Externe Lehrkraft, z.B. abgeordnet oder im Rahmen einer Kooperation", null, null),
    SONSTIGE(5, "SONSTIGE", "Sonstiges Personal", null, null);

    public static final long VERSION = 1L;
    @NotNull
    private static final @NotNull HashMap<@NotNull String, @NotNull PersonalTyp> _mapBezeichnungen;
    @NotNull
    private static final @NotNull HashMap<@NotNull Integer, @NotNull PersonalTyp> _mapID;
    public final int id;
    @NotNull
    public final String kuerzel;
    @NotNull
    public final String bezeichnung;
    public final Integer gueltigVon;
    public final Integer gueltigBis;

    private PersonalTyp(@NotNull int id, String kuerzel, String bezeichnung, Integer gueltigVon, Integer gueltigBis) {
        this.id = id;
        this.kuerzel = kuerzel;
        this.bezeichnung = bezeichnung;
        this.gueltigVon = gueltigVon;
        this.gueltigBis = gueltigBis;
    }

    @NotNull
    private static @NotNull HashMap<@NotNull Integer, @NotNull PersonalTyp> getMapID() {
        if (_mapID.size() == 0) {
            for (PersonalTyp p : PersonalTyp.values()) {
                _mapID.put(p.id, p);
            }
        }
        return _mapID;
    }

    @NotNull
    private static @NotNull HashMap<@NotNull String, @NotNull PersonalTyp> getMapBezeichnungen() {
        if (_mapBezeichnungen.size() == 0) {
            for (PersonalTyp p : PersonalTyp.values()) {
                _mapBezeichnungen.put(p.kuerzel, p);
            }
        }
        return _mapBezeichnungen;
    }

    public static PersonalTyp fromBezeichnung(String bezeichnung) {
        return PersonalTyp.getMapBezeichnungen().get(bezeichnung);
    }

    public static PersonalTyp fromID(Integer id) {
        return PersonalTyp.getMapID().get(id);
    }

    @NotNull
    public String toString() {
        return this.kuerzel;
    }

    static {
        _mapBezeichnungen = new HashMap();
        _mapID = new HashMap();
    }
}

