/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.types;

import jakarta.validation.constraints.NotNull;
import java.util.HashMap;

public enum SchuelerStatus {
    NEUAUFNAHME(0, "Neuaufnahme", null, null),
    WARTELISTE(1, "Warteliste", null, null),
    AKTIV(2, "Aktiv", null, null),
    BEURLAUBT(3, "Beurlaubt", null, null),
    EXTERN(6, "Extern", null, null),
    ABSCHLUSS(8, "Abschluss", null, null),
    ABGANG(9, "Abgang", null, null),
    EHEMALIGE(10, "Ehemalige", null, null);

    public static final long VERSION = 1L;
    @NotNull
    private static final @NotNull HashMap<@NotNull Integer, @NotNull SchuelerStatus> _mapID;
    @NotNull
    private static final @NotNull HashMap<@NotNull String, @NotNull SchuelerStatus> _mapBezeichnungen;
    public final int id;
    @NotNull
    public final String bezeichnung;
    public final Integer gueltigVon;
    public final Integer gueltigBis;

    private SchuelerStatus(int id, String bezeichnung, Integer gueltigVon, Integer gueltigBis) {
        this.id = id;
        this.bezeichnung = bezeichnung;
        this.gueltigVon = gueltigVon;
        this.gueltigBis = gueltigBis;
    }

    @NotNull
    private static @NotNull HashMap<@NotNull Integer, @NotNull SchuelerStatus> getMapID() {
        if (_mapID.size() == 0) {
            for (SchuelerStatus p : SchuelerStatus.values()) {
                _mapID.put(p.id, p);
            }
        }
        return _mapID;
    }

    @NotNull
    private static @NotNull HashMap<@NotNull String, @NotNull SchuelerStatus> getMapBezeichnungen() {
        if (_mapBezeichnungen.size() == 0) {
            for (SchuelerStatus p : SchuelerStatus.values()) {
                _mapBezeichnungen.put(p.bezeichnung.toUpperCase(), p);
            }
        }
        return _mapBezeichnungen;
    }

    public static SchuelerStatus fromID(int status) {
        return SchuelerStatus.getMapID().get(status);
    }

    public static SchuelerStatus fromBezeichnung(String value) {
        if (value == null) {
            return null;
        }
        return SchuelerStatus.getMapBezeichnungen().get(value.toUpperCase());
    }

    public static boolean isValidID(Integer id) {
        if (id == null) {
            return false;
        }
        for (SchuelerStatus status : SchuelerStatus.values()) {
            if (status.id != id) continue;
            return true;
        }
        return false;
    }

    static {
        _mapID = new HashMap();
        _mapBezeichnungen = new HashMap();
    }
}

