/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.types;

import jakarta.validation.constraints.NotNull;

public enum ServerMode {
    STABLE("stable"),
    BETA("beta"),
    ALPHA("alpha"),
    DEV("dev");

    @NotNull
    public final String text;

    private ServerMode(String text) {
        this.text = text;
    }

    @NotNull
    public String toString() {
        return this.text;
    }

    public boolean checkServerMode(ServerMode serverMode) {
        return serverMode == STABLE && this == STABLE || serverMode == BETA && this != DEV && this != ALPHA || serverMode == ALPHA && this != DEV || serverMode == DEV;
    }

    @NotNull
    public static ServerMode getByText(String text) {
        for (ServerMode mode : ServerMode.values()) {
            if (!mode.text.equalsIgnoreCase(text)) continue;
            return mode;
        }
        return STABLE;
    }
}

