/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.types;

import de.svws_nrw.core.exceptions.DeveloperNotificationException;
import jakarta.validation.constraints.NotNull;

public enum Wochentag {
    MONTAG(1, "Montag", "Mo"),
    DIENSTAG(2, "Dienstag", "Di"),
    MITTWOCH(3, "Mittwoch", "Mi"),
    DONNERSTAG(4, "Donnerstag", "Do"),
    FREITAG(5, "Freitag", "Fr"),
    SAMSTAG(6, "Samstag", "Sa"),
    SONNTAG(7, "Sonntag", "So");

    @NotNull
    public final int id;
    @NotNull
    public final String beschreibung;
    @NotNull
    public final String kuerzel;

    private Wochentag(@NotNull int id, String beschreibung, String kuerzel) {
        this.id = id;
        this.beschreibung = beschreibung;
        this.kuerzel = kuerzel;
    }

    @NotNull
    public String toString() {
        return this.beschreibung;
    }

    @NotNull
    public static Wochentag fromIDorException(int id) throws DeveloperNotificationException {
        DeveloperNotificationException.ifTrue("Der Wochentag(" + id + ") muss zwischen 1 (Montag) und 7 (Sonntag) liegen!", id < 1 || id > 7);
        @NotNull Wochentag @NotNull [] wochentage = Wochentag.values();
        return wochentage[id - 1];
    }
}

