/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.types.benutzer;

import de.svws_nrw.core.adt.map.ArrayMap;
import de.svws_nrw.core.data.benutzer.BenutzerKompetenzKatalogEintrag;
import de.svws_nrw.core.types.benutzer.BenutzerKompetenzGruppe;
import de.svws_nrw.core.types.schule.Schulform;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum BenutzerKompetenz {
    KEINE(new BenutzerKompetenzKatalogEintrag(-2L, BenutzerKompetenzGruppe.KEINE, "keine", null)),
    ADMIN(new BenutzerKompetenzKatalogEintrag(-1L, BenutzerKompetenzGruppe.ADMIN, "admin", null)),
    SCHUELER_INDIVIDUALDATEN_ANSEHEN(new BenutzerKompetenzKatalogEintrag(11L, BenutzerKompetenzGruppe.SCHUELER_INDIVIDUALDATEN, "Ansehen", null)),
    SCHUELER_INDIVIDUALDATEN_AENDERN(new BenutzerKompetenzKatalogEintrag(12L, BenutzerKompetenzGruppe.SCHUELER_INDIVIDUALDATEN, "\u00c4ndern", null)),
    SCHUELER_INDIVIDUALDATEN_LOESCHEN(new BenutzerKompetenzKatalogEintrag(13L, BenutzerKompetenzGruppe.SCHUELER_INDIVIDUALDATEN, "L\u00f6schen", null)),
    SCHUELER_INDIVIDUALDATEN_VERMERKE_AENDERN(new BenutzerKompetenzKatalogEintrag(14L, BenutzerKompetenzGruppe.SCHUELER_INDIVIDUALDATEN, "Vermerke \u00e4ndern", null)),
    SCHUELER_INDIVIDUALDATEN_KAOA_DATEN_AENDERN(new BenutzerKompetenzKatalogEintrag(15L, BenutzerKompetenzGruppe.SCHUELER_INDIVIDUALDATEN, "KAoA-Daten \u00e4ndern", null)),
    SCHUELER_INDIVIDUALDATEN_EINWILLIGUNGEN_AENDERN(new BenutzerKompetenzKatalogEintrag(16L, BenutzerKompetenzGruppe.SCHUELER_INDIVIDUALDATEN, "Einwilligungen \u00e4ndern (DSGVO, Lernplattformen)", null)),
    SCHUELER_LEISTUNGSDATEN_ANSEHEN(new BenutzerKompetenzKatalogEintrag(21L, BenutzerKompetenzGruppe.SCHUELER_LEISTUNGSDATEN, "Ansehen", null)),
    SCHUELER_LEISTUNGSDATEN_FUNKTIONSBEZOGEN_AENDERN(new BenutzerKompetenzKatalogEintrag(22L, BenutzerKompetenzGruppe.SCHUELER_LEISTUNGSDATEN, "Funktionsbezogen \u00e4ndern", null)),
    SCHUELER_LEISTUNGSDATEN_ALLE_AENDERN(new BenutzerKompetenzKatalogEintrag(23L, BenutzerKompetenzGruppe.SCHUELER_LEISTUNGSDATEN, "Alle \u00e4ndern", null)),
    BERICHTE_ALLE_FORMULARE_DRUCKEN(new BenutzerKompetenzKatalogEintrag(31L, BenutzerKompetenzGruppe.BERICHTE, "Alle Formulare drucken", null)),
    BERICHTE_STANDARDFORMULARE_DRUCKEN(new BenutzerKompetenzKatalogEintrag(32L, BenutzerKompetenzGruppe.BERICHTE, "Standard-Formulare drucken", null)),
    BERICHTE_AENDERN(new BenutzerKompetenzKatalogEintrag(33L, BenutzerKompetenzGruppe.BERICHTE, "\u00c4ndern", null)),
    BERICHTE_LOESCHEN(new BenutzerKompetenzKatalogEintrag(34L, BenutzerKompetenzGruppe.BERICHTE, "L\u00f6schen", null)),
    IMPORT_EXPORT_DATEN_IMPORTIEREN(new BenutzerKompetenzKatalogEintrag(41L, BenutzerKompetenzGruppe.IMPORT_EXPORT, "Daten importieren", null)),
    IMPORT_EXPORT_SCHUELERDATEN_EXPORTIEREN(new BenutzerKompetenzKatalogEintrag(42L, BenutzerKompetenzGruppe.IMPORT_EXPORT, "Sch\u00fclerdaten exportieren", null)),
    IMPORT_EXPORT_LEHRERDATEN_EXPORTIEREN(new BenutzerKompetenzKatalogEintrag(43L, BenutzerKompetenzGruppe.IMPORT_EXPORT, "Lehrerdaten exportieren", null)),
    IMPORT_EXPORT_SCHNITTSTELLE_SCHILD_NRW(new BenutzerKompetenzKatalogEintrag(44L, BenutzerKompetenzGruppe.IMPORT_EXPORT, "Schnittstelle SchILD-NRW verwenden", null)),
    IMPORT_EXPORT_ACCESS_DB(new BenutzerKompetenzKatalogEintrag(45L, BenutzerKompetenzGruppe.IMPORT_EXPORT, "Access-DB-Export durchf\u00fchren", null)),
    IMPORT_EXPORT_XML(new BenutzerKompetenzKatalogEintrag(46L, BenutzerKompetenzGruppe.IMPORT_EXPORT, "Export \u00fcber XML-Schnittstellen", null)),
    IMPORT_EXPORT_SCHULBEWERBUNG_DE(new BenutzerKompetenzKatalogEintrag(47L, BenutzerKompetenzGruppe.IMPORT_EXPORT, "Datenaustausch mit Schulbewerbung.de", null)),
    SCHULBEZOGENE_DATEN_ANSEHEN(new BenutzerKompetenzKatalogEintrag(61L, BenutzerKompetenzGruppe.SCHULBEZOGENE_DATEN, "Ansehen", null)),
    SCHULBEZOGENE_DATEN_AENDERN(new BenutzerKompetenzKatalogEintrag(62L, BenutzerKompetenzGruppe.SCHULBEZOGENE_DATEN, "\u00c4ndern", null)),
    EXTRAS_BACKUP_DURCHFUEHREN(new BenutzerKompetenzKatalogEintrag(71L, BenutzerKompetenzGruppe.EXTRAS, "Backup durchf\u00fchren", null)),
    EXTRAS_GELOESCHTE_DATEN_ZURUECKHOLEN(new BenutzerKompetenzKatalogEintrag(72L, BenutzerKompetenzGruppe.EXTRAS, "Gel\u00f6schte Daten zur\u00fcckholen", null)),
    EXTRAS_FARBEN_FUER_FACHGRUPPEN_AENDERN(new BenutzerKompetenzKatalogEintrag(73L, BenutzerKompetenzGruppe.EXTRAS, "Farben f\u00fcr Fachgruppen \u00e4ndern", null)),
    EXTRAS_DATEN_AUS_KURS42_IMPORTIEREN(new BenutzerKompetenzKatalogEintrag(74L, BenutzerKompetenzGruppe.EXTRAS, "Daten aus Kurs42 importieren", Schulform.getMitGymOb())),
    EXTRAS_DATEN_PERSONENGRUPPEN_BEARBEITEN(new BenutzerKompetenzKatalogEintrag(75L, BenutzerKompetenzGruppe.EXTRAS, "Personengruppen bearbeiten", null)),
    KATALOG_EINTRAEGE_ANSEHEN(new BenutzerKompetenzKatalogEintrag(81L, BenutzerKompetenzGruppe.KATALOG_EINTRAEGE, "Ansehen", null)),
    KATALOG_EINTRAEGE_AENDERN(new BenutzerKompetenzKatalogEintrag(82L, BenutzerKompetenzGruppe.KATALOG_EINTRAEGE, "\u00c4ndern", null)),
    KATALOG_EINTRAEGE_LOESCHEN(new BenutzerKompetenzKatalogEintrag(83L, BenutzerKompetenzGruppe.KATALOG_EINTRAEGE, "L\u00f6schen", null)),
    LEHRERDATEN_ANSEHEN(new BenutzerKompetenzKatalogEintrag(91L, BenutzerKompetenzGruppe.LEHRERDATEN, "Ansehen", null)),
    LEHRERDATEN_AENDERN(new BenutzerKompetenzKatalogEintrag(92L, BenutzerKompetenzGruppe.LEHRERDATEN, "\u00c4ndern", null)),
    LEHRERDATEN_LOESCHEN(new BenutzerKompetenzKatalogEintrag(93L, BenutzerKompetenzGruppe.LEHRERDATEN, "L\u00f6schen", null)),
    LEHRERDATEN_DETAILDATEN_ANSEHEN(new BenutzerKompetenzKatalogEintrag(94L, BenutzerKompetenzGruppe.LEHRERDATEN, "Detaildaten ansehen", null)),
    LEHRERDATEN_DETAILDATEN_AENDERN(new BenutzerKompetenzKatalogEintrag(95L, BenutzerKompetenzGruppe.LEHRERDATEN, "Detaildaten \u00e4ndern", null)),
    SCHULPFLICHTVERLETZUNG_ANSEHEN(new BenutzerKompetenzKatalogEintrag(101L, BenutzerKompetenzGruppe.SCHULPFLICHTVERLETZUNG, "Ansehen", null)),
    SCHULPFLICHTVERLETZUNG_AENDERN(new BenutzerKompetenzKatalogEintrag(102L, BenutzerKompetenzGruppe.SCHULPFLICHTVERLETZUNG, "\u00c4ndern", null)),
    SCHULPFLICHTVERLETZUNG_LOESCHEN(new BenutzerKompetenzKatalogEintrag(103L, BenutzerKompetenzGruppe.SCHULPFLICHTVERLETZUNG, "L\u00f6schen", null)),
    STUNDENPLAN_ALLGEMEIN_ANSEHEN(new BenutzerKompetenzKatalogEintrag(111L, BenutzerKompetenzGruppe.STUNDENPLANUNG, "Stundenplan ansehen (allgemein)", null)),
    STUNDENPLAN_FUNKTIONSBEZOGEN_ANSEHEN(new BenutzerKompetenzKatalogEintrag(112L, BenutzerKompetenzGruppe.STUNDENPLANUNG, "Stundneplan ansehen (funktionsbezogen)", null)),
    STUNDENPLAN_IMPORT(new BenutzerKompetenzKatalogEintrag(113L, BenutzerKompetenzGruppe.STUNDENPLANUNG, "Stundenpl\u00e4ne importieren", null)),
    STUNDENPLAN_EXPORT(new BenutzerKompetenzKatalogEintrag(114L, BenutzerKompetenzGruppe.STUNDENPLANUNG, "Stundenpl\u00e4ne exportieren", null)),
    STUNDENPLAN_ERSTELLEN(new BenutzerKompetenzKatalogEintrag(115L, BenutzerKompetenzGruppe.STUNDENPLANUNG, "Stundenpl\u00e4ne erstellen", null)),
    STUNDENPLAN_AKTIVIEREN(new BenutzerKompetenzKatalogEintrag(116L, BenutzerKompetenzGruppe.STUNDENPLANUNG, "Stundenpl\u00e4ne aktivieren", null)),
    NOTENMODUL_ADMINISTRATION(new BenutzerKompetenzKatalogEintrag(131L, BenutzerKompetenzGruppe.NOTENMODUL, "Administration Notenmodul", null)),
    NOTENMODUL_NOTEN_AENDERN_ALLGEMEIN(new BenutzerKompetenzKatalogEintrag(132L, BenutzerKompetenzGruppe.NOTENMODUL, "Noten \u00e4ndern (allgemein)", null)),
    NOTENMODUL_NOTEN_AENDERN_FUNKTION(new BenutzerKompetenzKatalogEintrag(133L, BenutzerKompetenzGruppe.NOTENMODUL, "Noten \u00e4ndern (funktionsbezogen)", null)),
    NOTENMODUL_NOTEN_ANSEHEN_ALLGEMEIN(new BenutzerKompetenzKatalogEintrag(134L, BenutzerKompetenzGruppe.NOTENMODUL, "Noten ansehen (allgemein)", null)),
    NOTENMODUL_NOTEN_ANSEHEN_FUNKTION(new BenutzerKompetenzKatalogEintrag(135L, BenutzerKompetenzGruppe.NOTENMODUL, "Noten ansehen (funktionsbezogen)", null)),
    DATENBANK_SCHEMA_ERSTELLEN(new BenutzerKompetenzKatalogEintrag(141L, BenutzerKompetenzGruppe.DATENBANK, "Schema erstellen und migrieren", null)),
    DATENBANK_SQLITE_IMPORT(new BenutzerKompetenzKatalogEintrag(142L, BenutzerKompetenzGruppe.DATENBANK, "SQLite importieren (Backup einspielen)", null)),
    DATENBANK_SQLITE_EXPORT(new BenutzerKompetenzKatalogEintrag(143L, BenutzerKompetenzGruppe.DATENBANK, "SQLite exportieren (Backup erstellen)", null)),
    OBERSTUFE_LAUFBAHNPLANUNG_ALLGEMEIN(new BenutzerKompetenzKatalogEintrag(161L, BenutzerKompetenzGruppe.OBERSTUFE_LAUFBAHNPLANUNG, "Laufbahnplanung (allgemein)", Schulform.getMitGymOb())),
    OBERSTUFE_LAUFBAHNPLANUNG_FUNKTIONSBEZOGEN(new BenutzerKompetenzKatalogEintrag(162L, BenutzerKompetenzGruppe.OBERSTUFE_LAUFBAHNPLANUNG, "Laufbahnplanung (funktionsbezogen)", Schulform.getMitGymOb())),
    OBERSTUFE_LUPO_IMPORT(new BenutzerKompetenzKatalogEintrag(163L, BenutzerKompetenzGruppe.OBERSTUFE_LAUFBAHNPLANUNG, "Laufbahnplanung aus LuPO importieren", Schulform.getMitGymOb())),
    OBERSTUFE_KURSPLANUNG_ALLGEMEIN(new BenutzerKompetenzKatalogEintrag(171L, BenutzerKompetenzGruppe.OBERSTUFE_KURSPLANUNG, "Kursverwaltung - Blocken (allgemein)", Schulform.getMitGymOb())),
    OBERSTUFE_KURSPLANUNG_FUNKTIONSBEZOGEN(new BenutzerKompetenzKatalogEintrag(172L, BenutzerKompetenzGruppe.OBERSTUFE_KURSPLANUNG, "Kursverwaltung - Blocken (funktionsbezogen)", Schulform.getMitGymOb())),
    OBERSTUFE_KURSPLANUNG_BLOCKUNG_AKTIVIEREN(new BenutzerKompetenzKatalogEintrag(173L, BenutzerKompetenzGruppe.OBERSTUFE_KURSPLANUNG, "Kursverwaltung - Blockung aktivieren", Schulform.getMitGymOb())),
    OBERSTUFE_KLAUSURPLANUNG_AENDERN(new BenutzerKompetenzKatalogEintrag(181L, BenutzerKompetenzGruppe.OBERSTUFE_KLAUSURPLANUNG, "Klausurplanung \u00e4ndern", Schulform.getMitGymOb())),
    OBERSTUFE_KLAUSURPLANUNG_ANSEHEN_ALLGEMEIN(new BenutzerKompetenzKatalogEintrag(182L, BenutzerKompetenzGruppe.OBERSTUFE_KLAUSURPLANUNG, "Klausurplanung ansehen (allgemein)", Schulform.getMitGymOb())),
    OBERSTUFE_KLAUSURPLANUNG_ANSEHEN_FUNKTION(new BenutzerKompetenzKatalogEintrag(183L, BenutzerKompetenzGruppe.OBERSTUFE_KLAUSURPLANUNG, "Klausurplanung ansehen (funktionsbezogen)", Schulform.getMitGymOb())),
    ABITUR_ANSEHEN_ALLGEMEIN(new BenutzerKompetenzKatalogEintrag(191L, BenutzerKompetenzGruppe.ABITUR, "Abiturdaten ansehen (allgemein)", Schulform.getMitGymOb())),
    ABITUR_ANSEHEN_FUNKTIONSBEZOGEN(new BenutzerKompetenzKatalogEintrag(192L, BenutzerKompetenzGruppe.ABITUR, "Abiturdaten ansehen (funktionsbezogen)", Schulform.getMitGymOb())),
    ABITUR_AENDERN_ALLGEMEIN(new BenutzerKompetenzKatalogEintrag(193L, BenutzerKompetenzGruppe.ABITUR, "Abiturdaten \u00e4ndern (allgemein)", Schulform.getMitGymOb())),
    ABITUR_AENDERN_FUNKTIONSBEZOGEN(new BenutzerKompetenzKatalogEintrag(194L, BenutzerKompetenzGruppe.ABITUR, "Abiturdaten \u00e4ndern (funktionsbezogen)", Schulform.getMitGymOb())),
    ABITUR_EINGABE_ERGEBNISSE_ALLGEMEIN(new BenutzerKompetenzKatalogEintrag(195L, BenutzerKompetenzGruppe.ABITUR, "Pr\u00fcfungsergebnisse eingeben (allgemein)", Schulform.getMitGymOb())),
    ABITUR_EINGABE_ERGEBNISSE_FUNKTIONSBEZOGEN(new BenutzerKompetenzKatalogEintrag(196L, BenutzerKompetenzGruppe.ABITUR, "Pr\u00fcfungsergebnisse eingeben (funktionsbezogen)", Schulform.getMitGymOb())),
    ADRESSDATEN_ERZIEHER_ANSEHEN(new BenutzerKompetenzKatalogEintrag(201L, BenutzerKompetenzGruppe.CARDDAV, "Ansehen", null)),
    ADRESSDATEN_ANSEHEN(new BenutzerKompetenzKatalogEintrag(202L, BenutzerKompetenzGruppe.CARDDAV, "Ansehen", null)),
    KALENDER_ANSEHEN(new BenutzerKompetenzKatalogEintrag(301L, BenutzerKompetenzGruppe.CALDAV, "Ansehen", null)),
    EIGENEN_KALENDER_BEARBEITEN(new BenutzerKompetenzKatalogEintrag(302L, BenutzerKompetenzGruppe.CALDAV, "Bearbeiten", null)),
    KALENDER_FUNKTIONSBEZOGEN_ANSEHEN(new BenutzerKompetenzKatalogEintrag(303L, BenutzerKompetenzGruppe.CALDAV, "Ansehen", null)),
    ABSCHLUSS_SEKI_ANSEHEN_ALLGEMEIN(new BenutzerKompetenzKatalogEintrag(401L, BenutzerKompetenzGruppe.ABSCHLUSS_SEKI, "Abschlussdaten ansehen (allgemein)", null)),
    ABSCHLUSS_SEKI_ANSEHEN_FUNKTIONSBEZOGEN(new BenutzerKompetenzKatalogEintrag(402L, BenutzerKompetenzGruppe.ABSCHLUSS_SEKI, "Abschlussdaten ansehen (funktionsbezogen)", null)),
    ABSCHLUSS_SEKI_AENDERN_ALLGEMEIN(new BenutzerKompetenzKatalogEintrag(403L, BenutzerKompetenzGruppe.ABSCHLUSS_SEKI, "Abschlussdaten \u00e4ndern (allgemein)", null)),
    ABSCHLUSS_SEKI_AENDERN_FUNKTIONSBEZOGEN(new BenutzerKompetenzKatalogEintrag(404L, BenutzerKompetenzGruppe.ABSCHLUSS_SEKI, "Abschlussdaten \u00e4ndern (funktionsbezogen)", null)),
    ABSCHLUSS_SEKI_EINGABE_ERGEBNISSE_ALLGEMEIN(new BenutzerKompetenzKatalogEintrag(405L, BenutzerKompetenzGruppe.ABSCHLUSS_SEKI, "Pr\u00fcfungsergebnisse eingeben (allgemein)", null)),
    ABSCHLUSS_SEKI_EINGABE_ERGEBNISSE_FUNKTIONSBEZOGEN(new BenutzerKompetenzKatalogEintrag(406L, BenutzerKompetenzGruppe.ABSCHLUSS_SEKI, "Pr\u00fcfungsergebnisse eingeben (funktionsbezogen)", null)),
    ABSCHLUSS_BK_ANSEHEN_ALLGEMEIN(new BenutzerKompetenzKatalogEintrag(501L, BenutzerKompetenzGruppe.ABSCHLUSS_BK, "Abschlussdaten ansehen (allgemein)", Arrays.asList(Schulform.BK, Schulform.SB))),
    ABSCHLUSS_BK_ANSEHEN_FUNKTIONSBEZOGEN(new BenutzerKompetenzKatalogEintrag(502L, BenutzerKompetenzGruppe.ABSCHLUSS_BK, "Abschlussdaten ansehen (funktionsbezogen)", Arrays.asList(Schulform.BK, Schulform.SB))),
    ABSCHLUSS_BK_AENDERN_ALLGEMEIN(new BenutzerKompetenzKatalogEintrag(503L, BenutzerKompetenzGruppe.ABSCHLUSS_BK, "Abschlussdaten \u00e4ndern (allgemein)", Arrays.asList(Schulform.BK, Schulform.SB))),
    ABSCHLUSS_BK_AENDERN_FUNKTIONSBEZOGEN(new BenutzerKompetenzKatalogEintrag(504L, BenutzerKompetenzGruppe.ABSCHLUSS_BK, "Abschlussdaten \u00e4ndern (funktionsbezogen)", Arrays.asList(Schulform.BK, Schulform.SB))),
    ABSCHLUSS_BK_EINGABE_ERGEBNISSE_ALLGEMEIN(new BenutzerKompetenzKatalogEintrag(505L, BenutzerKompetenzGruppe.ABSCHLUSS_BK, "Pr\u00fcfungsergebnisse eingeben (allgemein)", Arrays.asList(Schulform.BK, Schulform.SB))),
    ABSCHLUSS_BK_EINGABE_ERGEBNISSE_FUNKTIONSBEZOGEN(new BenutzerKompetenzKatalogEintrag(506L, BenutzerKompetenzGruppe.ABSCHLUSS_BK, "Pr\u00fcfungsergebnisse eingeben (funktionsbezogen)", Arrays.asList(Schulform.BK, Schulform.SB)));

    public static final long VERSION = 1L;
    @NotNull
    public final BenutzerKompetenzKatalogEintrag daten;
    @NotNull
    private static final @NotNull HashMap<@NotNull Long, @NotNull BenutzerKompetenz> _mapID;
    @NotNull
    private static final @NotNull ArrayMap<@NotNull BenutzerKompetenzGruppe, @NotNull List<@NotNull BenutzerKompetenz>> _mapGruppenZuordnung;

    private BenutzerKompetenz(BenutzerKompetenzKatalogEintrag daten) {
        this.daten = daten;
    }

    @NotNull
    private static @NotNull HashMap<@NotNull Long, @NotNull BenutzerKompetenz> getMapID() {
        if (_mapID.size() == 0) {
            for (BenutzerKompetenz p : BenutzerKompetenz.values()) {
                _mapID.put(p.daten.id, p);
            }
        }
        return _mapID;
    }

    @NotNull
    private static @NotNull Map<@NotNull BenutzerKompetenzGruppe, @NotNull List<@NotNull BenutzerKompetenz>> getMapGruppenZuordnung() {
        if (_mapGruppenZuordnung.size() == 0) {
            for (BenutzerKompetenzGruppe benutzerKompetenzGruppe : BenutzerKompetenzGruppe.values()) {
                _mapGruppenZuordnung.put(benutzerKompetenzGruppe, new ArrayList());
            }
            for (Enum enum_ : BenutzerKompetenz.values()) {
                List<BenutzerKompetenz> liste;
                BenutzerKompetenzGruppe gruppe = BenutzerKompetenzGruppe.getByID(((BenutzerKompetenz)enum_).daten.gruppe_id);
                if (gruppe == null) {
                    gruppe = BenutzerKompetenzGruppe.KEINE;
                }
                if ((liste = _mapGruppenZuordnung.get((Object)gruppe)) == null) continue;
                liste.add((BenutzerKompetenz)enum_);
            }
        }
        return _mapGruppenZuordnung;
    }

    public static BenutzerKompetenz getByID(long id) {
        return BenutzerKompetenz.getMapID().get(id);
    }

    public boolean hatSchulform(Schulform schulform) {
        if (schulform == null || schulform.daten == null) {
            return false;
        }
        if (this.daten.nurSchulformen != null) {
            return this.daten.nurSchulformen.contains(schulform.daten.id);
        }
        return true;
    }

    @NotNull
    public static @NotNull List<@NotNull BenutzerKompetenz> getKompetenzen(@NotNull BenutzerKompetenzGruppe gruppe) {
        List<@NotNull BenutzerKompetenz> liste = BenutzerKompetenz.getMapGruppenZuordnung().get((Object)gruppe);
        if (liste == null) {
            return new ArrayList<BenutzerKompetenz>();
        }
        return liste;
    }

    @NotNull
    public static @NotNull List<@NotNull BenutzerKompetenz> getKompetenzenMitSchulform(@NotNull BenutzerKompetenzGruppe gruppe, @NotNull Schulform schulform) {
        ArrayList<@NotNull BenutzerKompetenz> l = new ArrayList<BenutzerKompetenz>();
        List<@NotNull BenutzerKompetenz> liste = BenutzerKompetenz.getMapGruppenZuordnung().get((Object)gruppe);
        if (liste == null) {
            return l;
        }
        for (BenutzerKompetenz bk : liste) {
            if (!bk.hatSchulform(schulform)) continue;
            l.add(bk);
        }
        return l;
    }

    static {
        _mapID = new HashMap();
        _mapGruppenZuordnung = new ArrayMap(BenutzerKompetenzGruppe.values());
    }
}

