/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.types.fach;

import de.svws_nrw.core.data.fach.BilingualeSpracheKatalogEintrag;
import de.svws_nrw.core.types.fach.ZulaessigesFach;
import de.svws_nrw.core.types.schule.Schulform;
import jakarta.validation.constraints.NotNull;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public enum BilingualeSprache {
    ENGLISCH(new BilingualeSpracheKatalogEintrag[]{new BilingualeSpracheKatalogEintrag(1000L, ZulaessigesFach.E, Arrays.asList(Schulform.BK, Schulform.SB, Schulform.G, Schulform.GE, Schulform.GY, Schulform.GM, Schulform.R, Schulform.SG, Schulform.SK, Schulform.SR), null, 2022), new BilingualeSpracheKatalogEintrag(1001L, ZulaessigesFach.E, Arrays.asList(Schulform.BK, Schulform.SB, Schulform.G, Schulform.GE, Schulform.GY, Schulform.R, Schulform.SG, Schulform.SK, Schulform.SR), 2023, null)}),
    FRANZOESISCH(new BilingualeSpracheKatalogEintrag[]{new BilingualeSpracheKatalogEintrag(2000L, ZulaessigesFach.F, Arrays.asList(Schulform.BK, Schulform.SB, Schulform.G, Schulform.GE, Schulform.GY, Schulform.GM, Schulform.R, Schulform.SG, Schulform.SK, Schulform.SR), null, 2022), new BilingualeSpracheKatalogEintrag(2001L, ZulaessigesFach.F, Arrays.asList(Schulform.BK, Schulform.SB, Schulform.G, Schulform.GE, Schulform.GY, Schulform.R, Schulform.SG, Schulform.SK, Schulform.SR), 2023, null)}),
    ITALIENISCH(new BilingualeSpracheKatalogEintrag[]{new BilingualeSpracheKatalogEintrag(3000L, ZulaessigesFach.I, Arrays.asList(Schulform.BK, Schulform.SB, Schulform.G, Schulform.GE, Schulform.GY, Schulform.GM, Schulform.R, Schulform.SG, Schulform.SK, Schulform.SR), null, 2022), new BilingualeSpracheKatalogEintrag(3001L, ZulaessigesFach.I, Arrays.asList(Schulform.BK, Schulform.SB, Schulform.G, Schulform.GE, Schulform.GY, Schulform.R, Schulform.SG, Schulform.SK, Schulform.SR), 2023, null)}),
    NIEDERLAENDISCH(new BilingualeSpracheKatalogEintrag[]{new BilingualeSpracheKatalogEintrag(4000L, ZulaessigesFach.N, Arrays.asList(Schulform.BK, Schulform.SB, Schulform.G, Schulform.GE, Schulform.GY, Schulform.GM, Schulform.R, Schulform.SG, Schulform.SK, Schulform.SR), null, 2022), new BilingualeSpracheKatalogEintrag(4001L, ZulaessigesFach.N, Arrays.asList(Schulform.BK, Schulform.SB, Schulform.G, Schulform.GE, Schulform.GY, Schulform.R, Schulform.SG, Schulform.SK, Schulform.SR), 2023, null)}),
    SPANISCH(new BilingualeSpracheKatalogEintrag[]{new BilingualeSpracheKatalogEintrag(5000L, ZulaessigesFach.S, Arrays.asList(Schulform.BK, Schulform.SB, Schulform.G, Schulform.GE, Schulform.GY, Schulform.GM, Schulform.R, Schulform.SG, Schulform.SK, Schulform.SR), null, 2022), new BilingualeSpracheKatalogEintrag(5001L, ZulaessigesFach.S, Arrays.asList(Schulform.BK, Schulform.SB, Schulform.G, Schulform.GE, Schulform.GY, Schulform.R, Schulform.SG, Schulform.SK, Schulform.SR), 2023, null)}),
    TUERKISCH(new BilingualeSpracheKatalogEintrag[]{new BilingualeSpracheKatalogEintrag(6000L, ZulaessigesFach.T, Arrays.asList(Schulform.BK, Schulform.SB, Schulform.G, Schulform.GE, Schulform.GY, Schulform.GM, Schulform.R, Schulform.SG, Schulform.SK, Schulform.SR), null, 2022), new BilingualeSpracheKatalogEintrag(6001L, ZulaessigesFach.T, Arrays.asList(Schulform.BK, Schulform.SB, Schulform.G, Schulform.GE, Schulform.GY, Schulform.R, Schulform.SG, Schulform.SK, Schulform.SR), 2023, null)}),
    NEUGRIECHIESCH(new BilingualeSpracheKatalogEintrag[]{new BilingualeSpracheKatalogEintrag(7000L, ZulaessigesFach.Z, Arrays.asList(Schulform.BK, Schulform.SB, Schulform.G, Schulform.GE, Schulform.GY, Schulform.GM, Schulform.R, Schulform.SG, Schulform.SK, Schulform.SR), null, 2022), new BilingualeSpracheKatalogEintrag(7001L, ZulaessigesFach.Z, Arrays.asList(Schulform.BK, Schulform.SB, Schulform.G, Schulform.GE, Schulform.GY, Schulform.R, Schulform.SG, Schulform.SK, Schulform.SR), 2023, null)});

    public static final long VERSION = 2L;
    @NotNull
    public final BilingualeSpracheKatalogEintrag daten;
    @NotNull
    public final @NotNull BilingualeSpracheKatalogEintrag @NotNull [] historie;
    @NotNull
    private static final @NotNull HashMap<@NotNull Long, @NotNull BilingualeSpracheKatalogEintrag> _mapEintragByID;
    @NotNull
    private static final @NotNull HashMap<@NotNull Long, @NotNull BilingualeSprache> _mapByID;
    @NotNull
    private static final @NotNull HashMap<@NotNull String, @NotNull BilingualeSprache> _mapByKuerzel;
    @NotNull
    private @NotNull ArrayList<@NotNull Schulform> @NotNull [] schulformen;

    private BilingualeSprache(BilingualeSpracheKatalogEintrag[] historie) {
        this.historie = historie;
        this.daten = historie[historie.length - 1];
        this.schulformen = (ArrayList[])Array.newInstance(ArrayList.class, historie.length);
        for (int i = 0; i < historie.length; ++i) {
            this.schulformen[i] = new ArrayList();
            for (String kuerzel : historie[i].schulformen) {
                Schulform sf = Schulform.getByKuerzel(kuerzel);
                if (sf == null) continue;
                this.schulformen[i].add(sf);
            }
        }
    }

    @NotNull
    private static @NotNull HashMap<@NotNull Long, @NotNull BilingualeSpracheKatalogEintrag> getMapEintragByID() {
        if (_mapEintragByID.size() == 0) {
            for (BilingualeSprache s : BilingualeSprache.values()) {
                for (BilingualeSpracheKatalogEintrag k : s.historie) {
                    _mapEintragByID.put(k.id, k);
                }
            }
        }
        return _mapEintragByID;
    }

    @NotNull
    private static @NotNull HashMap<@NotNull Long, @NotNull BilingualeSprache> getMapByID() {
        if (_mapByID.size() == 0) {
            for (BilingualeSprache s : BilingualeSprache.values()) {
                _mapByID.put(s.daten.id, s);
            }
        }
        return _mapByID;
    }

    @NotNull
    private static @NotNull HashMap<@NotNull String, @NotNull BilingualeSprache> getMapByKuerzel() {
        if (_mapByKuerzel.size() == 0) {
            for (BilingualeSprache s : BilingualeSprache.values()) {
                _mapByKuerzel.put(s.daten.kuerzel, s);
            }
        }
        return _mapByKuerzel;
    }

    @NotNull
    public @NotNull List<@NotNull Schulform> getSchulformen() {
        return this.schulformen[this.historie.length - 1];
    }

    private boolean hasSchulform(Schulform schulform) {
        if (schulform == null || schulform.daten == null) {
            return false;
        }
        if (this.daten.schulformen != null) {
            for (int i = 0; i < this.daten.schulformen.size(); ++i) {
                String sfKuerzel = this.daten.schulformen.get(i);
                if (!sfKuerzel.equals(schulform.daten.kuerzel)) continue;
                return true;
            }
        }
        return false;
    }

    public static BilingualeSpracheKatalogEintrag getKatalogEintragByID(long id) {
        return BilingualeSprache.getMapEintragByID().get(id);
    }

    public static BilingualeSprache getByID(long id) {
        return BilingualeSprache.getMapByID().get(id);
    }

    public static BilingualeSprache getByKuerzel(String kuerzel) {
        return BilingualeSprache.getMapByKuerzel().get(kuerzel);
    }

    @NotNull
    public static @NotNull List<@NotNull BilingualeSprache> get(Schulform schulform) {
        @NotNull ArrayList<@NotNull BilingualeSprache> faecher = new ArrayList<BilingualeSprache>();
        if (schulform == null) {
            return faecher;
        }
        @NotNull BilingualeSprache @NotNull [] fachgruppen = BilingualeSprache.values();
        for (int i = 0; i < fachgruppen.length; ++i) {
            BilingualeSprache fg = fachgruppen[i];
            if (!fg.hasSchulform(schulform)) continue;
            faecher.add(fg);
        }
        return faecher;
    }

    static {
        _mapEintragByID = new HashMap();
        _mapByID = new HashMap();
        _mapByKuerzel = new HashMap();
    }
}

