/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.types.fach;

import de.svws_nrw.core.data.RGBFarbe;
import de.svws_nrw.core.data.fach.FachgruppenKatalogEintrag;
import de.svws_nrw.core.types.schule.Schulform;
import jakarta.validation.constraints.NotNull;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public enum Fachgruppe {
    FG_D(new FachgruppenKatalogEintrag[]{new FachgruppenKatalogEintrag(1L, 1, 110, "Deutsch", "D", new RGBFarbe(253, 233, 217), Arrays.asList(Schulform.BK, Schulform.SB, Schulform.FW, Schulform.HI, Schulform.WF, Schulform.G, Schulform.GE, Schulform.GY, Schulform.H, Schulform.PS, Schulform.R, Schulform.KS, Schulform.S, Schulform.SG, Schulform.SK, Schulform.SR, Schulform.V, Schulform.WB), 0, true, null, null)}),
    FG_AL(new FachgruppenKatalogEintrag[]{new FachgruppenKatalogEintrag(2L, 2, 400, "Arbeitslehre", "AL", new RGBFarbe(253, 221, 195), Arrays.asList(Schulform.BK, Schulform.SB, Schulform.FW, Schulform.HI, Schulform.WF, Schulform.G, Schulform.GE, Schulform.GY, Schulform.H, Schulform.PS, Schulform.R, Schulform.KS, Schulform.S, Schulform.SG, Schulform.SK, Schulform.SR, Schulform.V, Schulform.WB), 12, true, null, null)}),
    FG_FS(new FachgruppenKatalogEintrag[]{new FachgruppenKatalogEintrag(3L, 2, 100, "Fremdsprachen", "FS", new RGBFarbe(253, 221, 195), Arrays.asList(Schulform.BK, Schulform.SB, Schulform.FW, Schulform.HI, Schulform.WF, Schulform.G, Schulform.GE, Schulform.GY, Schulform.H, Schulform.PS, Schulform.R, Schulform.KS, Schulform.S, Schulform.SG, Schulform.SK, Schulform.SR, Schulform.V, Schulform.WB), 9, true, null, null)}),
    FG_MS(new FachgruppenKatalogEintrag[]{new FachgruppenKatalogEintrag(4L, 3, 500, "Kunst und Musik", "MS", new RGBFarbe(252, 204, 165), Arrays.asList(Schulform.BK, Schulform.SB, Schulform.FW, Schulform.HI, Schulform.WF, Schulform.G, Schulform.GE, Schulform.GY, Schulform.H, Schulform.PS, Schulform.R, Schulform.KS, Schulform.S, Schulform.SG, Schulform.SK, Schulform.SR, Schulform.V, Schulform.WB), 13, true, null, null)}),
    FG_ME(new FachgruppenKatalogEintrag[]{new FachgruppenKatalogEintrag(5L, 4, null, "Literatur, instrumental- oder vokalpraktischer Kurs", "ME", new RGBFarbe(252, 204, 165), Arrays.asList(Schulform.BK, Schulform.SB, Schulform.GE, Schulform.GY, Schulform.SG, Schulform.WB), 13, false, null, null)}),
    FG_GS(new FachgruppenKatalogEintrag[]{new FachgruppenKatalogEintrag(6L, 5, 300, "Gesellschaftswissenschaft", "GS", new RGBFarbe(234, 241, 222), Arrays.asList(Schulform.BK, Schulform.SB, Schulform.FW, Schulform.HI, Schulform.WF, Schulform.G, Schulform.GE, Schulform.GY, Schulform.H, Schulform.PS, Schulform.R, Schulform.KS, Schulform.S, Schulform.SG, Schulform.SK, Schulform.SR, Schulform.V, Schulform.WB), 11, true, null, null)}),
    FG_PL(new FachgruppenKatalogEintrag[]{new FachgruppenKatalogEintrag(7L, 5, null, "Philosophie", "PL", new RGBFarbe(234, 241, 222), Arrays.asList(Schulform.BK, Schulform.SB, Schulform.GE, Schulform.GY, Schulform.SG, Schulform.WB), 11, false, null, null)}),
    FG_RE(new FachgruppenKatalogEintrag[]{new FachgruppenKatalogEintrag(8L, 6, 900, "Religion", "RE", new RGBFarbe(215, 228, 188), Arrays.asList(Schulform.BK, Schulform.SB, Schulform.FW, Schulform.HI, Schulform.WF, Schulform.G, Schulform.GE, Schulform.GY, Schulform.H, Schulform.PS, Schulform.R, Schulform.KS, Schulform.S, Schulform.SG, Schulform.SK, Schulform.SR, Schulform.V, Schulform.WB), 6, true, null, null)}),
    FG_M(new FachgruppenKatalogEintrag[]{new FachgruppenKatalogEintrag(9L, 7, 700, "Mathematik", "M", new RGBFarbe(197, 217, 241), Arrays.asList(Schulform.BK, Schulform.SB, Schulform.FW, Schulform.HI, Schulform.WF, Schulform.G, Schulform.GE, Schulform.GY, Schulform.H, Schulform.PS, Schulform.R, Schulform.KS, Schulform.S, Schulform.SG, Schulform.SK, Schulform.SR, Schulform.V, Schulform.WB), 15, true, null, null)}),
    FG_NW(new FachgruppenKatalogEintrag[]{new FachgruppenKatalogEintrag(10L, 8, 200, "Naturwissenschaften", "NW", new RGBFarbe(141, 180, 227), Arrays.asList(Schulform.BK, Schulform.SB, Schulform.FW, Schulform.HI, Schulform.WF, Schulform.G, Schulform.GE, Schulform.GY, Schulform.H, Schulform.PS, Schulform.R, Schulform.KS, Schulform.S, Schulform.SG, Schulform.SK, Schulform.SR, Schulform.V, Schulform.WB), 10, true, null, null)}),
    FG_WN(new FachgruppenKatalogEintrag[]{new FachgruppenKatalogEintrag(11L, 8, null, "weiteres naturwissenschaftliches / technisches Fach", "WN", new RGBFarbe(141, 180, 227), Arrays.asList(Schulform.BK, Schulform.SB, Schulform.GE, Schulform.GY, Schulform.SG, Schulform.WB), 10, false, null, null)}),
    FG_SP(new FachgruppenKatalogEintrag[]{new FachgruppenKatalogEintrag(12L, 9, 600, "Sport", "SP", new RGBFarbe(224, 211, 229), Arrays.asList(Schulform.BK, Schulform.SB, Schulform.FW, Schulform.HI, Schulform.WF, Schulform.G, Schulform.GE, Schulform.GY, Schulform.H, Schulform.PS, Schulform.R, Schulform.KS, Schulform.S, Schulform.SG, Schulform.SK, Schulform.SR, Schulform.V, Schulform.WB), 14, true, null, null)}),
    FG_VX(new FachgruppenKatalogEintrag[]{new FachgruppenKatalogEintrag(13L, 10, 1500, "Vertiefungskurs", "VX", new RGBFarbe(216, 216, 216), Arrays.asList(Schulform.BK, Schulform.SB, Schulform.GE, Schulform.GY, Schulform.SG, Schulform.WB), 0, false, null, null)}),
    FG_PX(new FachgruppenKatalogEintrag[]{new FachgruppenKatalogEintrag(14L, 11, 1600, "Projektkurs", "PX", new RGBFarbe(191, 191, 191), Arrays.asList(Schulform.BK, Schulform.SB, Schulform.GE, Schulform.GY, Schulform.SG, Schulform.WB), 0, false, null, null)}),
    FG_BUE(new FachgruppenKatalogEintrag[]{new FachgruppenKatalogEintrag(15L, null, 10, "Berufs\u00fcbergreifender Bereich", "BUE", new RGBFarbe(), Arrays.asList(Schulform.BK, Schulform.SB), 1, false, null, null)}),
    FG_BBS(new FachgruppenKatalogEintrag[]{new FachgruppenKatalogEintrag(16L, null, 20, "Berufsbezogener Bereich", "BBS", new RGBFarbe(), Arrays.asList(Schulform.BK, Schulform.SB), 2, false, null, null)}),
    FG_BBS_SCHWERPUNKT(new FachgruppenKatalogEintrag[]{new FachgruppenKatalogEintrag(17L, null, 25, "Berufsbezogener Bereich (Schwerpunkt)", "BBS", new RGBFarbe(), Arrays.asList(Schulform.BK, Schulform.SB), 0, false, null, null)}),
    FG_DF(new FachgruppenKatalogEintrag[]{new FachgruppenKatalogEintrag(18L, null, 30, "Differenzierungsbereich", "DF", new RGBFarbe(), Arrays.asList(Schulform.BK, Schulform.SB), 3, false, null, null)}),
    FG_BP(new FachgruppenKatalogEintrag[]{new FachgruppenKatalogEintrag(19L, null, 40, "Berufspraktikum", "BP", new RGBFarbe(), Arrays.asList(Schulform.BK, Schulform.SB), 4, false, null, null)}),
    FG_BLL(new FachgruppenKatalogEintrag[]{new FachgruppenKatalogEintrag(20L, null, 60, "besondere Lernleistung", "BLL", new RGBFarbe(), Arrays.asList(Schulform.GE, Schulform.GY, Schulform.SG, Schulform.WB), 8, false, null, null)}),
    FG_WP(new FachgruppenKatalogEintrag[]{new FachgruppenKatalogEintrag(21L, null, 800, "Wahlpflichtbereich", "WP", new RGBFarbe(), Arrays.asList(Schulform.BK, Schulform.SB, Schulform.FW, Schulform.HI, Schulform.WF, Schulform.G, Schulform.GE, Schulform.GY, Schulform.H, Schulform.PS, Schulform.R, Schulform.KS, Schulform.S, Schulform.SG, Schulform.SK, Schulform.SR, Schulform.V, Schulform.WB), 16, false, null, null)}),
    FG_ZUV(new FachgruppenKatalogEintrag[]{new FachgruppenKatalogEintrag(22L, null, 1000, "Zus\u00e4tzliche Unterrichtsveranstaltungen", "ZUV", new RGBFarbe(), Arrays.asList(Schulform.BK, Schulform.SB, Schulform.FW, Schulform.HI, Schulform.WF, Schulform.G, Schulform.GE, Schulform.GY, Schulform.H, Schulform.PS, Schulform.R, Schulform.KS, Schulform.S, Schulform.SG, Schulform.SK, Schulform.SR, Schulform.V, Schulform.WB), 0, false, null, null)}),
    FG_ANG(new FachgruppenKatalogEintrag[]{new FachgruppenKatalogEintrag(23L, null, 1100, "Angleichungskurse", "ANG", new RGBFarbe(), Arrays.asList(Schulform.BK, Schulform.SB, Schulform.FW, Schulform.HI, Schulform.WF, Schulform.G, Schulform.GE, Schulform.GY, Schulform.H, Schulform.PS, Schulform.R, Schulform.KS, Schulform.S, Schulform.SG, Schulform.SK, Schulform.SR, Schulform.V, Schulform.WB), 0, false, null, null)}),
    FG_D_SP(new FachgruppenKatalogEintrag[]{new FachgruppenKatalogEintrag(24L, null, 1200, "Sprache", "D_SP", new RGBFarbe(), Arrays.asList(Schulform.G, Schulform.KS, Schulform.S, Schulform.V), 0, true, null, null)}),
    FG_SU(new FachgruppenKatalogEintrag[]{new FachgruppenKatalogEintrag(25L, null, 1300, "Sachunterricht", "SU", new RGBFarbe(), Arrays.asList(Schulform.G, Schulform.KS, Schulform.S, Schulform.V), 0, true, null, null)}),
    FG_FOE(new FachgruppenKatalogEintrag[]{new FachgruppenKatalogEintrag(26L, null, 1400, "F\u00f6rderunterricht", "FOE", new RGBFarbe(), Arrays.asList(Schulform.G, Schulform.KS, Schulform.S, Schulform.V), 0, true, null, null)}),
    FG_ABA(new FachgruppenKatalogEintrag[]{new FachgruppenKatalogEintrag(27L, null, 1700, "Abschlussarbeit", "ABA", new RGBFarbe(), Arrays.asList(Schulform.BK, Schulform.SB), 0, false, null, null)}),
    FG_PA(new FachgruppenKatalogEintrag[]{new FachgruppenKatalogEintrag(28L, null, 1800, "Projektarbeit", "PA", new RGBFarbe(), Arrays.asList(Schulform.BK, Schulform.SB), 0, false, null, null)}),
    FG_IF(new FachgruppenKatalogEintrag[]{new FachgruppenKatalogEintrag(29L, null, 1900, "Informatik (Sek I)", "IF", new RGBFarbe(141, 180, 227), Arrays.asList(Schulform.BK, Schulform.SB, Schulform.FW, Schulform.HI, Schulform.WF, Schulform.G, Schulform.GE, Schulform.GY, Schulform.H, Schulform.PS, Schulform.R, Schulform.KS, Schulform.S, Schulform.SG, Schulform.SK, Schulform.SR, Schulform.V, Schulform.WB), 10, true, null, null)});

    public static final long VERSION = 1L;
    @NotNull
    public final FachgruppenKatalogEintrag daten;
    @NotNull
    public final @NotNull FachgruppenKatalogEintrag @NotNull [] historie;
    @NotNull
    private static final @NotNull HashMap<@NotNull Long, @NotNull FachgruppenKatalogEintrag> _mapEintragByID;
    @NotNull
    private static final @NotNull HashMap<@NotNull Long, @NotNull Fachgruppe> _mapByID;
    @NotNull
    private static final @NotNull HashMap<@NotNull String, @NotNull Fachgruppe> _mapByKuerzel;
    @NotNull
    private @NotNull ArrayList<@NotNull Schulform> @NotNull [] schulformen;

    private Fachgruppe(FachgruppenKatalogEintrag[] historie) {
        this.historie = historie;
        this.daten = historie[historie.length - 1];
        this.schulformen = (ArrayList[])Array.newInstance(ArrayList.class, historie.length);
        for (int i = 0; i < historie.length; ++i) {
            this.schulformen[i] = new ArrayList();
            for (String kuerzel : historie[i].schulformen) {
                Schulform sf = Schulform.getByKuerzel(kuerzel);
                if (sf == null) continue;
                this.schulformen[i].add(sf);
            }
        }
    }

    @NotNull
    private static @NotNull HashMap<@NotNull Long, @NotNull FachgruppenKatalogEintrag> getMapEintragByID() {
        if (_mapEintragByID.size() == 0) {
            for (Fachgruppe g : Fachgruppe.values()) {
                for (FachgruppenKatalogEintrag k : g.historie) {
                    _mapEintragByID.put(k.id, k);
                }
            }
        }
        return _mapEintragByID;
    }

    @NotNull
    private static @NotNull HashMap<@NotNull Long, @NotNull Fachgruppe> getMapByID() {
        if (_mapByID.size() == 0) {
            for (Fachgruppe g : Fachgruppe.values()) {
                _mapByID.put(g.daten.id, g);
            }
        }
        return _mapByID;
    }

    @NotNull
    private static @NotNull HashMap<@NotNull String, @NotNull Fachgruppe> getMapByKuerzel() {
        if (_mapByKuerzel.size() == 0) {
            for (Fachgruppe g : Fachgruppe.values()) {
                _mapByKuerzel.put(g.daten.kuerzel, g);
            }
        }
        return _mapByKuerzel;
    }

    @NotNull
    public @NotNull List<@NotNull Schulform> getSchulformen() {
        return this.schulformen[this.historie.length - 1];
    }

    private boolean hasSchulform(Schulform schulform) {
        if (schulform == null || schulform.daten == null) {
            return false;
        }
        if (this.daten.schulformen != null) {
            for (int i = 0; i < this.daten.schulformen.size(); ++i) {
                String sfKuerzel = this.daten.schulformen.get(i);
                if (!sfKuerzel.equals(schulform.daten.kuerzel)) continue;
                return true;
            }
        }
        return false;
    }

    public static FachgruppenKatalogEintrag getKatalogEintragByID(long id) {
        return Fachgruppe.getMapEintragByID().get(id);
    }

    public static Fachgruppe getByID(long id) {
        return Fachgruppe.getMapByID().get(id);
    }

    public static Fachgruppe getByKuerzel(String kuerzel) {
        return Fachgruppe.getMapByKuerzel().get(kuerzel);
    }

    @NotNull
    public static @NotNull List<@NotNull Fachgruppe> get(Schulform schulform) {
        @NotNull ArrayList<@NotNull Fachgruppe> faecher = new ArrayList<Fachgruppe>();
        if (schulform == null) {
            return faecher;
        }
        @NotNull Fachgruppe @NotNull [] fachgruppen = Fachgruppe.values();
        for (int i = 0; i < fachgruppen.length; ++i) {
            Fachgruppe fg = fachgruppen[i];
            if (!fg.hasSchulform(schulform)) continue;
            faecher.add(fg);
        }
        return faecher;
    }

    static {
        _mapEintragByID = new HashMap();
        _mapByID = new HashMap();
        _mapByKuerzel = new HashMap();
    }
}

