/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.types.fach;

import jakarta.validation.constraints.NotNull;

public enum SprachBelegungSekI {
    NICHT_BELEGT(0),
    MIND_2_JAHRE(2),
    MIND_4_JAHRE(4),
    AB_JAHRGANG_5(6);

    public final int dauer;

    private SprachBelegungSekI(int dauer) {
        this.dauer = dauer;
    }

    @NotNull
    public static SprachBelegungSekI getByASDJahrgang(String kuerzel) {
        if (kuerzel == null) {
            return NICHT_BELEGT;
        }
        if (kuerzel.compareTo("05") <= 0) {
            return AB_JAHRGANG_5;
        }
        if (kuerzel.compareTo("07") <= 0) {
            return MIND_4_JAHRE;
        }
        if (kuerzel.compareTo("09") <= 0) {
            return MIND_2_JAHRE;
        }
        return NICHT_BELEGT;
    }

    @NotNull
    public static SprachBelegungSekI getByDauer(int dauer) {
        if (dauer <= 0) {
            return NICHT_BELEGT;
        }
        if (dauer <= 3) {
            return MIND_2_JAHRE;
        }
        if (dauer <= 4) {
            return MIND_4_JAHRE;
        }
        return AB_JAHRGANG_5;
    }
}

