/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.types.fach;

import de.svws_nrw.core.data.fach.SprachreferenzniveauKatalogEintrag;
import jakarta.validation.constraints.NotNull;
import java.util.HashMap;

public enum Sprachreferenzniveau {
    A1(new SprachreferenzniveauKatalogEintrag[]{new SprachreferenzniveauKatalogEintrag(1, "A1", null, null)}),
    A1P(new SprachreferenzniveauKatalogEintrag[]{new SprachreferenzniveauKatalogEintrag(2, "A1+", null, null)}),
    A1A2(new SprachreferenzniveauKatalogEintrag[]{new SprachreferenzniveauKatalogEintrag(3, "A1/A2", null, null)}),
    A2(new SprachreferenzniveauKatalogEintrag[]{new SprachreferenzniveauKatalogEintrag(4, "A2", null, null)}),
    A2P(new SprachreferenzniveauKatalogEintrag[]{new SprachreferenzniveauKatalogEintrag(5, "A2+", null, null)}),
    A2B1(new SprachreferenzniveauKatalogEintrag[]{new SprachreferenzniveauKatalogEintrag(6, "A2/B1", null, null)}),
    B1(new SprachreferenzniveauKatalogEintrag[]{new SprachreferenzniveauKatalogEintrag(7, "B1", null, null)}),
    B1P(new SprachreferenzniveauKatalogEintrag[]{new SprachreferenzniveauKatalogEintrag(8, "B1+", null, null)}),
    B1B2(new SprachreferenzniveauKatalogEintrag[]{new SprachreferenzniveauKatalogEintrag(9, "B1/B2", null, null)}),
    B2(new SprachreferenzniveauKatalogEintrag[]{new SprachreferenzniveauKatalogEintrag(10, "B2", null, null)}),
    B2C1(new SprachreferenzniveauKatalogEintrag[]{new SprachreferenzniveauKatalogEintrag(11, "B2/C1", null, null)}),
    C1(new SprachreferenzniveauKatalogEintrag[]{new SprachreferenzniveauKatalogEintrag(12, "C1", null, null)}),
    C2(new SprachreferenzniveauKatalogEintrag[]{new SprachreferenzniveauKatalogEintrag(13, "C2", null, null)});

    public static final long VERSION = 1L;
    @NotNull
    public final SprachreferenzniveauKatalogEintrag daten;
    @NotNull
    public final @NotNull SprachreferenzniveauKatalogEintrag @NotNull [] historie;
    @NotNull
    private static final @NotNull HashMap<@NotNull Integer, @NotNull Sprachreferenzniveau> _mapID;
    @NotNull
    private static final @NotNull HashMap<@NotNull String, @NotNull Sprachreferenzniveau> _mapKuerzel;

    private Sprachreferenzniveau(SprachreferenzniveauKatalogEintrag[] historie) {
        this.historie = historie;
        this.daten = historie[historie.length - 1];
    }

    @NotNull
    private static @NotNull HashMap<@NotNull Integer, @NotNull Sprachreferenzniveau> getMapByID() {
        if (_mapID.size() == 0) {
            for (Sprachreferenzniveau l : Sprachreferenzniveau.values()) {
                _mapID.put(l.daten.id, l);
            }
        }
        return _mapID;
    }

    @NotNull
    private static @NotNull HashMap<@NotNull String, @NotNull Sprachreferenzniveau> getMapByKuerzel() {
        if (_mapKuerzel.size() == 0) {
            for (Sprachreferenzniveau l : Sprachreferenzniveau.values()) {
                _mapKuerzel.put(l.daten.kuerzel, l);
            }
        }
        return _mapKuerzel;
    }

    public static Sprachreferenzniveau getByID(Integer id) {
        return Sprachreferenzniveau.getMapByID().get(id);
    }

    public static Sprachreferenzniveau getByKuerzel(String kuerzel) {
        return Sprachreferenzniveau.getMapByKuerzel().get(kuerzel);
    }

    public int vergleiche(String kuerzel) {
        Sprachreferenzniveau other = Sprachreferenzniveau.getByKuerzel(kuerzel);
        if (other == null) {
            return 1;
        }
        return this.compareTo(other);
    }

    static {
        _mapID = new HashMap();
        _mapKuerzel = new HashMap();
    }
}

