/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.types.gost;

import jakarta.validation.constraints.NotNull;

public enum AbiturBelegungsart {
    NICHT_BELEGT("-", "nicht belegt"),
    MUENDLICH("M", "m\u00fcndlich"),
    SCHRIFTLICH("S", "schriftlich");

    @NotNull
    public String kuerzel;
    @NotNull
    public String beschreibung;

    private AbiturBelegungsart(String kuerzel, String beschreibung) {
        this.kuerzel = kuerzel;
        this.beschreibung = beschreibung;
    }

    public static AbiturBelegungsart fromKuerzel(String kuerzel) {
        if (kuerzel == null) {
            return NICHT_BELEGT;
        }
        switch (kuerzel) {
            case "-": {
                return NICHT_BELEGT;
            }
            case "M": {
                return MUENDLICH;
            }
            case "S": {
                return SCHRIFTLICH;
            }
        }
        return null;
    }

    @NotNull
    public String toString() {
        return this.kuerzel;
    }
}

