/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.types.gost;

import jakarta.validation.constraints.NotNull;

public enum GostAbiturFach {
    LK1(1, "LK1", "1. Leistungskurs"),
    LK2(2, "LK2", "2. Leistungskurs"),
    AB3(3, "AB3", "3. Abiturfach (GK, schriftlich)"),
    AB4(4, "AB4", "4. Abiturfach (GK, m\u00fcndlich)");

    public final int id;
    @NotNull
    public final String kuerzel;
    @NotNull
    public final String beschreibung;

    private GostAbiturFach(@NotNull int id, String kuerzel, String beschreibung) {
        this.id = id;
        this.kuerzel = kuerzel;
        this.beschreibung = beschreibung;
    }

    public static GostAbiturFach fromID(Integer id) {
        if (id == null) {
            return null;
        }
        switch (id) {
            case 1: {
                return LK1;
            }
            case 2: {
                return LK2;
            }
            case 3: {
                return AB3;
            }
            case 4: {
                return AB4;
            }
        }
        return null;
    }

    public static GostAbiturFach fromIDString(String strID) {
        if (strID == null) {
            return null;
        }
        switch (strID) {
            case "1": {
                return LK1;
            }
            case "2": {
                return LK2;
            }
            case "3": {
                return AB3;
            }
            case "4": {
                return AB4;
            }
        }
        return null;
    }

    public static GostAbiturFach fromKuerzel(String kuerzel) {
        switch (kuerzel) {
            case "LK1": {
                return LK1;
            }
            case "LK2": {
                return LK2;
            }
            case "AB3": {
                return AB3;
            }
            case "AB4": {
                return AB4;
            }
        }
        return null;
    }

    @NotNull
    public String toString() {
        return this.kuerzel;
    }
}

