/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.types.gost;

import com.fasterxml.jackson.annotation.JsonIgnore;
import jakarta.validation.constraints.NotNull;

public enum GostBesondereLernleistung {
    KEINE("K", "Keine"),
    PROJEKTKURS("P", "Projektkurs ist besondere Lernleistung"),
    EXTERNE("E", "externe besondere Lernleistung");

    @NotNull
    public final String kuerzel;
    @NotNull
    public final String beschreibung;

    private GostBesondereLernleistung(String kuerzel, String beschreibung) {
        this.kuerzel = kuerzel;
        this.beschreibung = beschreibung;
    }

    @NotNull
    public static GostBesondereLernleistung fromKuerzel(String kuerzel) {
        if (kuerzel == null) {
            return KEINE;
        }
        switch (kuerzel) {
            case "K": {
                return KEINE;
            }
            case "P": {
                return PROJEKTKURS;
            }
            case "E": {
                return EXTERNE;
            }
        }
        return KEINE;
    }

    @NotNull
    public String toString() {
        return this.kuerzel;
    }

    @JsonIgnore
    public boolean is(String kuerzel) {
        return this.kuerzel.equals(kuerzel);
    }
}

