/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.types.gost;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.svws_nrw.core.adt.map.ArrayMap;
import de.svws_nrw.core.data.gost.GostFach;
import de.svws_nrw.core.types.fach.ZulaessigesFach;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public enum GostFachbereich {
    DEUTSCH(null, ZulaessigesFach.D),
    FREMDSPRACHE(null, ZulaessigesFach.C, ZulaessigesFach.C0, ZulaessigesFach.C5, ZulaessigesFach.C6, ZulaessigesFach.C7, ZulaessigesFach.C8, ZulaessigesFach.C9, ZulaessigesFach.E, ZulaessigesFach.F, ZulaessigesFach.F0, ZulaessigesFach.F5, ZulaessigesFach.F6, ZulaessigesFach.F7, ZulaessigesFach.F8, ZulaessigesFach.F9, ZulaessigesFach.G, ZulaessigesFach.G0, ZulaessigesFach.G5, ZulaessigesFach.G6, ZulaessigesFach.G7, ZulaessigesFach.G8, ZulaessigesFach.G9, ZulaessigesFach.H, ZulaessigesFach.H0, ZulaessigesFach.H5, ZulaessigesFach.H6, ZulaessigesFach.H7, ZulaessigesFach.H8, ZulaessigesFach.H9, ZulaessigesFach.I, ZulaessigesFach.I0, ZulaessigesFach.I5, ZulaessigesFach.I6, ZulaessigesFach.I7, ZulaessigesFach.I8, ZulaessigesFach.I9, ZulaessigesFach.K, ZulaessigesFach.K0, ZulaessigesFach.K5, ZulaessigesFach.K6, ZulaessigesFach.K7, ZulaessigesFach.K8, ZulaessigesFach.K9, ZulaessigesFach.L, ZulaessigesFach.L0, ZulaessigesFach.L5, ZulaessigesFach.L6, ZulaessigesFach.L7, ZulaessigesFach.L8, ZulaessigesFach.L9, ZulaessigesFach.N, ZulaessigesFach.N0, ZulaessigesFach.N5, ZulaessigesFach.N6, ZulaessigesFach.N7, ZulaessigesFach.N8, ZulaessigesFach.N9, ZulaessigesFach.O, ZulaessigesFach.O0, ZulaessigesFach.O5, ZulaessigesFach.O6, ZulaessigesFach.O7, ZulaessigesFach.O8, ZulaessigesFach.O9, ZulaessigesFach.R, ZulaessigesFach.R0, ZulaessigesFach.R5, ZulaessigesFach.R6, ZulaessigesFach.R7, ZulaessigesFach.R8, ZulaessigesFach.R9, ZulaessigesFach.S, ZulaessigesFach.S0, ZulaessigesFach.S5, ZulaessigesFach.S6, ZulaessigesFach.S7, ZulaessigesFach.S8, ZulaessigesFach.S9, ZulaessigesFach.T, ZulaessigesFach.T0, ZulaessigesFach.T5, ZulaessigesFach.T6, ZulaessigesFach.T7, ZulaessigesFach.T8, ZulaessigesFach.T9, ZulaessigesFach.Z, ZulaessigesFach.Z0, ZulaessigesFach.Z5, ZulaessigesFach.Z6, ZulaessigesFach.Z7, ZulaessigesFach.Z8, ZulaessigesFach.Z9),
    KUNST_MUSIK(null, ZulaessigesFach.KU, ZulaessigesFach.MU),
    LITERARISCH_KUENSTLERISCH_ERSATZ(null, ZulaessigesFach.LI, ZulaessigesFach.IN, ZulaessigesFach.VO),
    LITERARISCH_KUENSTLERISCH(Arrays.asList(KUNST_MUSIK, LITERARISCH_KUENSTLERISCH_ERSATZ), new ZulaessigesFach[0]),
    SPRACHLICH_LITERARISCH_KUENSTLERISCH(Arrays.asList(DEUTSCH, FREMDSPRACHE, KUNST_MUSIK, LITERARISCH_KUENSTLERISCH_ERSATZ), new ZulaessigesFach[0]),
    GESCHICHTE(null, ZulaessigesFach.GE),
    SOZIALWISSENSCHAFTEN(null, ZulaessigesFach.SW),
    PHILOSOPHIE(null, ZulaessigesFach.PL),
    GESELLSCHAFTSWISSENSCHAFTLICH_SONSTIGE(null, ZulaessigesFach.EK, ZulaessigesFach.PA, ZulaessigesFach.PS, ZulaessigesFach.RK),
    GESELLSCHAFTSWISSENSCHAFTLICH(Arrays.asList(GESCHICHTE, SOZIALWISSENSCHAFTEN, PHILOSOPHIE, GESELLSCHAFTSWISSENSCHAFTLICH_SONSTIGE), new ZulaessigesFach[0]),
    RELIGION(null, ZulaessigesFach.HR, ZulaessigesFach.OR, ZulaessigesFach.YR, ZulaessigesFach.ER, ZulaessigesFach.KR, ZulaessigesFach.IL),
    GESELLSCHAFTSWISSENSCHAFTLICH_MIT_RELIGION(Arrays.asList(GESCHICHTE, SOZIALWISSENSCHAFTEN, PHILOSOPHIE, GESELLSCHAFTSWISSENSCHAFTLICH_SONSTIGE, RELIGION), new ZulaessigesFach[0]),
    MATHEMATIK(null, ZulaessigesFach.M),
    NATURWISSENSCHAFTLICH_KLASSISCH(null, ZulaessigesFach.BI, ZulaessigesFach.CH, ZulaessigesFach.PH),
    NATURWISSENSCHAFTLICH_NEU_EINSETZEND(null, ZulaessigesFach.EL, ZulaessigesFach.IF, ZulaessigesFach.TC),
    NATURWISSENSCHAFTLICH(Arrays.asList(NATURWISSENSCHAFTLICH_KLASSISCH, NATURWISSENSCHAFTLICH_NEU_EINSETZEND), new ZulaessigesFach[0]),
    MATHEMATISCH_NATURWISSENSCHAFTLICH(Arrays.asList(MATHEMATIK, NATURWISSENSCHAFTLICH_KLASSISCH, NATURWISSENSCHAFTLICH_NEU_EINSETZEND), new ZulaessigesFach[0]),
    SPORT(null, ZulaessigesFach.SP);

    @NotNull
    private static final @NotNull Map<@NotNull ZulaessigesFach, @NotNull List<@NotNull GostFachbereich>> _mapFachbereichByFach;
    @NotNull
    private final @NotNull ArrayList<@NotNull ZulaessigesFach> faecher = new ArrayList();
    @NotNull
    private final @NotNull ArrayList<@NotNull String> kuerzel = new ArrayList();

    private GostFachbereich(List<GostFachbereich> fachbereiche, ZulaessigesFach ... faecher) {
        if (fachbereiche != null) {
            for (GostFachbereich fb : fachbereiche) {
                for (ZulaessigesFach zulaessigesFach : fb.faecher) {
                    this.faecher.add(zulaessigesFach);
                    this.kuerzel.add(zulaessigesFach.daten.kuerzelASD);
                }
            }
        }
        for (ZulaessigesFach zulaessigesFach : faecher) {
            this.faecher.add(zulaessigesFach);
            this.kuerzel.add(zulaessigesFach.daten.kuerzelASD);
        }
    }

    @NotNull
    private static @NotNull Map<@NotNull ZulaessigesFach, @NotNull List<@NotNull GostFachbereich>> getMapFachbereichByFach() {
        if (_mapFachbereichByFach.size() == 0) {
            for (GostFachbereich fb : GostFachbereich.values()) {
                for (ZulaessigesFach fach : fb.faecher) {
                    List<@NotNull GostFachbereich> listFachbereichByFach = _mapFachbereichByFach.get((Object)fach);
                    if (listFachbereichByFach == null) {
                        listFachbereichByFach = new ArrayList<GostFachbereich>();
                        _mapFachbereichByFach.put(fach, listFachbereichByFach);
                    }
                    listFachbereichByFach.add(fb);
                }
            }
        }
        return _mapFachbereichByFach;
    }

    @NotNull
    public @NotNull List<@NotNull ZulaessigesFach> getFaecher() {
        return this.faecher;
    }

    @JsonIgnore
    public boolean hat(GostFach fach) {
        return fach != null && this.hat(fach.kuerzel);
    }

    @JsonIgnore
    public boolean hat(String kuerzel) {
        if (kuerzel == null) {
            return false;
        }
        return this.kuerzel.contains(kuerzel);
    }

    @NotNull
    public static @NotNull List<@NotNull GostFachbereich> getBereiche(GostFach fach) {
        if (fach == null) {
            return new ArrayList<GostFachbereich>();
        }
        @NotNull ZulaessigesFach zulFach = ZulaessigesFach.getByKuerzelASD(fach.kuerzel);
        List<@NotNull GostFachbereich> bereiche = GostFachbereich.getMapFachbereichByFach().get((Object)zulFach);
        if (bereiche != null) {
            return bereiche;
        }
        return new ArrayList<GostFachbereich>();
    }

    static {
        _mapFachbereichByFach = new ArrayMap<ZulaessigesFach, List<GostFachbereich>>(ZulaessigesFach.values());
    }
}

