/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.types.gost;

import com.fasterxml.jackson.annotation.JsonIgnore;
import jakarta.validation.constraints.NotNull;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public enum GostHalbjahr {
    EF1(0, "EF", 1, "EF.1", "E1", "Einf\u00fchrungsphase 1. Halbjahr"),
    EF2(1, "EF", 2, "EF.2", "E2", "Einf\u00fchrungsphase 2. Halbjahr"),
    Q11(2, "Q1", 1, "Q1.1", "Q1", "Qualifikationsphase 1. Jahr, 1. Halbjahr"),
    Q12(3, "Q1", 2, "Q1.2", "Q2", "Qualifikationsphase 1. Jahr, 2. Halbjahr"),
    Q21(4, "Q2", 1, "Q2.1", "Q3", "Qualifikationsphase 2. Jahr, 1. Halbjahr"),
    Q22(5, "Q2", 2, "Q2.2", "Q4", "Qualifikationsphase 2. Jahr, 2. Halbjahr");

    @NotNull
    private static final @NotNull HashMap<@NotNull Integer, @NotNull GostHalbjahr> _mapID;
    @NotNull
    private static final @NotNull HashMap<@NotNull String, @NotNull GostHalbjahr> _mapKuerzel;
    @NotNull
    private static final @NotNull HashMap<@NotNull String, @NotNull GostHalbjahr> _mapKuerzelAlt;
    public static final int maxHalbjahre = 6;
    public final int id;
    @NotNull
    public final String jahrgang;
    public final int halbjahr;
    @NotNull
    public final String kuerzel;
    @NotNull
    public final String kuerzelAlt;
    @NotNull
    public final String beschreibung;

    private GostHalbjahr(int id, @NotNull String jahrgang, @NotNull int halbjahr, @NotNull String kuerzel, String kuerzelAlt, String beschreibung) {
        this.id = id;
        this.jahrgang = jahrgang;
        this.halbjahr = halbjahr;
        this.kuerzel = kuerzel;
        this.kuerzelAlt = kuerzelAlt;
        this.beschreibung = beschreibung;
    }

    @NotNull
    private static @NotNull HashMap<@NotNull Integer, @NotNull GostHalbjahr> getMapByID() {
        if (_mapID.size() == 0) {
            for (GostHalbjahr h : GostHalbjahr.values()) {
                _mapID.put(h.id, h);
            }
        }
        return _mapID;
    }

    @NotNull
    private static @NotNull HashMap<@NotNull String, @NotNull GostHalbjahr> getMapByKuerzel() {
        if (_mapKuerzel.size() == 0) {
            for (GostHalbjahr h : GostHalbjahr.values()) {
                _mapKuerzel.put(h.kuerzel, h);
            }
        }
        return _mapKuerzel;
    }

    @NotNull
    private static @NotNull HashMap<@NotNull String, @NotNull GostHalbjahr> getMapByKuerzelAlt() {
        if (_mapKuerzelAlt.size() == 0) {
            for (GostHalbjahr h : GostHalbjahr.values()) {
                _mapKuerzelAlt.put(h.kuerzelAlt, h);
            }
        }
        return _mapKuerzelAlt;
    }

    @JsonIgnore
    public GostHalbjahr next() {
        return GostHalbjahr.getMapByID().get(this.id + 1);
    }

    @JsonIgnore
    @NotNull
    public GostHalbjahr nextOrException() {
        GostHalbjahr hj = GostHalbjahr.getMapByID().get(this.id + 1);
        if (hj == null) {
            throw new NullPointerException();
        }
        return hj;
    }

    @JsonIgnore
    public GostHalbjahr previous() {
        return GostHalbjahr.getMapByID().get(this.id - 1);
    }

    @JsonIgnore
    @NotNull
    public GostHalbjahr previousOrException() {
        GostHalbjahr hj = GostHalbjahr.getMapByID().get(this.id - 1);
        if (hj == null) {
            throw new NullPointerException();
        }
        return hj;
    }

    @NotNull
    public @NotNull GostHalbjahr @NotNull [] getSchuljahr() {
        if (this.id % 2 == 0) {
            @NotNull GostHalbjahr @NotNull [] hjs = new GostHalbjahr[]{this, this.nextOrException()};
            return hjs;
        }
        @NotNull GostHalbjahr @NotNull [] hjs = new GostHalbjahr[]{this.previousOrException(), this};
        return hjs;
    }

    @NotNull
    public static @NotNull GostHalbjahr @NotNull [] getEinfuehrungsphase() {
        @NotNull GostHalbjahr @NotNull [] ef = new GostHalbjahr[]{EF1, EF2};
        return ef;
    }

    @NotNull
    public static @NotNull GostHalbjahr @NotNull [] getQualifikationsphase() {
        @NotNull GostHalbjahr @NotNull [] q = new GostHalbjahr[]{Q11, Q12, Q21, Q22};
        return q;
    }

    @NotNull
    public static @NotNull GostHalbjahr @NotNull [] getHalbjahreFromJahrgang(@NotNull String jahrgang) {
        switch (jahrgang) {
            case "EF": {
                @NotNull GostHalbjahr @NotNull [] ef = new GostHalbjahr[]{EF1, EF2};
                return ef;
            }
            case "Q1": {
                GostHalbjahr[] q1 = new GostHalbjahr[]{Q11, Q12};
                return q1;
            }
            case "Q2": {
                GostHalbjahr[] q2 = new GostHalbjahr[]{Q21, Q22};
                return q2;
            }
        }
        throw new IllegalArgumentException("Der angegebene Jahrgang ist kein g\u00fcltiger Jahrgang der gymnasialen Oberstufe");
    }

    public static GostHalbjahr fromID(Integer id) {
        if (id == null) {
            return null;
        }
        switch (id) {
            case 0: {
                return EF1;
            }
            case 1: {
                return EF2;
            }
            case 2: {
                return Q11;
            }
            case 3: {
                return Q12;
            }
            case 4: {
                return Q21;
            }
            case 5: {
                return Q22;
            }
        }
        return null;
    }

    @NotNull
    public static GostHalbjahr fromIDorException(int pGostHalbjahID) throws NullPointerException {
        GostHalbjahr halbjahr = GostHalbjahr.fromID(pGostHalbjahID);
        if (halbjahr == null) {
            throw new NullPointerException("GostHalbjahr nicht gefunden!");
        }
        return halbjahr;
    }

    public static GostHalbjahr fromKuerzel(String kuerzel) {
        return GostHalbjahr.getMapByKuerzel().get(kuerzel);
    }

    public static GostHalbjahr fromKuerzelAlt(String kuerzelAlt) {
        return GostHalbjahr.getMapByKuerzelAlt().get(kuerzelAlt);
    }

    public static GostHalbjahr fromJahrgangUndHalbjahr(String jahrgang, int halbjahr) {
        if (halbjahr != 1 && halbjahr != 2) {
            return null;
        }
        switch (jahrgang) {
            case "EF": {
                return halbjahr == 1 ? EF1 : EF2;
            }
            case "Q1": {
                return halbjahr == 1 ? Q11 : Q12;
            }
            case "Q2": {
                return halbjahr == 1 ? Q21 : Q22;
            }
        }
        return null;
    }

    public static GostHalbjahr fromAbiturjahrSchuljahrUndHalbjahr(int abiturjahr, int schuljahr, int halbjahr) {
        int id = (schuljahr + 3 - abiturjahr) * 2 + halbjahr - 1;
        return GostHalbjahr.fromID(id);
    }

    public static GostHalbjahr getPlanungshalbjahrFromAbiturjahrSchuljahrUndHalbjahr(int abiturjahr, int schuljahr, int halbjahr) {
        int id = (schuljahr + 3 - abiturjahr) * 2 + halbjahr;
        if (id < 0) {
            id = 0;
        }
        return GostHalbjahr.fromID(id);
    }

    public int getAbiturjahrFromSchuljahr(int schuljahr) {
        return schuljahr + 3 - this.id / 2;
    }

    public int getSchuljahrFromAbiturjahr(int abiturjahr) {
        return abiturjahr - 3 + this.id / 2;
    }

    @JsonIgnore
    public boolean istEinfuehrungsphase() {
        return "EF".equals(this.jahrgang);
    }

    @JsonIgnore
    public boolean istQualifikationsphase() {
        return !this.istEinfuehrungsphase();
    }

    public static boolean pruefeEinfuehrungsphase(GostHalbjahr ... halbjahre) {
        if (halbjahre == null || halbjahre.length != 2) {
            return false;
        }
        return halbjahre[0] == EF1 && halbjahre[0] == EF2 || halbjahre[0] == EF2 && halbjahre[0] == EF1;
    }

    public static boolean pruefeQualifikationsphase(GostHalbjahr ... halbjahre) {
        if (halbjahre == null || halbjahre.length != 4) {
            return false;
        }
        @NotNull List<@NotNull GostHalbjahr> list = Arrays.asList(halbjahre);
        return list.contains((Object)Q11) && list.contains((Object)Q12) && list.contains((Object)Q21) && list.contains((Object)Q22);
    }

    static {
        _mapID = new HashMap();
        _mapKuerzel = new HashMap();
        _mapKuerzelAlt = new HashMap();
    }
}

