/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.types.gost;

import de.svws_nrw.core.adt.map.ArrayMap;
import de.svws_nrw.core.data.gost.GostBlockungKurs;
import de.svws_nrw.core.data.gost.GostFachwahl;
import de.svws_nrw.core.exceptions.DeveloperNotificationException;
import de.svws_nrw.core.types.kurse.ZulaessigeKursart;
import jakarta.validation.constraints.NotNull;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum GostKursart {
    LK(1, "LK", "Leistungskurs", Arrays.asList(ZulaessigeKursart.LK1, ZulaessigeKursart.LK2)),
    GK(2, "GK", "Grundkurs", Arrays.asList(ZulaessigeKursart.GKM, ZulaessigeKursart.GKS, ZulaessigeKursart.AB3, ZulaessigeKursart.AB4, ZulaessigeKursart.EFSP)),
    ZK(3, "ZK", "Zusatzkurs", Arrays.asList(ZulaessigeKursart.ZK)),
    PJK(4, "PJK", "Projektkurs", Arrays.asList(ZulaessigeKursart.PJK)),
    VTF(5, "VTF", "Vertiefungskurs", Arrays.asList(ZulaessigeKursart.VTF));

    private static final long FACHART_ID_FAKTOR = 1000L;
    @NotNull
    private static final @NotNull HashMap<@NotNull String, @NotNull GostKursart> _mapKuerzel;
    @NotNull
    private static final @NotNull Map<@NotNull ZulaessigeKursart, @NotNull GostKursart> _mapZulKursart;
    @NotNull
    public final int id;
    @NotNull
    public final String kuerzel;
    @NotNull
    public final String beschreibung;
    @NotNull
    private final @NotNull List<@NotNull ZulaessigeKursart> kursarten;

    private GostKursart(@NotNull int id, @NotNull /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @NotNull @NotNull String kuerzel, String beschreibung, List<ZulaessigeKursart> kursarten) {
        this.id = id;
        this.kuerzel = kuerzel;
        this.beschreibung = beschreibung;
        this.kursarten = kursarten;
    }

    public boolean pruefeWochenstunden(int anzahl) {
        switch (this.kuerzel) {
            case "GK": {
                return anzahl == 3 || anzahl == 4;
            }
            case "LK": {
                return anzahl == 5;
            }
            case "PJK": {
                return anzahl == 2 || anzahl == 3;
            }
            case "VTF": {
                return anzahl == 2;
            }
            case "ZK": {
                return anzahl == 3;
            }
        }
        return false;
    }

    public int getWochenstunden(boolean istFSNeu) {
        switch (this.kuerzel) {
            case "GK": {
                return istFSNeu ? 4 : 3;
            }
            case "LK": {
                return 5;
            }
            case "PJK": {
                return 2;
            }
            case "VTF": {
                return 2;
            }
            case "ZK": {
                return 3;
            }
        }
        return 3;
    }

    @NotNull
    private static @NotNull HashMap<@NotNull String, @NotNull GostKursart> getMapByKuerzel() {
        if (_mapKuerzel.size() == 0) {
            for (GostKursart k : GostKursart.values()) {
                _mapKuerzel.put(k.kuerzel, k);
            }
        }
        return _mapKuerzel;
    }

    @NotNull
    private static @NotNull Map<@NotNull ZulaessigeKursart, @NotNull GostKursart> getMapByZulKursart() {
        if (_mapZulKursart.size() == 0) {
            for (GostKursart k : GostKursart.values()) {
                for (ZulaessigeKursart zulKursart : k.kursarten) {
                    _mapZulKursart.put(zulKursart, k);
                }
            }
        }
        return _mapZulKursart;
    }

    @NotNull
    public @NotNull List<@NotNull ZulaessigeKursart> getKursarten() {
        return this.kursarten;
    }

    @NotNull
    public static GostKursart fromID(int id) throws DeveloperNotificationException {
        switch (id) {
            case 1: {
                return LK;
            }
            case 2: {
                return GK;
            }
            case 3: {
                return ZK;
            }
            case 4: {
                return PJK;
            }
            case 5: {
                return VTF;
            }
        }
        throw new DeveloperNotificationException("Invalid ID value.");
    }

    @NotNull
    public static GostKursart fromFachwahlOrException(@NotNull GostFachwahl pFachwahl) throws DeveloperNotificationException {
        return GostKursart.fromID(pFachwahl.kursartID);
    }

    public static GostKursart fromIDorNull(int id) {
        switch (id) {
            case 1: {
                return LK;
            }
            case 2: {
                return GK;
            }
            case 3: {
                return ZK;
            }
            case 4: {
                return PJK;
            }
            case 5: {
                return VTF;
            }
        }
        return null;
    }

    public static GostKursart fromKuerzel(String kuerzel) {
        return GostKursart.getMapByKuerzel().get(kuerzel);
    }

    @NotNull
    public static GostKursart fromKuerzelOrException(String kuerzel) {
        GostKursart gk = GostKursart.getMapByKuerzel().get(kuerzel);
        if (gk == null) {
            throw new DeveloperNotificationException("Invalid value for kurzel: " + kuerzel);
        }
        return gk;
    }

    public static GostKursart fromKursart(ZulaessigeKursart kursart) {
        return GostKursart.getMapByZulKursart().get((Object)kursart);
    }

    public static long getFachartID(long pFachID, int pKursartID) {
        return pFachID * 1000L + (long)pKursartID;
    }

    public static long getFachartIDByFachwahl(@NotNull GostFachwahl pFachwahl) {
        return GostKursart.getFachartID(pFachwahl.fachID, pFachwahl.kursartID);
    }

    public static long getFachartIDByKurs(@NotNull GostBlockungKurs pKurs) {
        return GostKursart.getFachartID(pKurs.fach_id, pKurs.kursart);
    }

    public static long getFachID(long pFachartID) {
        return pFachartID / 1000L;
    }

    public static int getKursartID(long pFachartID) {
        return (int)(pFachartID % 1000L);
    }

    @NotNull
    public String toString() {
        return this.kuerzel;
    }

    static {
        _mapKuerzel = new HashMap();
        _mapZulKursart = new ArrayMap<ZulaessigeKursart, GostKursart>(ZulaessigeKursart.values());
    }
}

