/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.types.jahrgang;

import de.svws_nrw.core.data.jahrgang.JahrgangsKatalogEintrag;
import de.svws_nrw.core.data.jahrgang.JahrgangsKatalogEintragBezeichnung;
import de.svws_nrw.core.types.schule.Schulform;
import de.svws_nrw.core.types.schule.Schulgliederung;
import jakarta.validation.constraints.NotNull;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public enum Jahrgaenge {
    JG_00(new JahrgangsKatalogEintrag[]{new JahrgangsKatalogEintrag(0L, "00", Arrays.asList(new JahrgangsKatalogEintragBezeichnung(Schulform.S, "Fr\u00fchkindliche F\u00f6rderung, F\u00f6rderschulkindergarten"), new JahrgangsKatalogEintragBezeichnung(Schulform.KS, "Fr\u00fchkindliche F\u00f6rderung, F\u00f6rderschulkindergarten")), null, null)}),
    JG_90(new JahrgangsKatalogEintrag[]{new JahrgangsKatalogEintrag(4090000000L, "90", Arrays.asList(new JahrgangsKatalogEintragBezeichnung(Schulform.KS, "Hausfr\u00fcherziehung f\u00fcr H\u00f6r- bzw. Sehgesch\u00e4digte"), new JahrgangsKatalogEintragBezeichnung(Schulform.S, "Hausfr\u00fcherziehung f\u00fcr H\u00f6r- bzw. Sehgesch\u00e4digte")), null, null)}),
    JG_E1(new JahrgangsKatalogEintrag[]{new JahrgangsKatalogEintrag(1101000000L, "E1", Arrays.asList(new JahrgangsKatalogEintragBezeichnung(Schulform.FW, "Schuleingangsphase, 1. Schulbesuchsjahr"), new JahrgangsKatalogEintragBezeichnung(Schulform.HI, "Schuleingangsphase, 1. Schulbesuchsjahr"), new JahrgangsKatalogEintragBezeichnung(Schulform.WF, "Schuleingangsphase, 1. Schulbesuchsjahr"), new JahrgangsKatalogEintragBezeichnung(Schulform.G, "Schuleingangsphase, 1. Schulbesuchsjahr"), new JahrgangsKatalogEintragBezeichnung(Schulform.PS, "Schuleingangsphase, 1. Schulbesuchsjahr"), new JahrgangsKatalogEintragBezeichnung(Schulform.S, "Schuleingangsphase, 1. Schulbesuchsjahr"), new JahrgangsKatalogEintragBezeichnung(Schulform.KS, "Schuleingangsphase, 1. Schulbesuchsjahr"), new JahrgangsKatalogEintragBezeichnung(Schulform.V, "Schuleingangsphase, 1. Schulbesuchsjahr")), null, null)}),
    JG_E2(new JahrgangsKatalogEintrag[]{new JahrgangsKatalogEintrag(1102000000L, "E2", Arrays.asList(new JahrgangsKatalogEintragBezeichnung(Schulform.FW, "Schuleingangsphase, 2. Schulbesuchsjahr"), new JahrgangsKatalogEintragBezeichnung(Schulform.HI, "Schuleingangsphase, 2. Schulbesuchsjahr"), new JahrgangsKatalogEintragBezeichnung(Schulform.WF, "Schuleingangsphase, 2. Schulbesuchsjahr"), new JahrgangsKatalogEintragBezeichnung(Schulform.G, "Schuleingangsphase, 2. Schulbesuchsjahr"), new JahrgangsKatalogEintragBezeichnung(Schulform.PS, "Schuleingangsphase, 2. Schulbesuchsjahr"), new JahrgangsKatalogEintragBezeichnung(Schulform.S, "Schuleingangsphase, 2. Schulbesuchsjahr"), new JahrgangsKatalogEintragBezeichnung(Schulform.KS, "Schuleingangsphase, 2. Schulbesuchsjahr"), new JahrgangsKatalogEintragBezeichnung(Schulform.V, "Schuleingangsphase, 2. Schulbesuchsjahr")), null, null)}),
    JG_E3(new JahrgangsKatalogEintrag[]{new JahrgangsKatalogEintrag(1103000000L, "E3", Arrays.asList(new JahrgangsKatalogEintragBezeichnung(Schulform.FW, "Schuleingangsphase, 3. Schulbesuchsjahr"), new JahrgangsKatalogEintragBezeichnung(Schulform.HI, "Schuleingangsphase, 3. Schulbesuchsjahr"), new JahrgangsKatalogEintragBezeichnung(Schulform.WF, "Schuleingangsphase, 3. Schulbesuchsjahr"), new JahrgangsKatalogEintragBezeichnung(Schulform.G, "Schuleingangsphase, 3. Schulbesuchsjahr"), new JahrgangsKatalogEintragBezeichnung(Schulform.PS, "Schuleingangsphase, 3. Schulbesuchsjahr"), new JahrgangsKatalogEintragBezeichnung(Schulform.S, "Schuleingangsphase, 3. Schulbesuchsjahr"), new JahrgangsKatalogEintragBezeichnung(Schulform.KS, "Schuleingangsphase, 3. Schulbesuchsjahr"), new JahrgangsKatalogEintragBezeichnung(Schulform.V, "Schuleingangsphase, 3. Schulbesuchsjahr")), null, null)}),
    JG_91(new JahrgangsKatalogEintrag[]{new JahrgangsKatalogEintrag(4091000000L, "91", Arrays.asList(new JahrgangsKatalogEintragBezeichnung(Schulform.WB, "Vorkurs / 1. Semester")), null, null)}),
    JG_92(new JahrgangsKatalogEintrag[]{new JahrgangsKatalogEintrag(4092000000L, "92", Arrays.asList(new JahrgangsKatalogEintragBezeichnung(Schulform.WB, "Vorkurs / 2. Semester")), null, null)}),
    JG_01(new JahrgangsKatalogEintrag[]{new JahrgangsKatalogEintrag(1001000000L, "01", Arrays.asList(new JahrgangsKatalogEintragBezeichnung(Schulform.BK, "1. Jahrgang dieser Schulgliederung"), new JahrgangsKatalogEintragBezeichnung(Schulform.SB, "1. Jahrgang dieser Schulgliederung"), new JahrgangsKatalogEintragBezeichnung(Schulform.HI, "1. Semester (Seiteneinsteiger)"), new JahrgangsKatalogEintragBezeichnung(Schulform.WB, "1. Semester (Einf\u00fchrungs-/Hauptphase)")), null, null)}),
    JG_02(new JahrgangsKatalogEintrag[]{new JahrgangsKatalogEintrag(1002000000L, "02", Arrays.asList(new JahrgangsKatalogEintragBezeichnung(Schulform.BK, "2. Jahrgang dieser Schulgliederung"), new JahrgangsKatalogEintragBezeichnung(Schulform.SB, "2. Jahrgang dieser Schulgliederung"), new JahrgangsKatalogEintragBezeichnung(Schulform.HI, "2. Semester (Seiteneinsteiger)"), new JahrgangsKatalogEintragBezeichnung(Schulform.WB, "2. Semester (Einf\u00fchrungs-/Hauptphase)")), null, null)}),
    JG_03(new JahrgangsKatalogEintrag[]{new JahrgangsKatalogEintrag(1003000000L, "03", Arrays.asList(new JahrgangsKatalogEintragBezeichnung(Schulform.BK, "3. Jahrgang dieser Schulgliederung"), new JahrgangsKatalogEintragBezeichnung(Schulform.SB, "3. Jahrgang dieser Schulgliederung"), new JahrgangsKatalogEintragBezeichnung(Schulform.HI, "3. Jahrgang / 3. Semester"), new JahrgangsKatalogEintragBezeichnung(Schulform.WB, "3. Semester (Einf\u00fchrungs-/Hauptphase)"), new JahrgangsKatalogEintragBezeichnung(Schulform.FW, "3. Jahrgang"), new JahrgangsKatalogEintragBezeichnung(Schulform.WF, "3. Jahrgang"), new JahrgangsKatalogEintragBezeichnung(Schulform.G, "3. Jahrgang"), new JahrgangsKatalogEintragBezeichnung(Schulform.PS, "3. Jahrgang"), new JahrgangsKatalogEintragBezeichnung(Schulform.KS, "3. Jahrgang"), new JahrgangsKatalogEintragBezeichnung(Schulform.S, "3. Jahrgang"), new JahrgangsKatalogEintragBezeichnung(Schulform.V, "3. Jahrgang")), null, null)}),
    JG_04(new JahrgangsKatalogEintrag[]{new JahrgangsKatalogEintrag(1004000000L, "04", Arrays.asList(new JahrgangsKatalogEintragBezeichnung(Schulform.BK, "4. Jahrgang dieser Schulgliederung"), new JahrgangsKatalogEintragBezeichnung(Schulform.SB, "4. Jahrgang dieser Schulgliederung"), new JahrgangsKatalogEintragBezeichnung(Schulform.HI, "4. Jahrgang / 4. Semester"), new JahrgangsKatalogEintragBezeichnung(Schulform.WB, "4. Semester (Einf\u00fchrungs-/Hauptphase)"), new JahrgangsKatalogEintragBezeichnung(Schulform.FW, "4. Jahrgang"), new JahrgangsKatalogEintragBezeichnung(Schulform.WF, "4. Jahrgang"), new JahrgangsKatalogEintragBezeichnung(Schulform.G, "4. Jahrgang"), new JahrgangsKatalogEintragBezeichnung(Schulform.PS, "4. Jahrgang"), new JahrgangsKatalogEintragBezeichnung(Schulform.KS, "4. Jahrgang"), new JahrgangsKatalogEintragBezeichnung(Schulform.S, "4. Jahrgang"), new JahrgangsKatalogEintragBezeichnung(Schulform.V, "4. Jahrgang")), null, null)}),
    JG_05(new JahrgangsKatalogEintrag[]{new JahrgangsKatalogEintrag(2005000000L, "05", Arrays.asList(new JahrgangsKatalogEintragBezeichnung(Schulform.BK, "5. Jahrgang dieser Schulgliederung"), new JahrgangsKatalogEintragBezeichnung(Schulform.SB, "5. Jahrgang dieser Schulgliederung"), new JahrgangsKatalogEintragBezeichnung(Schulform.HI, "5. Jahrgang / 5. Semester"), new JahrgangsKatalogEintragBezeichnung(Schulform.WB, "5. Semester (Qualifikationsphase)"), new JahrgangsKatalogEintragBezeichnung(Schulform.FW, "5. Jahrgang"), new JahrgangsKatalogEintragBezeichnung(Schulform.WF, "5. Jahrgang"), new JahrgangsKatalogEintragBezeichnung(Schulform.PS, "5. Jahrgang"), new JahrgangsKatalogEintragBezeichnung(Schulform.KS, "5. Jahrgang"), new JahrgangsKatalogEintragBezeichnung(Schulform.S, "5. Jahrgang"), new JahrgangsKatalogEintragBezeichnung(Schulform.V, "5. Jahrgang"), new JahrgangsKatalogEintragBezeichnung(Schulform.GE, "5. Jahrgang"), new JahrgangsKatalogEintragBezeichnung(Schulform.GM, "5. Jahrgang"), new JahrgangsKatalogEintragBezeichnung(Schulform.GY, "5. Jahrgang"), new JahrgangsKatalogEintragBezeichnung(Schulform.H, "5. Jahrgang"), new JahrgangsKatalogEintragBezeichnung(Schulform.R, "5. Jahrgang"), new JahrgangsKatalogEintragBezeichnung(Schulform.SG, "5. Jahrgang"), new JahrgangsKatalogEintragBezeichnung(Schulform.SK, "5. Jahrgang"), new JahrgangsKatalogEintragBezeichnung(Schulform.SR, "5. Jahrgang")), null, null)}),
    JG_06(new JahrgangsKatalogEintrag[]{new JahrgangsKatalogEintrag(2006000000L, "06", Arrays.asList(new JahrgangsKatalogEintragBezeichnung(Schulform.BK, "6. Jahrgang dieser Schulgliederung"), new JahrgangsKatalogEintragBezeichnung(Schulform.SB, "6. Jahrgang dieser Schulgliederung"), new JahrgangsKatalogEintragBezeichnung(Schulform.HI, "6. Jahrgang / 6. Semester"), new JahrgangsKatalogEintragBezeichnung(Schulform.WB, "6. Semester (Qualifikationsphase)"), new JahrgangsKatalogEintragBezeichnung(Schulform.FW, "6. Jahrgang"), new JahrgangsKatalogEintragBezeichnung(Schulform.WF, "6. Jahrgang"), new JahrgangsKatalogEintragBezeichnung(Schulform.PS, "6. Jahrgang"), new JahrgangsKatalogEintragBezeichnung(Schulform.KS, "6. Jahrgang"), new JahrgangsKatalogEintragBezeichnung(Schulform.S, "6. Jahrgang"), new JahrgangsKatalogEintragBezeichnung(Schulform.V, "6. Jahrgang"), new JahrgangsKatalogEintragBezeichnung(Schulform.GE, "6. Jahrgang"), new JahrgangsKatalogEintragBezeichnung(Schulform.GM, "6. Jahrgang"), new JahrgangsKatalogEintragBezeichnung(Schulform.GY, "6. Jahrgang"), new JahrgangsKatalogEintragBezeichnung(Schulform.H, "6. Jahrgang"), new JahrgangsKatalogEintragBezeichnung(Schulform.R, "6. Jahrgang"), new JahrgangsKatalogEintragBezeichnung(Schulform.SG, "6. Jahrgang"), new JahrgangsKatalogEintragBezeichnung(Schulform.SK, "6. Jahrgang"), new JahrgangsKatalogEintragBezeichnung(Schulform.SR, "6. Jahrgang")), null, null)}),
    JG_07(new JahrgangsKatalogEintrag[]{new JahrgangsKatalogEintrag(2007000000L, "07", Arrays.asList(new JahrgangsKatalogEintragBezeichnung(Schulform.HI, "7. Jahrgang"), new JahrgangsKatalogEintragBezeichnung(Schulform.FW, "7. Jahrgang"), new JahrgangsKatalogEintragBezeichnung(Schulform.WF, "7. Jahrgang"), new JahrgangsKatalogEintragBezeichnung(Schulform.PS, "7. Jahrgang"), new JahrgangsKatalogEintragBezeichnung(Schulform.KS, "7. Jahrgang"), new JahrgangsKatalogEintragBezeichnung(Schulform.S, "7. Jahrgang"), new JahrgangsKatalogEintragBezeichnung(Schulform.V, "7. Jahrgang"), new JahrgangsKatalogEintragBezeichnung(Schulform.GE, "7. Jahrgang"), new JahrgangsKatalogEintragBezeichnung(Schulform.GM, "7. Jahrgang"), new JahrgangsKatalogEintragBezeichnung(Schulform.GY, "7. Jahrgang"), new JahrgangsKatalogEintragBezeichnung(Schulform.H, "7. Jahrgang"), new JahrgangsKatalogEintragBezeichnung(Schulform.R, "7. Jahrgang"), new JahrgangsKatalogEintragBezeichnung(Schulform.SG, "7. Jahrgang"), new JahrgangsKatalogEintragBezeichnung(Schulform.SK, "7. Jahrgang"), new JahrgangsKatalogEintragBezeichnung(Schulform.SR, "7. Jahrgang")), null, null)}),
    JG_08(new JahrgangsKatalogEintrag[]{new JahrgangsKatalogEintrag(2008000000L, "08", Arrays.asList(new JahrgangsKatalogEintragBezeichnung(Schulform.HI, "8. Jahrgang"), new JahrgangsKatalogEintragBezeichnung(Schulform.FW, "8. Jahrgang"), new JahrgangsKatalogEintragBezeichnung(Schulform.WF, "8. Jahrgang"), new JahrgangsKatalogEintragBezeichnung(Schulform.PS, "8. Jahrgang"), new JahrgangsKatalogEintragBezeichnung(Schulform.KS, "8. Jahrgang"), new JahrgangsKatalogEintragBezeichnung(Schulform.S, "8. Jahrgang"), new JahrgangsKatalogEintragBezeichnung(Schulform.V, "8. Jahrgang"), new JahrgangsKatalogEintragBezeichnung(Schulform.GE, "8. Jahrgang"), new JahrgangsKatalogEintragBezeichnung(Schulform.GM, "8. Jahrgang"), new JahrgangsKatalogEintragBezeichnung(Schulform.GY, "8. Jahrgang"), new JahrgangsKatalogEintragBezeichnung(Schulform.H, "8. Jahrgang"), new JahrgangsKatalogEintragBezeichnung(Schulform.R, "8. Jahrgang"), new JahrgangsKatalogEintragBezeichnung(Schulform.SG, "8. Jahrgang"), new JahrgangsKatalogEintragBezeichnung(Schulform.SK, "8. Jahrgang"), new JahrgangsKatalogEintragBezeichnung(Schulform.SR, "8. Jahrgang")), null, null)}),
    JG_09(new JahrgangsKatalogEintrag[]{new JahrgangsKatalogEintrag(2009000000L, "09", Arrays.asList(new JahrgangsKatalogEintragBezeichnung(Schulform.HI, "9. Jahrgang"), new JahrgangsKatalogEintragBezeichnung(Schulform.FW, "9. Jahrgang"), new JahrgangsKatalogEintragBezeichnung(Schulform.WF, "9. Jahrgang"), new JahrgangsKatalogEintragBezeichnung(Schulform.PS, "9. Jahrgang"), new JahrgangsKatalogEintragBezeichnung(Schulform.KS, "9. Jahrgang"), new JahrgangsKatalogEintragBezeichnung(Schulform.S, "9. Jahrgang"), new JahrgangsKatalogEintragBezeichnung(Schulform.V, "9. Jahrgang"), new JahrgangsKatalogEintragBezeichnung(Schulform.GE, "9. Jahrgang"), new JahrgangsKatalogEintragBezeichnung(Schulform.GM, "9. Jahrgang"), new JahrgangsKatalogEintragBezeichnung(Schulform.GY, "9. Jahrgang"), new JahrgangsKatalogEintragBezeichnung(Schulform.H, "9. Jahrgang"), new JahrgangsKatalogEintragBezeichnung(Schulform.R, "9. Jahrgang"), new JahrgangsKatalogEintragBezeichnung(Schulform.SG, "9. Jahrgang"), new JahrgangsKatalogEintragBezeichnung(Schulform.SK, "9. Jahrgang"), new JahrgangsKatalogEintragBezeichnung(Schulform.SR, "9. Jahrgang"), new JahrgangsKatalogEintragBezeichnung(Schulform.SB, "9. Jahrgang dieser Schulgliederung")), null, null)}),
    JG_10(new JahrgangsKatalogEintrag[]{new JahrgangsKatalogEintrag(2010000000L, "10", Arrays.asList(new JahrgangsKatalogEintragBezeichnung(Schulform.HI, "10. Jahrgang"), new JahrgangsKatalogEintragBezeichnung(Schulform.FW, "10. Jahrgang"), new JahrgangsKatalogEintragBezeichnung(Schulform.WF, "10. Jahrgang"), new JahrgangsKatalogEintragBezeichnung(Schulform.PS, "10. Jahrgang"), new JahrgangsKatalogEintragBezeichnung(Schulform.KS, "10. Jahrgang"), new JahrgangsKatalogEintragBezeichnung(Schulform.S, "10. Jahrgang"), new JahrgangsKatalogEintragBezeichnung(Schulform.V, "10. Jahrgang"), new JahrgangsKatalogEintragBezeichnung(Schulform.GE, "10. Jahrgang"), new JahrgangsKatalogEintragBezeichnung(Schulform.GM, "10. Jahrgang"), new JahrgangsKatalogEintragBezeichnung(Schulform.GY, "10. Jahrgang"), new JahrgangsKatalogEintragBezeichnung(Schulform.H, "10. Jahrgang"), new JahrgangsKatalogEintragBezeichnung(Schulform.R, "10. Jahrgang"), new JahrgangsKatalogEintragBezeichnung(Schulform.SG, "10. Jahrgang"), new JahrgangsKatalogEintragBezeichnung(Schulform.SK, "10. Jahrgang"), new JahrgangsKatalogEintragBezeichnung(Schulform.SR, "10. Jahrgang"), new JahrgangsKatalogEintragBezeichnung(Schulform.SB, "10. Jahrgang dieser Schulgliederung")), null, null)}),
    JG_11(new JahrgangsKatalogEintrag[]{new JahrgangsKatalogEintrag(2011000000L, "11", Arrays.asList(new JahrgangsKatalogEintragBezeichnung(Schulform.HI, "11. Jahrgang, Berufskolleg"), new JahrgangsKatalogEintragBezeichnung(Schulform.FW, "11. Jahrgang"), new JahrgangsKatalogEintragBezeichnung(Schulform.WF, "11. Jahrgang")), null, null)}),
    JG_12(new JahrgangsKatalogEintrag[]{new JahrgangsKatalogEintrag(2012000000L, "12", Arrays.asList(new JahrgangsKatalogEintragBezeichnung(Schulform.HI, "12. Jahrgang, Berufskolleg"), new JahrgangsKatalogEintragBezeichnung(Schulform.FW, "12. Jahrgang"), new JahrgangsKatalogEintragBezeichnung(Schulform.WF, "12. Jahrgang")), null, null)}),
    JG_13(new JahrgangsKatalogEintrag[]{new JahrgangsKatalogEintrag(2013000000L, "13", Arrays.asList(new JahrgangsKatalogEintragBezeichnung(Schulform.FW, "13. Jahrgang"), new JahrgangsKatalogEintragBezeichnung(Schulform.WF, "13. Jahrgang")), null, null)}),
    JG_71(new JahrgangsKatalogEintrag[]{new JahrgangsKatalogEintrag(4071000000L, "71", Arrays.asList(new JahrgangsKatalogEintragBezeichnung(Schulform.FW, "Schule f\u00fcr Kranke"), new JahrgangsKatalogEintragBezeichnung(Schulform.WF, "Schule f\u00fcr Kranke"), new JahrgangsKatalogEintragBezeichnung(Schulform.KS, "Schule f\u00fcr Kranke"), new JahrgangsKatalogEintragBezeichnung(Schulform.S, "Schule f\u00fcr Kranke")), null, null)}),
    JG_85(new JahrgangsKatalogEintrag[]{new JahrgangsKatalogEintrag(4085000000L, "85", Arrays.asList(new JahrgangsKatalogEintragBezeichnung(Schulform.FW, "Schule f\u00fcr Geistigbehinderte: Berufspraxisstufe in Vollzeitform"), new JahrgangsKatalogEintragBezeichnung(Schulform.WF, "Schule f\u00fcr Geistigbehinderte: Berufspraxisstufe in Vollzeitform"), new JahrgangsKatalogEintragBezeichnung(Schulform.KS, "Schule f\u00fcr Geistigbehinderte: Berufspraxisstufe in Vollzeitform"), new JahrgangsKatalogEintragBezeichnung(Schulform.S, "Schule f\u00fcr Geistigbehinderte: Berufspraxisstufe in Vollzeitform")), null, null)}),
    JG_86(new JahrgangsKatalogEintrag[]{new JahrgangsKatalogEintrag(4086000000L, "86", Arrays.asList(new JahrgangsKatalogEintragBezeichnung(Schulform.FW, "Schule f\u00fcr Geistigbehinderte: Berufspraxisstufe in Teilzeitform"), new JahrgangsKatalogEintragBezeichnung(Schulform.WF, "Schule f\u00fcr Geistigbehinderte: Berufspraxisstufe in Teilzeitform"), new JahrgangsKatalogEintragBezeichnung(Schulform.KS, "Schule f\u00fcr Geistigbehinderte: Berufspraxisstufe in Teilzeitform"), new JahrgangsKatalogEintragBezeichnung(Schulform.S, "Schule f\u00fcr Geistigbehinderte: Berufspraxisstufe in Teilzeitform")), null, null)}),
    JG_EF(new JahrgangsKatalogEintrag[]{new JahrgangsKatalogEintrag(3000000000L, "EF", Arrays.asList(new JahrgangsKatalogEintragBezeichnung(Schulform.GE, "Einf\u00fchrungsphase"), new JahrgangsKatalogEintragBezeichnung(Schulform.GM, "Einf\u00fchrungsphase"), new JahrgangsKatalogEintragBezeichnung(Schulform.GY, "Einf\u00fchrungsphase"), new JahrgangsKatalogEintragBezeichnung(Schulform.PS, "Einf\u00fchrungsphase"), new JahrgangsKatalogEintragBezeichnung(Schulform.SG, "Einf\u00fchrungsphase")), null, null)}),
    JG_Q1(new JahrgangsKatalogEintrag[]{new JahrgangsKatalogEintrag(3001000000L, "Q1", Arrays.asList(new JahrgangsKatalogEintragBezeichnung(Schulform.GE, "Qualifikationsphase 1. Jahr"), new JahrgangsKatalogEintragBezeichnung(Schulform.GM, "Qualifikationsphase 1. Jahr"), new JahrgangsKatalogEintragBezeichnung(Schulform.GY, "Qualifikationsphase 1. Jahr"), new JahrgangsKatalogEintragBezeichnung(Schulform.PS, "Qualifikationsphase 1. Jahr"), new JahrgangsKatalogEintragBezeichnung(Schulform.SG, "Qualifikationsphase 1. Jahr")), null, null)}),
    JG_Q2(new JahrgangsKatalogEintrag[]{new JahrgangsKatalogEintrag(3002000000L, "Q2", Arrays.asList(new JahrgangsKatalogEintragBezeichnung(Schulform.GE, "Qualifikationsphase 2. Jahr"), new JahrgangsKatalogEintragBezeichnung(Schulform.GM, "Qualifikationsphase 2. Jahr"), new JahrgangsKatalogEintragBezeichnung(Schulform.GY, "Qualifikationsphase 2. Jahr"), new JahrgangsKatalogEintragBezeichnung(Schulform.PS, "Qualifikationsphase 2. Jahr"), new JahrgangsKatalogEintragBezeichnung(Schulform.SG, "Qualifikationsphase 2. Jahr")), null, null)});

    public static final long VERSION = 1L;
    @NotNull
    public final JahrgangsKatalogEintrag daten;
    @NotNull
    public final @NotNull JahrgangsKatalogEintrag @NotNull [] historie;
    @NotNull
    private static final @NotNull HashMap<@NotNull String, Jahrgaenge> _mapKuerzel;
    @NotNull
    private static final @NotNull HashMap<@NotNull Long, Jahrgaenge> _mapID;
    @NotNull
    private @NotNull ArrayList<Schulform> @NotNull [] schulformen;
    @NotNull
    private @NotNull ArrayList<@NotNull String> @NotNull [] bezeichnungen;

    private Jahrgaenge(JahrgangsKatalogEintrag[] historie) {
        this.historie = historie;
        this.daten = historie[historie.length - 1];
        this.schulformen = (ArrayList[])Array.newInstance(ArrayList.class, historie.length);
        this.bezeichnungen = (ArrayList[])Array.newInstance(ArrayList.class, historie.length);
        for (int i = 0; i < historie.length; ++i) {
            this.schulformen[i] = new ArrayList();
            this.bezeichnungen[i] = new ArrayList();
            for (JahrgangsKatalogEintragBezeichnung bez : historie[i].bezeichnungen) {
                Schulform sf = Schulform.getByKuerzel(bez.schulform);
                if (sf != null) {
                    this.schulformen[i].add(sf);
                }
                this.bezeichnungen[i].add(bez.bezeichnung);
            }
        }
    }

    @NotNull
    private static @NotNull HashMap<@NotNull String, Jahrgaenge> getMapJahrgangByKuerzel() {
        if (_mapKuerzel.size() == 0) {
            for (Jahrgaenge j : Jahrgaenge.values()) {
                _mapKuerzel.put(j.daten.kuerzel, j);
            }
        }
        return _mapKuerzel;
    }

    @NotNull
    private static @NotNull HashMap<@NotNull Long, Jahrgaenge> getMapJahrgangByID() {
        if (_mapID.size() == 0) {
            for (Jahrgaenge j : Jahrgaenge.values()) {
                for (JahrgangsKatalogEintrag k : j.historie) {
                    _mapID.put(k.id, j);
                }
            }
        }
        return _mapID;
    }

    public static Jahrgaenge getByKuerzel(String kuerzel) {
        return Jahrgaenge.getMapJahrgangByKuerzel().get(kuerzel);
    }

    public static Jahrgaenge getByID(Long id) {
        return Jahrgaenge.getMapJahrgangByID().get(id);
    }

    public String getBezeichnung(Schulform schulform) {
        if (schulform == null || schulform.daten == null) {
            return null;
        }
        if (this.daten.bezeichnungen != null) {
            for (int i = 0; i < this.daten.bezeichnungen.size(); ++i) {
                JahrgangsKatalogEintragBezeichnung bez = this.daten.bezeichnungen.get(i);
                String sfKuerzel = bez.schulform;
                if (!sfKuerzel.equals(schulform.daten.kuerzel)) continue;
                return bez.bezeichnung;
            }
        }
        return null;
    }

    @NotNull
    public List<Schulform> getSchulformen() {
        return this.schulformen[this.historie.length - 1];
    }

    @NotNull
    public static List<Jahrgaenge> get(Schulform schulform) {
        @NotNull ArrayList<Jahrgaenge> result = new ArrayList<Jahrgaenge>();
        if (schulform == null) {
            return result;
        }
        @NotNull Jahrgaenge @NotNull [] jahrgaenge = Jahrgaenge.values();
        for (int i = 0; i < jahrgaenge.length; ++i) {
            Jahrgaenge jahrgang = jahrgaenge[i];
            if (!jahrgang.hasSchulform(schulform)) continue;
            result.add(jahrgang);
        }
        return result;
    }

    public boolean isKuerzel(String kuerzel) {
        if (this.daten == null) {
            return false;
        }
        return this.daten.kuerzel.equals(kuerzel);
    }

    public boolean hasSchulformByKuerzel(String kuerzel) {
        if (kuerzel == null || "".equals(kuerzel)) {
            return false;
        }
        if (this.daten.bezeichnungen != null) {
            for (int i = 0; i < this.daten.bezeichnungen.size(); ++i) {
                String sfKuerzel = this.daten.bezeichnungen.get((int)i).schulform;
                if (!sfKuerzel.equals(kuerzel)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasSchulform(Schulform schulform) {
        if (schulform == null || schulform.daten == null) {
            return false;
        }
        if (this.daten.bezeichnungen != null) {
            for (int i = 0; i < this.daten.bezeichnungen.size(); ++i) {
                String sfKuerzel = this.daten.bezeichnungen.get((int)i).schulform;
                if (!sfKuerzel.equals(schulform.daten.kuerzel)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isNachfolgerVon(Jahrgaenge vergleichsjahrgang, Schulform schulform, Schulgliederung gliederung) {
        if (schulform == null) {
            return false;
        }
        if (!this.hasSchulform(schulform) || vergleichsjahrgang != null && !vergleichsjahrgang.hasSchulform(schulform)) {
            return false;
        }
        Schulgliederung gl = gliederung == null ? Schulgliederung.getDefault(schulform) : gliederung;
        switch (this.ordinal()) {
            case 0: {
                return vergleichsjahrgang == null;
            }
            case 7: {
                return vergleichsjahrgang == null;
            }
            case 8: {
                return vergleichsjahrgang == JG_01;
            }
            case 9: {
                return vergleichsjahrgang == JG_02 || vergleichsjahrgang == JG_E2 || vergleichsjahrgang == JG_E3;
            }
            case 10: {
                return vergleichsjahrgang == JG_03;
            }
            case 11: {
                return vergleichsjahrgang == JG_04;
            }
            case 12: {
                return vergleichsjahrgang == JG_05;
            }
            case 13: {
                return vergleichsjahrgang == JG_06;
            }
            case 14: {
                return vergleichsjahrgang == JG_07;
            }
            case 15: {
                return vergleichsjahrgang == JG_08;
            }
            case 16: {
                return vergleichsjahrgang == JG_09;
            }
            case 17: {
                return vergleichsjahrgang == JG_10;
            }
            case 18: {
                return vergleichsjahrgang == JG_11;
            }
            case 19: {
                return vergleichsjahrgang == JG_12;
            }
            case 20: {
                return vergleichsjahrgang == null;
            }
            case 21: {
                return vergleichsjahrgang == null;
            }
            case 22: {
                return vergleichsjahrgang == null;
            }
            case 1: {
                return vergleichsjahrgang == null;
            }
            case 5: {
                return vergleichsjahrgang == null;
            }
            case 6: {
                return vergleichsjahrgang == JG_91;
            }
            case 2: {
                return vergleichsjahrgang == JG_00 || vergleichsjahrgang == null;
            }
            case 3: {
                return vergleichsjahrgang == JG_E1;
            }
            case 4: {
                return vergleichsjahrgang == JG_E2;
            }
            case 23: {
                return gl == Schulgliederung.GY8 ? vergleichsjahrgang == JG_09 : vergleichsjahrgang == JG_10;
            }
            case 24: {
                return vergleichsjahrgang == JG_EF;
            }
            case 25: {
                return vergleichsjahrgang == JG_Q1;
            }
        }
        return false;
    }

    public boolean isVorgaengerVon(Jahrgaenge vergleichsjahrgang, Schulform schulform, Schulgliederung gliederung) {
        if (schulform == null) {
            return false;
        }
        if (!this.hasSchulform(schulform) || vergleichsjahrgang != null && !vergleichsjahrgang.hasSchulform(schulform)) {
            return false;
        }
        Schulgliederung gl = gliederung == null ? Schulgliederung.getDefault(schulform) : gliederung;
        switch (this.ordinal()) {
            case 0: {
                return vergleichsjahrgang == JG_01;
            }
            case 7: {
                return vergleichsjahrgang == JG_02;
            }
            case 8: {
                return vergleichsjahrgang == JG_03;
            }
            case 9: {
                return vergleichsjahrgang == JG_04;
            }
            case 10: {
                return vergleichsjahrgang == JG_05;
            }
            case 11: {
                return vergleichsjahrgang == JG_06;
            }
            case 12: {
                return vergleichsjahrgang == JG_07;
            }
            case 13: {
                return vergleichsjahrgang == JG_08;
            }
            case 14: {
                return vergleichsjahrgang == JG_09;
            }
            case 15: {
                return vergleichsjahrgang == JG_10 || schulform == Schulform.GY && (gl == Schulgliederung.GY8 || gl == Schulgliederung.DEFAULT) && vergleichsjahrgang == JG_EF;
            }
            case 16: {
                return vergleichsjahrgang == JG_11 || schulform.daten.hatGymOb && vergleichsjahrgang == JG_EF;
            }
            case 17: {
                return vergleichsjahrgang == JG_12;
            }
            case 18: {
                return vergleichsjahrgang == JG_13;
            }
            case 19: {
                return vergleichsjahrgang == null;
            }
            case 20: {
                return vergleichsjahrgang == null;
            }
            case 21: {
                return vergleichsjahrgang == null;
            }
            case 22: {
                return vergleichsjahrgang == null;
            }
            case 1: {
                return vergleichsjahrgang == null;
            }
            case 5: {
                return vergleichsjahrgang == JG_92;
            }
            case 6: {
                return vergleichsjahrgang == null;
            }
            case 2: {
                return vergleichsjahrgang == JG_E2;
            }
            case 3: {
                return vergleichsjahrgang == JG_E3 || vergleichsjahrgang == JG_03;
            }
            case 4: {
                return vergleichsjahrgang == JG_03;
            }
            case 23: {
                return vergleichsjahrgang == JG_Q1;
            }
            case 24: {
                return vergleichsjahrgang == JG_Q2;
            }
            case 25: {
                return vergleichsjahrgang == null;
            }
        }
        return false;
    }

    public boolean isMoeglicherNachfolgerVon(Jahrgaenge Vergleichsjahrgang) {
        switch (this.ordinal()) {
            case 0: {
                return Vergleichsjahrgang == null;
            }
            case 7: {
                return Vergleichsjahrgang == null;
            }
            case 8: {
                return Vergleichsjahrgang == JG_01;
            }
            case 9: {
                return Vergleichsjahrgang == JG_02 || Vergleichsjahrgang == JG_E2 || Vergleichsjahrgang == JG_E3;
            }
            case 10: {
                return Vergleichsjahrgang == JG_03;
            }
            case 11: {
                return Vergleichsjahrgang == JG_04;
            }
            case 12: {
                return Vergleichsjahrgang == JG_05;
            }
            case 13: {
                return Vergleichsjahrgang == JG_06;
            }
            case 14: {
                return Vergleichsjahrgang == JG_07;
            }
            case 15: {
                return Vergleichsjahrgang == JG_08;
            }
            case 16: {
                return Vergleichsjahrgang == JG_09;
            }
            case 17: {
                return Vergleichsjahrgang == JG_10;
            }
            case 18: {
                return Vergleichsjahrgang == JG_11;
            }
            case 19: {
                return Vergleichsjahrgang == JG_12;
            }
            case 20: {
                return Vergleichsjahrgang == null;
            }
            case 21: {
                return Vergleichsjahrgang == null;
            }
            case 22: {
                return Vergleichsjahrgang == null;
            }
            case 1: {
                return Vergleichsjahrgang == null;
            }
            case 5: {
                return Vergleichsjahrgang == null;
            }
            case 6: {
                return Vergleichsjahrgang == JG_91;
            }
            case 2: {
                return Vergleichsjahrgang == JG_00 || Vergleichsjahrgang == null;
            }
            case 3: {
                return Vergleichsjahrgang == JG_E1;
            }
            case 4: {
                return Vergleichsjahrgang == JG_E2;
            }
            case 23: {
                return Vergleichsjahrgang == JG_09 || Vergleichsjahrgang == JG_10;
            }
            case 24: {
                return Vergleichsjahrgang == JG_EF;
            }
            case 25: {
                return Vergleichsjahrgang == JG_Q1;
            }
        }
        return false;
    }

    public boolean isMoeglicherVorgaengerVon(Jahrgaenge Vergleichsjahrgang) {
        switch (this.ordinal()) {
            case 0: {
                return Vergleichsjahrgang == JG_01;
            }
            case 7: {
                return Vergleichsjahrgang == JG_02;
            }
            case 8: {
                return Vergleichsjahrgang == JG_03;
            }
            case 9: {
                return Vergleichsjahrgang == JG_04;
            }
            case 10: {
                return Vergleichsjahrgang == JG_05;
            }
            case 11: {
                return Vergleichsjahrgang == JG_06;
            }
            case 12: {
                return Vergleichsjahrgang == JG_07;
            }
            case 13: {
                return Vergleichsjahrgang == JG_08;
            }
            case 14: {
                return Vergleichsjahrgang == JG_09;
            }
            case 15: {
                return Vergleichsjahrgang == JG_10 || Vergleichsjahrgang == JG_EF;
            }
            case 16: {
                return Vergleichsjahrgang == JG_11 || Vergleichsjahrgang == JG_EF;
            }
            case 17: {
                return Vergleichsjahrgang == JG_12;
            }
            case 18: {
                return Vergleichsjahrgang == JG_13;
            }
            case 19: {
                return Vergleichsjahrgang == null;
            }
            case 20: {
                return Vergleichsjahrgang == null;
            }
            case 21: {
                return Vergleichsjahrgang == null;
            }
            case 22: {
                return Vergleichsjahrgang == null;
            }
            case 1: {
                return Vergleichsjahrgang == null;
            }
            case 5: {
                return Vergleichsjahrgang == JG_92;
            }
            case 6: {
                return Vergleichsjahrgang == null;
            }
            case 2: {
                return Vergleichsjahrgang == JG_E2;
            }
            case 3: {
                return Vergleichsjahrgang == JG_E3 || Vergleichsjahrgang == JG_03;
            }
            case 4: {
                return Vergleichsjahrgang == JG_03;
            }
            case 23: {
                return Vergleichsjahrgang == JG_Q1;
            }
            case 24: {
                return Vergleichsjahrgang == JG_Q2;
            }
            case 25: {
                return Vergleichsjahrgang == null;
            }
        }
        return false;
    }

    static {
        _mapKuerzel = new HashMap();
        _mapID = new HashMap();
    }
}

