/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.types.kaoa;

import de.svws_nrw.core.data.kaoa.KAOABerufsfeldEintrag;
import jakarta.validation.constraints.NotNull;
import java.util.HashMap;

public enum KAOABerufsfeld {
    BAV(new KAOABerufsfeldEintrag[]{new KAOABerufsfeldEintrag(1L, "BAV", "Bau, Architektur, Vermessung", null, null)}),
    D(new KAOABerufsfeldEintrag[]{new KAOABerufsfeldEintrag(2L, "D", "Dienstleistung", null, null)}),
    EL(new KAOABerufsfeldEintrag[]{new KAOABerufsfeldEintrag(3L, "EL", "Elektro", null, null)}),
    G(new KAOABerufsfeldEintrag[]{new KAOABerufsfeldEintrag(4L, "G", "Gesundheit", null, null)}),
    GESGE(new KAOABerufsfeldEintrag[]{new KAOABerufsfeldEintrag(5L, "GESGE", "Gesellschafts-,Geisteswissenschaften", null, null)}),
    ITC(new KAOABerufsfeldEintrag[]{new KAOABerufsfeldEintrag(6L, "ITC", "IT, Computer", null, null)}),
    KKG(new KAOABerufsfeldEintrag[]{new KAOABerufsfeldEintrag(7L, "KKG", "Kunst, Kultur, Gestaltung", null, null)}),
    LANAUM(new KAOABerufsfeldEintrag[]{new KAOABerufsfeldEintrag(8L, "LANAUM", "Landwirtschaft, Natur, Umwelt", null, null)}),
    M(new KAOABerufsfeldEintrag[]{new KAOABerufsfeldEintrag(9L, "M", "Metall, Maschinenbau", null, null)}),
    ME(new KAOABerufsfeldEintrag[]{new KAOABerufsfeldEintrag(10L, "ME", "Medien", null, null)}),
    N(new KAOABerufsfeldEintrag[]{new KAOABerufsfeldEintrag(11L, "N", "Naturwissenschaft", null, null)}),
    PRFE(new KAOABerufsfeldEintrag[]{new KAOABerufsfeldEintrag(12L, "PRFE", "Produktion, Fertigung", null, null)}),
    SP(new KAOABerufsfeldEintrag[]{new KAOABerufsfeldEintrag(13L, "SP", "Soziales, P\u00e4dagogik", null, null)}),
    TEC(new KAOABerufsfeldEintrag[]{new KAOABerufsfeldEintrag(14L, "TEC", "Technik, Technologiefelder", null, null)}),
    VL(new KAOABerufsfeldEintrag[]{new KAOABerufsfeldEintrag(15L, "VL", "Verkehr, Logistik", null, null)}),
    WIVE(new KAOABerufsfeldEintrag[]{new KAOABerufsfeldEintrag(16L, "WIVE", "Wirtschaft, Verwaltung", null, null)});

    public static final long VERSION = 1L;
    @NotNull
    public final KAOABerufsfeldEintrag daten;
    @NotNull
    public final @NotNull KAOABerufsfeldEintrag @NotNull [] historie;
    @NotNull
    private static final @NotNull HashMap<@NotNull Long, @NotNull KAOABerufsfeld> _statusByID;
    @NotNull
    private static final @NotNull HashMap<@NotNull String, @NotNull KAOABerufsfeld> _statusByKuerzel;

    private KAOABerufsfeld(KAOABerufsfeldEintrag[] historie) {
        this.historie = historie;
        this.daten = historie[historie.length - 1];
    }

    @NotNull
    private static @NotNull HashMap<@NotNull Long, @NotNull KAOABerufsfeld> getMapStatusByID() {
        if (_statusByID.size() == 0) {
            for (KAOABerufsfeld g : KAOABerufsfeld.values()) {
                _statusByID.put(g.daten.id, g);
            }
        }
        return _statusByID;
    }

    @NotNull
    private static @NotNull HashMap<@NotNull String, @NotNull KAOABerufsfeld> getMapStatusByKuerzel() {
        if (_statusByKuerzel.size() == 0) {
            for (KAOABerufsfeld g : KAOABerufsfeld.values()) {
                _statusByKuerzel.put(g.daten.kuerzel, g);
            }
        }
        return _statusByKuerzel;
    }

    public static KAOABerufsfeld getByID(Long id) {
        return KAOABerufsfeld.getMapStatusByID().get(id);
    }

    public static KAOABerufsfeld getByKuerzel(String kuerzel) {
        return KAOABerufsfeld.getMapStatusByKuerzel().get(kuerzel);
    }

    static {
        _statusByID = new HashMap();
        _statusByKuerzel = new HashMap();
    }
}

