/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.types.kaoa;

import de.svws_nrw.core.data.kaoa.KAOAKategorieEintrag;
import de.svws_nrw.core.types.jahrgang.Jahrgaenge;
import jakarta.validation.constraints.NotNull;
import java.util.Arrays;
import java.util.HashMap;

public enum KAOAKategorie {
    SBO_2(new KAOAKategorieEintrag[]{new KAOAKategorieEintrag(6L, "SBO 2", "Formen der Orientierung und Beratung", Arrays.asList(Jahrgaenge.JG_08, Jahrgaenge.JG_09, Jahrgaenge.JG_10, Jahrgaenge.JG_EF, Jahrgaenge.JG_Q1, Jahrgaenge.JG_Q2), null, null)}),
    SBO_3(new KAOAKategorieEintrag[]{new KAOAKategorieEintrag(7L, "SBO 3", "Strukturen an Schulen", Arrays.asList(Jahrgaenge.JG_00), null, null)}),
    SBO_4(new KAOAKategorieEintrag[]{new KAOAKategorieEintrag(8L, "SBO 4", "Potenziale entdecken und den eigenen Standort bestimmen", Arrays.asList(Jahrgaenge.JG_08, Jahrgaenge.JG_09), null, null)}),
    SBO_5(new KAOAKategorieEintrag[]{new KAOAKategorieEintrag(9L, "SBO 5", "Berufsfelder erkunden und Informationen sammeln", Arrays.asList(Jahrgaenge.JG_08, Jahrgaenge.JG_09), null, null)}),
    SBO_6(new KAOAKategorieEintrag[]{new KAOAKategorieEintrag(10L, "SBO 6", "Praxis der Arbeitswelt kennenlernen und erproben", Arrays.asList(Jahrgaenge.JG_08, Jahrgaenge.JG_09, Jahrgaenge.JG_10), null, null)}),
    SBO_7(new KAOAKategorieEintrag[]{new KAOAKategorieEintrag(11L, "SBO 7", "Nachholung der Erstberufsorientierung", Arrays.asList(Jahrgaenge.JG_10), null, null)}),
    SBO_8(new KAOAKategorieEintrag[]{new KAOAKategorieEintrag(12L, "SBO 8", "Sekundarstufe II - Individuelle Voraussetzungen f\u00fcr eine Ausbildung oder ein Studium \u00fcberpr\u00fcfen", Arrays.asList(Jahrgaenge.JG_EF, Jahrgaenge.JG_Q1, Jahrgaenge.JG_Q2), null, null)}),
    SBO_9(new KAOAKategorieEintrag[]{new KAOAKategorieEintrag(13L, "SBO 9", "Sekundarstufe II - Praxis vertiefen - Ausbildungs- und Studienwahl konkretisieren", Arrays.asList(Jahrgaenge.JG_EF, Jahrgaenge.JG_Q1, Jahrgaenge.JG_Q2), null, null)}),
    SBO_10(new KAOAKategorieEintrag[]{new KAOAKategorieEintrag(14L, "SBO 10", "Gestaltung und Koordination der \u00dcberg\u00e4nge in der Sek. I und Sek. II", Arrays.asList(Jahrgaenge.JG_09, Jahrgaenge.JG_10, Jahrgaenge.JG_EF, Jahrgaenge.JG_Q1, Jahrgaenge.JG_Q2), null, null)});

    public static final long VERSION = 1L;
    @NotNull
    public final KAOAKategorieEintrag daten;
    @NotNull
    public final @NotNull KAOAKategorieEintrag @NotNull [] historie;
    @NotNull
    private static final @NotNull HashMap<@NotNull Long, @NotNull KAOAKategorie> _statusByID;
    @NotNull
    private static final @NotNull HashMap<@NotNull String, @NotNull KAOAKategorie> _statusByKuerzel;

    private KAOAKategorie(KAOAKategorieEintrag[] historie) {
        this.historie = historie;
        this.daten = historie[historie.length - 1];
    }

    @NotNull
    private static @NotNull HashMap<@NotNull Long, @NotNull KAOAKategorie> getMapStatusByID() {
        if (_statusByID.size() == 0) {
            for (KAOAKategorie g : KAOAKategorie.values()) {
                _statusByID.put(g.daten.id, g);
            }
        }
        return _statusByID;
    }

    @NotNull
    private static @NotNull HashMap<@NotNull String, @NotNull KAOAKategorie> getMapStatusByKuerzel() {
        if (_statusByKuerzel.size() == 0) {
            for (KAOAKategorie g : KAOAKategorie.values()) {
                _statusByKuerzel.put(g.daten.kuerzel, g);
            }
        }
        return _statusByKuerzel;
    }

    public static KAOAKategorie getByID(Long id) {
        return KAOAKategorie.getMapStatusByID().get(id);
    }

    public static KAOAKategorie getByKuerzel(String kuerzel) {
        return KAOAKategorie.getMapStatusByKuerzel().get(kuerzel);
    }

    static {
        _statusByID = new HashMap();
        _statusByKuerzel = new HashMap();
    }
}

