/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.types.kaoa;

import de.svws_nrw.core.data.kaoa.KAOAMerkmalEintrag;
import de.svws_nrw.core.types.kaoa.KAOAKategorie;
import de.svws_nrw.core.types.kaoa.KAOAMerkmaleOptionsarten;
import de.svws_nrw.core.types.schule.Schulgliederung;
import jakarta.validation.constraints.NotNull;
import java.util.Arrays;
import java.util.HashMap;

public enum KAOAMerkmal {
    SBO_2_1(new KAOAMerkmalEintrag[]{new KAOAMerkmalEintrag(35L, "SBO 2.1", "Schulische prozessorientierte Begleitung und Beratung", KAOAKategorie.SBO_2, KAOAMerkmaleOptionsarten.KEINE, Arrays.asList(Schulgliederung.A12, Schulgliederung.B06, Schulgliederung.B07, Schulgliederung.C03, Schulgliederung.C05, Schulgliederung.C06, Schulgliederung.D02), null, null)}),
    SBO_2_2(new KAOAMerkmalEintrag[]{new KAOAMerkmalEintrag(36L, "SBO 2.2", "Berufsorientierende Angebote der Berufsberatung der Bundesagentur f\u00fcr Arbeit (BA)", KAOAKategorie.SBO_2, KAOAMerkmaleOptionsarten.KEINE, Arrays.asList(Schulgliederung.A12, Schulgliederung.B06, Schulgliederung.B07, Schulgliederung.C03, Schulgliederung.C05, Schulgliederung.C06, Schulgliederung.D02), null, null)}),
    SBO_2_3(new KAOAMerkmalEintrag[]{new KAOAMerkmalEintrag(37L, "SBO 2.3", "Individuelle Beratungsangebote au\u00dferschulischer Partner", KAOAKategorie.SBO_2, KAOAMerkmaleOptionsarten.KEINE, Arrays.asList(Schulgliederung.A12, Schulgliederung.B06, Schulgliederung.B07, Schulgliederung.C03, Schulgliederung.C05, Schulgliederung.C06, Schulgliederung.D02), null, null)}),
    SBO_2_4(new KAOAMerkmalEintrag[]{new KAOAMerkmalEintrag(38L, "SBO 2.4", "STAR - Berufswegekonferenz", KAOAKategorie.SBO_2, KAOAMerkmaleOptionsarten.KEINE, Arrays.asList(new Schulgliederung[0]), null, null)}),
    SBO_2_5(new KAOAMerkmalEintrag[]{new KAOAMerkmalEintrag(39L, "SBO 2.5", "Einbindung von Eltern bzw. Erziehungsberechtigten", KAOAKategorie.SBO_2, KAOAMerkmaleOptionsarten.KEINE, Arrays.asList(Schulgliederung.A12, Schulgliederung.B06, Schulgliederung.B07, Schulgliederung.C03, Schulgliederung.C05, Schulgliederung.C06, Schulgliederung.D02), null, null)}),
    SBO_2_6(new KAOAMerkmalEintrag[]{new KAOAMerkmalEintrag(40L, "SBO 2.6", "STAR - Einbindung von Eltern bzw. Erziehungsberechtigten", KAOAKategorie.SBO_2, KAOAMerkmaleOptionsarten.KEINE, Arrays.asList(new Schulgliederung[0]), null, null)}),
    SBO_3_4(new KAOAMerkmalEintrag[]{new KAOAMerkmalEintrag(41L, "SBO 3.4", "Portfolioinstrument", KAOAKategorie.SBO_3, KAOAMerkmaleOptionsarten.KEINE, Arrays.asList(Schulgliederung.A12, Schulgliederung.B06, Schulgliederung.B07, Schulgliederung.C03, Schulgliederung.C05, Schulgliederung.C06, Schulgliederung.D02), null, null)}),
    SBO_4_1(new KAOAMerkmalEintrag[]{new KAOAMerkmalEintrag(42L, "SBO 4.1", "Potenzialanalyse 1-t\u00e4gig", KAOAKategorie.SBO_4, KAOAMerkmaleOptionsarten.KEINE, Arrays.asList(new Schulgliederung[0]), null, null)}),
    SBO_4_2(new KAOAMerkmalEintrag[]{new KAOAMerkmalEintrag(43L, "SBO 4.2", "Potenzialanalyse f\u00fcr Sch\u00fclerinnen und Sch\u00fcler mit den F\u00f6rderschwerpunkten Lernen und Emotionale soziale Entwicklung\u2013 2-t\u00e4gig", KAOAKategorie.SBO_4, KAOAMerkmaleOptionsarten.KEINE, Arrays.asList(new Schulgliederung[0]), null, null)}),
    SBO_4_3(new KAOAMerkmalEintrag[]{new KAOAMerkmalEintrag(44L, "SBO 4.3", "STAR \u2013 Potenzialanalyse f\u00fcr Sch\u00fclerinnen und Sch\u00fcler mit den F\u00f6rderschwerpunkten Geistige Entwicklung, K\u00f6rperliche und motorische Entwicklung, H\u00f6ren und Kommunikation und Sprache - 2-t\u00e4gig", KAOAKategorie.SBO_4, KAOAMerkmaleOptionsarten.KEINE, Arrays.asList(new Schulgliederung[0]), null, null)}),
    SBO_4_4(new KAOAMerkmalEintrag[]{new KAOAMerkmalEintrag(45L, "SBO 4.4", "STAR \u2013 Feststellung des funktionalen Sehverm\u00f6gens im F\u00f6rderschwerpunkt Sehen", KAOAKategorie.SBO_4, KAOAMerkmaleOptionsarten.KEINE, Arrays.asList(new Schulgliederung[0]), null, null)}),
    SBO_4_5(new KAOAMerkmalEintrag[]{new KAOAMerkmalEintrag(46L, "SBO 4.5", "STAR \u2013 Potenzialanalyse im F\u00f6rderschwerpunkt Sehen \u2013 2-t\u00e4gig", KAOAKategorie.SBO_4, KAOAMerkmaleOptionsarten.KEINE, Arrays.asList(new Schulgliederung[0]), null, null)}),
    SBO_5_1(new KAOAMerkmalEintrag[]{new KAOAMerkmalEintrag(47L, "SBO 5.1", "Berufsfelderkundungen", KAOAKategorie.SBO_5, KAOAMerkmaleOptionsarten.KEINE, Arrays.asList(new Schulgliederung[0]), null, null)}),
    SBO_5_2(new KAOAMerkmalEintrag[]{new KAOAMerkmalEintrag(48L, "SBO 5.2", "STAR \u2013 Berufsfelderkundungen", KAOAKategorie.SBO_5, KAOAMerkmaleOptionsarten.KEINE, Arrays.asList(new Schulgliederung[0]), null, null)}),
    SBO_5_3(new KAOAMerkmalEintrag[]{new KAOAMerkmalEintrag(49L, "SBO 5.3", "STAR \u2013 Arbeitsplatzbezogenes Kommunikationstraining I im F\u00f6rderschwerpunkt H\u00f6ren und Kommunikation", KAOAKategorie.SBO_5, KAOAMerkmaleOptionsarten.KEINE, Arrays.asList(new Schulgliederung[0]), null, null)}),
    SBO_5_4(new KAOAMerkmalEintrag[]{new KAOAMerkmalEintrag(50L, "SBO 5.4", "STAR - Berufsorientierungsseminar", KAOAKategorie.SBO_5, KAOAMerkmaleOptionsarten.KEINE, Arrays.asList(new Schulgliederung[0]), null, null)}),
    SBO_6_1(new KAOAMerkmalEintrag[]{new KAOAMerkmalEintrag(51L, "SBO 6.1", "Betriebspraktika in der Sekundarstufe I (ggf. 1 Woche verlagert aus der Oberstufe)", KAOAKategorie.SBO_6, KAOAMerkmaleOptionsarten.KEINE, Arrays.asList(new Schulgliederung[0]), null, null)}),
    SBO_6_2(new KAOAMerkmalEintrag[]{new KAOAMerkmalEintrag(52L, "SBO 6.2", "STAR \u2013 Intensivtraining arbeitsrelevanter sozialer Kompetenzen (TASK)", KAOAKategorie.SBO_6, KAOAMerkmaleOptionsarten.KEINE, Arrays.asList(new Schulgliederung[0]), null, null)}),
    SBO_6_3(new KAOAMerkmalEintrag[]{new KAOAMerkmalEintrag(53L, "SBO 6.3", "STAR \u2013 Betriebspraktikum im Block", KAOAKategorie.SBO_6, KAOAMerkmaleOptionsarten.KEINE, Arrays.asList(new Schulgliederung[0]), null, null)}),
    SBO_6_4(new KAOAMerkmalEintrag[]{new KAOAMerkmalEintrag(54L, "SBO 6.4", "Praxiskurse", KAOAKategorie.SBO_6, KAOAMerkmaleOptionsarten.KEINE, Arrays.asList(new Schulgliederung[0]), null, null)}),
    SBO_6_5(new KAOAMerkmalEintrag[]{new KAOAMerkmalEintrag(55L, "SBO 6.5", "Langzeitpraktikum", KAOAKategorie.SBO_6, KAOAMerkmaleOptionsarten.KEINE, Arrays.asList(new Schulgliederung[0]), null, null)}),
    SBO_6_6(new KAOAMerkmalEintrag[]{new KAOAMerkmalEintrag(56L, "SBO 6.6", "STAR \u2013 Betriebspraktikum in Langzeit", KAOAKategorie.SBO_6, KAOAMerkmaleOptionsarten.KEINE, Arrays.asList(new Schulgliederung[0]), null, null)}),
    SBO_7_1(new KAOAMerkmalEintrag[]{new KAOAMerkmalEintrag(57L, "SBO 7.1", "KAoA-kompakt", KAOAKategorie.SBO_7, KAOAMerkmaleOptionsarten.KEINE, Arrays.asList(Schulgliederung.A12, Schulgliederung.B06, Schulgliederung.B07), null, null)}),
    SBO_8_1(new KAOAMerkmalEintrag[]{new KAOAMerkmalEintrag(58L, "SBO 8.1", "Standortbestimmung - Reflexionsworkshop Sek. II", KAOAKategorie.SBO_8, KAOAMerkmaleOptionsarten.KEINE, Arrays.asList(Schulgliederung.A12, Schulgliederung.B06, Schulgliederung.B07, Schulgliederung.C03, Schulgliederung.C05, Schulgliederung.C06, Schulgliederung.D02), null, null)}),
    SBO_8_2(new KAOAMerkmalEintrag[]{new KAOAMerkmalEintrag(59L, "SBO 8.2", "St\u00e4rkung der Entscheidungskompetenz I \u2013 Sek. II", KAOAKategorie.SBO_8, KAOAMerkmaleOptionsarten.KEINE, Arrays.asList(Schulgliederung.A12, Schulgliederung.B06, Schulgliederung.B07, Schulgliederung.C03, Schulgliederung.C05, Schulgliederung.C06, Schulgliederung.D02), null, null)}),
    SBO_9_1(new KAOAMerkmalEintrag[]{new KAOAMerkmalEintrag(60L, "SBO 9.1", "Praxiselemente in Betrieben, Hochschulen, Institutionen", KAOAKategorie.SBO_9, KAOAMerkmaleOptionsarten.KEINE, Arrays.asList(Schulgliederung.A12, Schulgliederung.B06, Schulgliederung.B07, Schulgliederung.C03, Schulgliederung.C05, Schulgliederung.C06, Schulgliederung.D02), null, null)}),
    SBO_9_2(new KAOAMerkmalEintrag[]{new KAOAMerkmalEintrag(61L, "SBO 9.2", "Studienorientierung", KAOAKategorie.SBO_9, KAOAMerkmaleOptionsarten.KEINE, Arrays.asList(Schulgliederung.C03, Schulgliederung.C05, Schulgliederung.C06, Schulgliederung.D02), null, null)}),
    SBO_9_3(new KAOAMerkmalEintrag[]{new KAOAMerkmalEintrag(62L, "SBO 9.3", "St\u00e4rkung der Entscheidungskompetenz II - Sek. II", KAOAKategorie.SBO_9, KAOAMerkmaleOptionsarten.KEINE, Arrays.asList(Schulgliederung.A12, Schulgliederung.B06, Schulgliederung.B07, Schulgliederung.C03, Schulgliederung.C05, Schulgliederung.C06, Schulgliederung.D02), null, null)}),
    SBO_10_1(new KAOAMerkmalEintrag[]{new KAOAMerkmalEintrag(63L, "SBO 10.1", "Bewerbungsphase", KAOAKategorie.SBO_10, KAOAMerkmaleOptionsarten.KEINE, Arrays.asList(Schulgliederung.A12, Schulgliederung.B06, Schulgliederung.B07, Schulgliederung.C03, Schulgliederung.C05, Schulgliederung.C06, Schulgliederung.D02), null, null)}),
    SBO_10_2(new KAOAMerkmalEintrag[]{new KAOAMerkmalEintrag(64L, "SBO 10.2", "STAR \u2013 Arbeitsplatzbezogenes Kommunikationstraining II im F\u00f6rderschwerpunkt H\u00f6ren und Kommunikation", KAOAKategorie.SBO_10, KAOAMerkmaleOptionsarten.KEINE, Arrays.asList(new Schulgliederung[0]), null, null)}),
    SBO_10_3(new KAOAMerkmalEintrag[]{new KAOAMerkmalEintrag(65L, "SBO 10.3", "STAR \u2013 Betriebsnahes Bewerbungstraining/Umgang mit Dolmetschenden und Technik im F\u00f6rderschwerpunkt H\u00f6ren und Kommunikation", KAOAKategorie.SBO_10, KAOAMerkmaleOptionsarten.KEINE, Arrays.asList(new Schulgliederung[0]), null, null)}),
    SBO_10_4(new KAOAMerkmalEintrag[]{new KAOAMerkmalEintrag(66L, "SBO 10.4", "\u00dcbergangsbegleitung", KAOAKategorie.SBO_10, KAOAMerkmaleOptionsarten.KEINE, Arrays.asList(Schulgliederung.A12, Schulgliederung.B06, Schulgliederung.B07, Schulgliederung.C03, Schulgliederung.C05, Schulgliederung.C06, Schulgliederung.D02), null, null)}),
    SBO_10_5(new KAOAMerkmalEintrag[]{new KAOAMerkmalEintrag(67L, "SBO 10.5", "STAR - \u00dcbergangsbegleitung", KAOAKategorie.SBO_10, KAOAMerkmaleOptionsarten.KEINE, Arrays.asList(new Schulgliederung[0]), null, null)}),
    SBO_10_6(new KAOAMerkmalEintrag[]{new KAOAMerkmalEintrag(68L, "SBO 10.6", "Anschlussvereinbarung", KAOAKategorie.SBO_10, KAOAMerkmaleOptionsarten.KEINE, Arrays.asList(Schulgliederung.A12, Schulgliederung.B06, Schulgliederung.B07, Schulgliederung.C03, Schulgliederung.C05, Schulgliederung.C06, Schulgliederung.D02), null, null)}),
    SBO_10_7(new KAOAMerkmalEintrag[]{new KAOAMerkmalEintrag(69L, "SBO 10.7", "Koordinierte \u00dcbergangsgestaltung", KAOAKategorie.SBO_10, KAOAMerkmaleOptionsarten.KEINE, Arrays.asList(Schulgliederung.A12, Schulgliederung.B06, Schulgliederung.B07, Schulgliederung.C03, Schulgliederung.C05, Schulgliederung.C06, Schulgliederung.D02), null, null)});

    public static final long VERSION = 1L;
    @NotNull
    public final KAOAMerkmalEintrag daten;
    @NotNull
    public final @NotNull KAOAMerkmalEintrag @NotNull [] historie;
    @NotNull
    private static final @NotNull HashMap<@NotNull Long, @NotNull KAOAMerkmal> _statusByID;
    @NotNull
    private static final @NotNull HashMap<@NotNull String, @NotNull KAOAMerkmal> _statusByKuerzel;

    private KAOAMerkmal(KAOAMerkmalEintrag[] historie) {
        this.historie = historie;
        this.daten = historie[historie.length - 1];
    }

    @NotNull
    private static @NotNull HashMap<@NotNull Long, @NotNull KAOAMerkmal> getMapStatusByID() {
        if (_statusByID.size() == 0) {
            for (KAOAMerkmal g : KAOAMerkmal.values()) {
                _statusByID.put(g.daten.id, g);
            }
        }
        return _statusByID;
    }

    @NotNull
    private static @NotNull HashMap<@NotNull String, @NotNull KAOAMerkmal> getMapStatusByKuerzel() {
        if (_statusByKuerzel.size() == 0) {
            for (KAOAMerkmal g : KAOAMerkmal.values()) {
                _statusByKuerzel.put(g.daten.kuerzel, g);
            }
        }
        return _statusByKuerzel;
    }

    public static KAOAMerkmal getByID(Long id) {
        return KAOAMerkmal.getMapStatusByID().get(id);
    }

    public static KAOAMerkmal getByKuerzel(String kuerzel) {
        return KAOAMerkmal.getMapStatusByKuerzel().get(kuerzel);
    }

    static {
        _statusByID = new HashMap();
        _statusByKuerzel = new HashMap();
    }
}

