/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.types.klassen;

import de.svws_nrw.core.adt.Pair;
import de.svws_nrw.core.data.klassen.KlassenartKatalogEintrag;
import de.svws_nrw.core.data.schule.SchulformSchulgliederung;
import de.svws_nrw.core.types.schule.Schulform;
import de.svws_nrw.core.types.schule.Schulgliederung;
import jakarta.validation.constraints.NotNull;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public enum Klassenart {
    UNDEFINIERT(new KlassenartKatalogEintrag[]{new KlassenartKatalogEintrag(0L, "**", "Kein Eintrag", Arrays.asList(new Pair<Schulform, Schulgliederung>(Schulform.WB, null)), null, null)}),
    HA_1A(new KlassenartKatalogEintrag[]{new KlassenartKatalogEintrag(1000L, "1A", "Klasse 10 Typ A (Hauptschule)", Arrays.asList(new Pair<Schulform, Schulgliederung>(Schulform.H, null), new Pair<Schulform, Schulgliederung>(Schulform.GM, Schulgliederung.H), new Pair<Schulform, Schulgliederung>(Schulform.R, Schulgliederung.H), new Pair<Schulform, Schulgliederung>(Schulform.SK, Schulgliederung.H), new Pair<Schulform, Schulgliederung>(Schulform.V, null)), null, null)}),
    HA_1B(new KlassenartKatalogEintrag[]{new KlassenartKatalogEintrag(2000L, "1B", "Klasse 10 Typ B (Hauptschule)", Arrays.asList(new Pair<Schulform, Schulgliederung>(Schulform.H, null), new Pair<Schulform, Schulgliederung>(Schulform.GM, Schulgliederung.H), new Pair<Schulform, Schulgliederung>(Schulform.SK, Schulgliederung.H), new Pair<Schulform, Schulgliederung>(Schulform.V, null)), null, null)}),
    HA_AB(new KlassenartKatalogEintrag[]{new KlassenartKatalogEintrag(3000L, "AB", "Klassen im Jahrgang 10 ohne Differenzierung in Typ A und Typ B (Hauptschule)", Arrays.asList(new Pair<Schulform, Schulgliederung>(Schulform.H, null), new Pair<Schulform, Schulgliederung>(Schulform.GM, Schulgliederung.H), new Pair<Schulform, Schulgliederung>(Schulform.SK, Schulgliederung.H), new Pair<Schulform, Schulgliederung>(Schulform.V, null)), null, null)}),
    AM(new KlassenartKatalogEintrag[]{new KlassenartKatalogEintrag(4000L, "AM", "Fr\u00fchf\u00f6rderung: SKG (Ambulante Ma\u00dfnahmen f\u00fcr blinde, geh\u00f6rlose, sehbeh. und schwerh. Kinder)", Arrays.asList(new Pair<Schulform, Schulgliederung>(Schulform.KS, null), new Pair<Schulform, Schulgliederung>(Schulform.S, null)), null, null)}),
    PG(new KlassenartKatalogEintrag[]{new KlassenartKatalogEintrag(5000L, "PG", "Fr\u00fchf\u00f6rderung: SKG (Pr\u00e4senzgruppe)", Arrays.asList(new Pair<Schulform, Schulgliederung>(Schulform.KS, null), new Pair<Schulform, Schulgliederung>(Schulform.S, null)), null, null)}),
    PK(new KlassenartKatalogEintrag[]{new KlassenartKatalogEintrag(6000L, "PK", "Profilklasse (gem\u00e4\u00df \u00a7 21 Abs. 3 APO-S I)", Arrays.asList(new Pair<Schulform, Schulgliederung>(Schulform.GY, null), new Pair<Schulform, Schulgliederung>(Schulform.GE, Schulgliederung.GY9), new Pair<Schulform, Schulgliederung>(Schulform.SK, Schulgliederung.GY)), null, null)}),
    RK(new KlassenartKatalogEintrag[]{new KlassenartKatalogEintrag(7000L, "RK", "Regelklasse", Arrays.asList(new Pair<Schulform, Schulgliederung>(Schulform.FW, null), new Pair<Schulform, Schulgliederung>(Schulform.HI, null), new Pair<Schulform, Schulgliederung>(Schulform.WF, null), new Pair<Schulform, Schulgliederung>(Schulform.G, null), new Pair<Schulform, Schulgliederung>(Schulform.GE, null), new Pair<Schulform, Schulgliederung>(Schulform.GM, null), new Pair<Schulform, Schulgliederung>(Schulform.GY, null), new Pair<Schulform, Schulgliederung>(Schulform.H, null), new Pair<Schulform, Schulgliederung>(Schulform.PS, null), new Pair<Schulform, Schulgliederung>(Schulform.R, null), new Pair<Schulform, Schulgliederung>(Schulform.S, null), new Pair<Schulform, Schulgliederung>(Schulform.KS, null), new Pair<Schulform, Schulgliederung>(Schulform.SG, null), new Pair<Schulform, Schulgliederung>(Schulform.SK, null), new Pair<Schulform, Schulgliederung>(Schulform.SR, null), new Pair<Schulform, Schulgliederung>(Schulform.V, null)), null, null)}),
    SG(new KlassenartKatalogEintrag[]{new KlassenartKatalogEintrag(8000L, "SG", "Deutschf\u00f6rderklasse (gem\u00e4\u00df BASS 13-63 Nr. 3, Nummer 3.5.1)", Arrays.asList(new Pair<Schulform, Schulgliederung>(Schulform.G, null), new Pair<Schulform, Schulgliederung>(Schulform.GE, null), new Pair<Schulform, Schulgliederung>(Schulform.GM, null), new Pair<Schulform, Schulgliederung>(Schulform.GY, null), new Pair<Schulform, Schulgliederung>(Schulform.H, null), new Pair<Schulform, Schulgliederung>(Schulform.PS, null), new Pair<Schulform, Schulgliederung>(Schulform.R, null), new Pair<Schulform, Schulgliederung>(Schulform.S, null), new Pair<Schulform, Schulgliederung>(Schulform.KS, null), new Pair<Schulform, Schulgliederung>(Schulform.SG, null), new Pair<Schulform, Schulgliederung>(Schulform.SK, null), new Pair<Schulform, Schulgliederung>(Schulform.SR, null), new Pair<Schulform, Schulgliederung>(Schulform.V, null)), null, null)});

    public static final long VERSION = 1L;
    @NotNull
    public final KlassenartKatalogEintrag daten;
    @NotNull
    public final @NotNull KlassenartKatalogEintrag @NotNull [] historie;
    @NotNull
    private static final @NotNull HashMap<@NotNull Long, @NotNull Klassenart> _mapID;
    @NotNull
    private static final @NotNull HashMap<@NotNull String, @NotNull Klassenart> _mapKuerzel;
    @NotNull
    private final @NotNull ArrayList<@NotNull Pair<Schulform, Schulgliederung>> @NotNull [] zulaessig;

    private Klassenart(KlassenartKatalogEintrag[] historie) {
        this.historie = historie;
        this.daten = historie[historie.length - 1];
        this.zulaessig = (ArrayList[])Array.newInstance(ArrayList.class, historie.length);
        for (int i = 0; i < historie.length; ++i) {
            this.zulaessig[i] = new ArrayList();
            for (SchulformSchulgliederung kuerzelSfSgl : historie[i].zulaessig) {
                Schulform sf = Schulform.getByKuerzel(kuerzelSfSgl.schulform);
                if (sf == null) continue;
                Schulgliederung sgl = kuerzelSfSgl.gliederung == null ? null : Schulgliederung.getByKuerzel(kuerzelSfSgl.gliederung);
                this.zulaessig[i].add(new Pair<Schulform, Schulgliederung>(sf, sgl));
            }
        }
    }

    @NotNull
    private static @NotNull HashMap<@NotNull Long, @NotNull Klassenart> getMapByID() {
        if (_mapID.size() == 0) {
            for (Klassenart s : Klassenart.values()) {
                if (s.daten == null) continue;
                _mapID.put(s.daten.id, s);
            }
        }
        return _mapID;
    }

    @NotNull
    private static @NotNull HashMap<@NotNull String, @NotNull Klassenart> getMapByKuerzel() {
        if (_mapKuerzel.size() == 0) {
            for (Klassenart s : Klassenart.values()) {
                if (s.daten == null) continue;
                _mapKuerzel.put(s.daten.kuerzel, s);
            }
        }
        return _mapKuerzel;
    }

    private boolean hasSchulform(Schulform schulform) {
        if (schulform == null || schulform.daten == null) {
            return false;
        }
        for (Pair<Schulform, Schulgliederung> sfsgl : this.zulaessig[0]) {
            if (sfsgl.a != schulform) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static @NotNull List<@NotNull Klassenart> get(Schulform schulform) {
        @NotNull ArrayList<@NotNull Klassenart> kursarten = new ArrayList<Klassenart>();
        if (schulform == null) {
            return kursarten;
        }
        for (Klassenart kursart : Klassenart.values()) {
            if (!kursart.hasSchulform(schulform)) continue;
            kursarten.add(kursart);
        }
        return kursarten;
    }

    @NotNull
    public @NotNull List<@NotNull Pair<Schulform, Schulgliederung>> getGliederungen() {
        return this.zulaessig[0];
    }

    public static Klassenart getByKuerzel(String kuerzel) {
        return Klassenart.getMapByKuerzel().get(kuerzel);
    }

    static {
        _mapID = new HashMap();
        _mapKuerzel = new HashMap();
    }
}

