/*
 * Decompiled with CFR 0.152.
 */
package de.svws_nrw.core.types.kursblockung;

import de.svws_nrw.core.data.gost.GostBlockungRegel;
import de.svws_nrw.core.types.kursblockung.GostKursblockungRegelParameterTyp;
import jakarta.validation.constraints.NotNull;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public enum GostKursblockungRegelTyp {
    UNDEFINIERT(0, "Undefiniert", Collections.emptyList()),
    KURSART_SPERRE_SCHIENEN_VON_BIS(1, "Kursart: Sperre Schienen von/bis", Arrays.asList(GostKursblockungRegelParameterTyp.KURSART, GostKursblockungRegelParameterTyp.SCHIENEN_NR, GostKursblockungRegelParameterTyp.SCHIENEN_NR)),
    KURSART_ALLEIN_IN_SCHIENEN_VON_BIS(6, "Kursart: Allein in Schienen von/bis", Arrays.asList(GostKursblockungRegelParameterTyp.KURSART, GostKursblockungRegelParameterTyp.SCHIENEN_NR, GostKursblockungRegelParameterTyp.SCHIENEN_NR)),
    KURS_FIXIERE_IN_SCHIENE(2, "Kurs: Fixiere in Schiene", Arrays.asList(GostKursblockungRegelParameterTyp.KURS_ID, GostKursblockungRegelParameterTyp.SCHIENEN_NR)),
    KURS_SPERRE_IN_SCHIENE(3, "Kurs: Sperre in Schiene", Arrays.asList(GostKursblockungRegelParameterTyp.KURS_ID, GostKursblockungRegelParameterTyp.SCHIENEN_NR)),
    SCHUELER_FIXIEREN_IN_KURS(4, "Sch\u00fcler: Fixiere in Kurs", Arrays.asList(GostKursblockungRegelParameterTyp.SCHUELER_ID, GostKursblockungRegelParameterTyp.KURS_ID)),
    SCHUELER_VERBIETEN_IN_KURS(5, "Sch\u00fcler: Verbiete in Kurs", Arrays.asList(GostKursblockungRegelParameterTyp.SCHUELER_ID, GostKursblockungRegelParameterTyp.KURS_ID)),
    KURS_VERBIETEN_MIT_KURS(7, "Kurs: Verbiete mit Kurs in gleicher Schiene", Arrays.asList(GostKursblockungRegelParameterTyp.KURS_ID, GostKursblockungRegelParameterTyp.KURS_ID)),
    KURS_ZUSAMMEN_MIT_KURS(8, "Kurs: Zusammen mit Kurs in gleicher Schiene", Arrays.asList(GostKursblockungRegelParameterTyp.KURS_ID, GostKursblockungRegelParameterTyp.KURS_ID)),
    KURS_MIT_DUMMY_SUS_AUFFUELLEN(9, "Kurs: F\u00fclle mit Dummy-SuS auf", Arrays.asList(GostKursblockungRegelParameterTyp.KURS_ID, GostKursblockungRegelParameterTyp.GANZZAHL)),
    LEHRKRAEFTE_BEACHTEN(10, "Lehrkr\u00e4fte beachten", Arrays.asList(new GostKursblockungRegelParameterTyp[0]));

    public final int typ;
    public final String bezeichnung;
    @NotNull
    private final @NotNull List<@NotNull GostKursblockungRegelParameterTyp> paramTypes;
    @NotNull
    private static final @NotNull HashMap<@NotNull Integer, @NotNull GostKursblockungRegelTyp> _map_id_regel;

    @NotNull
    private static @NotNull HashMap<@NotNull Integer, @NotNull GostKursblockungRegelTyp> getMap() {
        if (_map_id_regel.isEmpty()) {
            for (GostKursblockungRegelTyp gostTyp : GostKursblockungRegelTyp.values()) {
                _map_id_regel.put(gostTyp.typ, gostTyp);
            }
        }
        return _map_id_regel;
    }

    @NotNull
    public static @NotNull Collection<@NotNull GostKursblockungRegelTyp> getCollection() {
        return GostKursblockungRegelTyp.getMap().values();
    }

    private GostKursblockungRegelTyp(@NotNull /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @NotNull @NotNull int id, String bezeichnung, List<GostKursblockungRegelParameterTyp> paramTypes) throws IllegalArgumentException {
        this.typ = id;
        this.bezeichnung = bezeichnung;
        this.paramTypes = paramTypes;
    }

    @NotNull
    public static GostKursblockungRegelTyp fromTyp(Integer id) {
        if (id == null) {
            return UNDEFINIERT;
        }
        GostKursblockungRegelTyp gostTyp = GostKursblockungRegelTyp.getMap().get(id);
        if (gostTyp == null) {
            return UNDEFINIERT;
        }
        return gostTyp;
    }

    public int getParamCount() {
        return this.paramTypes.size();
    }

    @NotNull
    public GostKursblockungRegelParameterTyp getParamType(int i) throws IllegalArgumentException {
        if (i < 0 || i >= this.paramTypes.size()) {
            throw new IllegalArgumentException("Ein Parameter mit dem Index i existiert nicht f\u00fcr den Regel-Typ " + this.name());
        }
        return this.paramTypes.get(i);
    }

    public boolean hasParamType(GostKursblockungRegelParameterTyp paramType) {
        for (GostKursblockungRegelParameterTyp cur : this.paramTypes) {
            if (paramType != cur) continue;
            return true;
        }
        return false;
    }

    public static long[] getNeueParameterBeiSchienenLoeschung(@NotNull GostBlockungRegel pRegel, int pSchienenNr) {
        @NotNull GostKursblockungRegelTyp typ = GostKursblockungRegelTyp.fromTyp(pRegel.typ);
        @NotNull List<@NotNull Long> param = pRegel.parameter;
        switch (typ.ordinal()) {
            case 10: {
                return new long[0];
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                return new long[]{param.get(0), param.get(1)};
            }
            case 3: 
            case 4: {
                if ((long)pSchienenNr > param.get(1)) {
                    return new long[]{param.get(0), param.get(1)};
                }
                if ((long)pSchienenNr < param.get(1)) {
                    return new long[]{param.get(0), param.get(1) - 1L};
                }
                return null;
            }
            case 1: 
            case 2: {
                long von = param.get(1);
                long bis = param.get(2);
                von = (long)pSchienenNr < von ? von - 1L : von;
                long l = bis = (long)pSchienenNr <= bis ? bis - 1L : bis;
                if (von <= bis) {
                    return new long[]{param.get(0), von, bis};
                }
                return null;
            }
        }
        throw new IllegalStateException("Der Regel-Typ ist unbekannt: " + String.valueOf((Object)typ));
    }

    static {
        _map_id_regel = new HashMap();
    }
}

